/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.Mixins;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import java.util.function.Consumer;
import net.hrodebert.mots.ModEntities.custom.MadeInHeaven;
import net.hrodebert.mots.ModEntities.custom.StandEntity;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.NeoForgeConfig;
import net.neoforged.neoforge.server.timings.TimeTracker;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Level.class})
public class LevelMixin<T extends Entity> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"guardEntityTick"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void shouldRender(Consumer<T> consumerEntity, T entity, CallbackInfo ci) {
        block20: {
            try {
                LivingEntity entity1;
                Optional<StandEntity> stand;
                if (!entity.hasData(Attachments.SPEED)) {
                    entity.setData(Attachments.SPEED, (Object)Float.valueOf(100.0f));
                }
                if (!entity.hasData(Attachments.TICK)) {
                    entity.setData(Attachments.TICK, (Object)Float.valueOf(0.0f));
                }
                Float speed = (Float)entity.getData(Attachments.SPEED);
                Float tick = (Float)entity.getData(Attachments.TICK);
                float tickSpeed = 20.0f * speed.floatValue() / 100.0f;
                double status = Math.cos(tick.floatValue() * (20.0f - tickSpeed)) / 20.0;
                Float f = tick;
                tick = Float.valueOf(tick.floatValue() + 1.0f);
                if (tick.floatValue() > 20.0f) {
                    tick = Float.valueOf(0.0f);
                }
                entity.setData(Attachments.TICK, (Object)tick);
                if (status < 0.0) {
                    ci.cancel();
                }
                if (!(entity instanceof LivingEntity) || !(stand = StandHandler.getStand(entity1 = (LivingEntity)entity)).isPresent() || !((status = stand.get()) instanceof MadeInHeaven)) break block20;
                MadeInHeaven mih = (MadeInHeaven)status;
                if (entity instanceof MadeInHeaven) {
                    return;
                }
                if (mih.getAccel() <= 0 || ((Float)entity.getData(Attachments.SPEED)).floatValue() == 101.0f) break block20;
                ci.cancel();
                int speed2 = mih.getAccel();
                int finalSpeed = speed2 = Math.min(150, speed2);
                try {
                    mih.increaseCounter();
                    TimeTracker.ENTITY_UPDATE.trackStart(entity);
                    consumerEntity.accept(entity);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Ticking entity");
                    CrashReportCategory crashreportcategory = crashreport.addCategory("Entity being ticked");
                    entity.fillCrashReportCategory(crashreportcategory);
                    if (!((Boolean)NeoForgeConfig.SERVER.removeErroringEntities.get()).booleanValue()) {
                        throw new ReportedException(crashreport);
                    }
                    LogUtils.getLogger().error("{}", (Object)crashreport.getFriendlyReport(ReportType.CRASH));
                    entity.discard();
                }
                finally {
                    TimeTracker.ENTITY_UPDATE.trackEnd(entity);
                }
                for (int i = 0; i < finalSpeed / 20; ++i) {
                    try {
                        TimeTracker.ENTITY_UPDATE.trackStart(entity);
                        consumerEntity.accept(entity);
                        continue;
                    }
                    catch (Throwable throwable) {
                        CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Ticking entity");
                        CrashReportCategory crashreportcategory = crashreport.addCategory("Entity being ticked");
                        entity.fillCrashReportCategory(crashreportcategory);
                        if (!((Boolean)NeoForgeConfig.SERVER.removeErroringEntities.get()).booleanValue()) {
                            throw new ReportedException(crashreport);
                        }
                        LogUtils.getLogger().error("{}", (Object)crashreport.getFriendlyReport(ReportType.CRASH));
                        entity.discard();
                        continue;
                    }
                    finally {
                        TimeTracker.ENTITY_UPDATE.trackEnd(entity);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

