/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.Mixins;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.hrodebert.mots.ModEntities.custom.Cmoon;
import net.hrodebert.mots.MotsApi.Attachments;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={net.minecraft.client.renderer.entity.LivingEntityRenderer.class})
public abstract class LivingEntityRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends EntityRenderer<T> {
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);

    @Shadow
    public abstract void render(T var1, float var2, float var3, PoseStack var4, MultiBufferSource var5, int var6);

    protected LivingEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    @Inject(method={"isEntityUpsideDown"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void isEntityUpsideDown(LivingEntity entity, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)false);
        entity.level().getEntities((Entity)entity, entity.getBoundingBox().inflate(100.0)).forEach(e -> {
            Cmoon c;
            if (e instanceof Cmoon && (c = (Cmoon)((Object)e)).isGravityInverted() && !e.getPassengers().contains((Object)c)) {
                cir.setReturnValue((Object)((Boolean)cir.getReturnValue() == false ? 1 : 0));
            }
        });
    }

    @Inject(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void isEntityUpsideDown(T entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        if (entity.hasData(Attachments.RAY_ANIMATION_TICK)) {
            double y = entity.getEyeY() - entity.getY();
            poseStack.pushPose();
            poseStack.translate(0.0, y, 0.0);
            LivingEntityRenderer.renderRays(poseStack, -Math.abs((float)(2.0 * Math.sin((double)((Float)entity.getData(Attachments.RAY_ANIMATION_TICK)).floatValue() / 20.0))), buffer.getBuffer(RenderType.DRAGON_RAYS));
            poseStack.popPose();
        }
    }

    private static void renderRays(PoseStack poseStack, float f, VertexConsumer vertexConsumer) {
        poseStack.pushPose();
        float g = Math.min(f > 0.8f ? (f - 0.8f) / 0.2f : 0.0f, 1.0f);
        int i = FastColor.ARGB32.colorFromFloat((float)(1.0f - g), (float)1.0f, (float)0.0f, (float)0.0f);
        int j = 0xFF00FF;
        RandomSource randomSource = RandomSource.create((long)432L);
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        Quaternionf quaternionf = new Quaternionf();
        int k = Mth.floor((float)((f + f * f) / 2.0f * 60.0f));
        for (int l = 0; l < k; ++l) {
            quaternionf.rotationXYZ(randomSource.nextFloat() * ((float)Math.PI * 2), randomSource.nextFloat() * ((float)Math.PI * 2), randomSource.nextFloat() * ((float)Math.PI * 2)).rotateXYZ(randomSource.nextFloat() * ((float)Math.PI * 2), randomSource.nextFloat() * ((float)Math.PI * 2), randomSource.nextFloat() * ((float)Math.PI * 2) + f * 1.5707964f);
            poseStack.mulPose(quaternionf);
            float h = randomSource.nextFloat() * 20.0f + 5.0f + g * 10.0f;
            float m = randomSource.nextFloat() * 2.0f + 1.0f + g * 2.0f;
            vector3f2.set(-HALF_SQRT_3 * m, h, -0.5f * m);
            vector3f3.set(HALF_SQRT_3 * m, h, -0.5f * m);
            vector3f4.set(0.0f, h, m);
            PoseStack.Pose pose = poseStack.last();
            vertexConsumer.addVertex(pose, vector3f).setColor(i);
            int green = -12972273;
            vertexConsumer.addVertex(pose, vector3f2).setColor(green);
            vertexConsumer.addVertex(pose, vector3f3).setColor(green);
            vertexConsumer.addVertex(pose, vector3f).setColor(i);
            vertexConsumer.addVertex(pose, vector3f3).setColor(green);
            vertexConsumer.addVertex(pose, vector3f4).setColor(green);
            vertexConsumer.addVertex(pose, vector3f).setColor(i);
            vertexConsumer.addVertex(pose, vector3f4).setColor(green);
            vertexConsumer.addVertex(pose, vector3f2).setColor(green);
        }
        poseStack.popPose();
    }
}

