/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.Mixins;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.Queue;
import java.util.function.Predicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Camera;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.TextureManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ParticleEngine.class})
public class ParticleEngineMixin {
    @Final
    @Shadow
    private Map<ParticleRenderType, Queue<Particle>> particles;
    @Final
    @Shadow
    private TextureManager textureManager;

    @Inject(method={"render*"}, at={@At(value="HEAD")}, remap=false)
    private void renderEngine(LightTexture lightTexture, Camera camera, float partialTick, Frustum frustum, Predicate<ParticleRenderType> renderTypePredicate, CallbackInfo ci) {
        lightTexture.turnOnLightLayer();
        RenderSystem.enableDepthTest();
        RenderSystem.activeTexture((int)33986);
        RenderSystem.activeTexture((int)33984);
        for (ParticleRenderType particlerendertype : this.particles.keySet()) {
            Queue<Particle> queue;
            if (particlerendertype == ParticleRenderType.NO_RENDER || !renderTypePredicate.test(particlerendertype) || (queue = this.particles.get(particlerendertype)) == null || queue.isEmpty()) continue;
            RenderSystem.setShader(GameRenderer::getParticleShader);
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder bufferbuilder = particlerendertype.begin(tesselator, this.textureManager);
            if (bufferbuilder == null) continue;
            for (Particle particle : queue) {
                try {
                    particle.render((VertexConsumer)bufferbuilder, camera, partialTick);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Rendering Particle");
                    CrashReportCategory crashreportcategory = crashreport.addCategory("Particle being rendered");
                    crashreportcategory.setDetail("Particle", () -> ((Particle)particle).toString());
                    crashreportcategory.setDetail("Particle Type", () -> ((ParticleRenderType)particlerendertype).toString());
                    throw new ReportedException(crashreport);
                }
            }
            MeshData meshdata = bufferbuilder.build();
            if (meshdata == null) continue;
            BufferUploader.drawWithShader((MeshData)meshdata);
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        lightTexture.turnOffLightLayer();
    }
}

