/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.ModEntities.custom;

import net.hrodebert.mots.ModEntities.ModEntities;
import net.hrodebert.mots.ModEntities.custom.StandEntity;
import net.hrodebert.mots.MotsApi.Events.OnStandTimedAbilityEvent;
import net.hrodebert.mots.MotsApi.Skills.Cmoon.CmoonSkills;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class Cmoon
extends StandEntity
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> SHOULD_RESET = SynchedEntityData.defineId(Cmoon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(Cmoon.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Boolean> GRAVITY_INVERTED = SynchedEntityData.defineId(Cmoon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> REPULSION = SynchedEntityData.defineId(Cmoon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ANIMATION, (Object)"none");
        builder.define(SHOULD_RESET, (Object)false);
        builder.define(GRAVITY_INVERTED, (Object)false);
        builder.define(REPULSION, (Object)0);
    }

    public boolean canControlVehicle() {
        return false;
    }

    public boolean isRepulsing() {
        return (Integer)this.entityData.get(REPULSION) > 0;
    }

    public void setRepulsion(int time) {
        this.entityData.set(REPULSION, (Object)time);
    }

    public void switchGravity() {
        this.entityData.set(GRAVITY_INVERTED, (Object)((Boolean)this.entityData.get(GRAVITY_INVERTED) == false ? 1 : 0));
    }

    public boolean isGravityInverted() {
        return (Boolean)this.entityData.get(GRAVITY_INVERTED);
    }

    @Override
    public boolean canStandFly() {
        return false;
    }

    public Cmoon(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    public static AttributeSupplier setAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.4f).build();
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob ageableMob) {
        return (AgeableMob)ModEntities.D4C.get().create((Level)level);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        Boolean shouldReset = (Boolean)this.entityData.get(SHOULD_RESET);
        if (shouldReset.booleanValue()) {
            tAnimationState.getController().forceAnimationReset();
            shouldReset = false;
            String animation = (String)this.entityData.get(ANIMATION);
            if (animation.equals("uppercut")) {
                animation = "none";
                tAnimationState.getController().setAnimation(RawAnimation.begin().then("upper cut", Animation.LoopType.PLAY_ONCE));
            } else if (animation.equals("arm_crusher")) {
                animation = "none";
                tAnimationState.getController().setAnimation(RawAnimation.begin().then("arm crusher", Animation.LoopType.PLAY_ONCE));
            }
            this.entityData.set(ANIMATION, (Object)animation);
            this.entityData.set(SHOULD_RESET, (Object)shouldReset);
        }
        try {
            if (tAnimationState.getController().hasAnimationFinished() || this.tickCount < 20) {
                tAnimationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            } else if (tAnimationState.getController().getCurrentAnimation().animation().length() == 0.0) {
                tAnimationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            }
        }
        catch (Exception e) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public boolean onGround() {
        return super.onGround();
    }

    @Override
    public int maxDistanceFromUser() {
        return 45;
    }

    @Override
    public void tick() {
        try {
            if (this.isRepulsing()) {
                this.entityData.set(REPULSION, (Object)((Integer)this.entityData.get(REPULSION) - 1));
                if (!this.isRepulsing() && this.getVehicle() != null && this.getVehicle() instanceof LivingEntity) {
                    OnStandTimedAbilityEvent.Pre eventPost = new OnStandTimedAbilityEvent.Pre((int)(20.0 * StandHandler.getStandSpecial((LivingEntity)this.getVehicle())) + 20, new CmoonSkills.GravityAbility());
                    eventPost.source = (LivingEntity)this.getVehicle();
                    NeoForge.EVENT_BUS.post((Event)eventPost);
                }
            }
            if (this.getVehicle() != null) {
                Entity player = this.getVehicle();
                this.setXRot(player.getXRot());
                this.setYRot(player.getYRot());
                this.setYBodyRot(player.getYRot());
                this.setYHeadRot(player.getYRot());
                if (this.getVehicle().getAirSupply() <= 0) {
                    // empty if block
                }
            }
            if (this.isRepulsing()) {
                this.level().getEntities((Entity)this, this.getBoundingBox().inflate(5.0)).forEach(entity -> {
                    if (this.getVehicle() != entity) {
                        double speedX = 0.0;
                        double speedY = 0.0;
                        double speedZ = 0.0;
                        double speed = 0.3;
                        speedX = entity.position().x > this.position().x ? speed : -speed;
                        speedY = entity.position().y > this.position().y ? speed : -speed;
                        speedZ = entity.position().z > this.position().z ? speed : -speed;
                        entity.setDeltaMovement(speedX, speedY, speedZ);
                        entity.hurtMarked = true;
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.tick();
    }

    public void uppercut() {
        this.entityData.set(SHOULD_RESET, (Object)true, true);
        this.entityData.set(ANIMATION, (Object)"uppercut", true);
    }

    public void armCrusher() {
        this.entityData.set(SHOULD_RESET, (Object)true, true);
        this.entityData.set(ANIMATION, (Object)"arm_crusher", true);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public ResourceLocation getStandUserEntitySkin() {
        return ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/users/pucci.png");
    }
}

