/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.ModEntities.custom;

import java.util.List;
import net.hrodebert.mots.ModDimensions.ModDimensions;
import net.hrodebert.mots.ModEntities.ModEntities;
import net.hrodebert.mots.ModEntities.custom.StandEntity;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class D4c
extends StandEntity
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> LOVE_TRAIN = SynchedEntityData.defineId(D4c.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SHOULD_RESET = SynchedEntityData.defineId(D4c.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_TRYING_TO_TRAVEL = SynchedEntityData.defineId(D4c.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(D4c.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> TRAVEL_TICK = SynchedEntityData.defineId(D4c.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LOVE_TRAIN, (Object)false);
        builder.define(IS_TRYING_TO_TRAVEL, (Object)false);
        builder.define(ANIMATION, (Object)"none");
        builder.define(TRAVEL_TICK, (Object)0);
        builder.define(SHOULD_RESET, (Object)false);
    }

    public boolean canControlVehicle() {
        return false;
    }

    public boolean loveTrain() {
        return (Boolean)this.entityData.get(LOVE_TRAIN);
    }

    public void startLoveTrain() {
        this.entityData.set(LOVE_TRAIN, (Object)true);
    }

    public void stopLoveTrain() {
        this.entityData.set(LOVE_TRAIN, (Object)false);
    }

    public D4c(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    public static AttributeSupplier setAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.4f).build();
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob ageableMob) {
        return (AgeableMob)ModEntities.D4C.get().create((Level)level);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        Boolean shouldReset = (Boolean)this.entityData.get(SHOULD_RESET);
        if (shouldReset.booleanValue()) {
            tAnimationState.getController().forceAnimationReset();
            shouldReset = false;
            String animation = (String)this.entityData.get(ANIMATION);
            if (animation.equals("chop")) {
                animation = "none";
                tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.d4c.chop", Animation.LoopType.PLAY_ONCE));
            } else if (animation.equals("finisher")) {
                animation = "none";
                tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.d4c.strong_punch", Animation.LoopType.PLAY_ONCE));
            } else if (animation.equals("travel")) {
                animation = "none";
                tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.d4c.dimensional_travel", Animation.LoopType.PLAY_ONCE));
            }
            this.entityData.set(ANIMATION, (Object)animation);
            this.entityData.set(SHOULD_RESET, (Object)shouldReset);
        }
        try {
            if (tAnimationState.getController().hasAnimationFinished() || this.tickCount < 20) {
                tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.d4c.idle", Animation.LoopType.LOOP));
            } else if (tAnimationState.getController().getCurrentAnimation().animation().length() == 0.0) {
                tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.d4c.idle", Animation.LoopType.LOOP));
            }
        }
        catch (Exception e) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.d4c.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void tick() {
        try {
            if (this.getVehicle() != null) {
                Entity player = this.getVehicle();
                this.setXRot(player.getXRot());
                this.setYRot(player.getYRot());
                this.setYBodyRot(player.getYRot());
                this.setYHeadRot(player.getYRot());
                if (((Boolean)this.entityData.get(IS_TRYING_TO_TRAVEL)).booleanValue()) {
                    if ((Integer)this.entityData.get(TRAVEL_TICK) >= 60) {
                        if (!this.level().isClientSide) {
                            this.entityData.set(IS_TRYING_TO_TRAVEL, (Object)false);
                            this.entityData.set(TRAVEL_TICK, (Object)0);
                        }
                        ResourceKey<Level> resourcekey = player.level().dimension() == ModDimensions.D4C_LEVEL_KEY ? Level.OVERWORLD : ModDimensions.D4C_LEVEL_KEY;
                        ServerLevel serverlevel = ((ServerLevel)player.level()).getServer().getLevel(resourcekey);
                        Vec3 viewVector = player.getViewVector(1.0f);
                        List entity = player.level().getEntities(player, player.getBoundingBox().expandTowards(viewVector.scale(3.0)));
                        for (int i = 0; i < entity.size(); ++i) {
                            LivingEntity instance = (LivingEntity)entity.get(i);
                            instance.teleportTo(serverlevel, ((Entity)entity.get(i)).getX(), ((Entity)entity.get(i)).getY(), ((Entity)entity.get(i)).getZ(), null, ((Entity)entity.get(i)).getYRot(), ((Entity)entity.get(i)).getXRot());
                        }
                        player.teleportTo(serverlevel, player.getX(), player.getY(), player.getZ(), null, player.getYRot(), player.getXRot());
                        if (!this.level().isClientSide && player.hasData(Attachments.HAS_STAND)) {
                            StandHandler.registerSkills((LivingEntity)((Player)player));
                        }
                    } else if (!this.level().isClientSide) {
                        this.getVehicle().setDeltaMovement(new Vec3(0.0, this.getVehicle().getDeltaMovement().y, 0.0));
                        this.getVehicle().hurtMarked = true;
                        this.entityData.set(TRAVEL_TICK, (Object)((Integer)this.entityData.get(TRAVEL_TICK) + 1));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.tick();
    }

    public void chop() {
        this.entityData.set(SHOULD_RESET, (Object)true, true);
        this.entityData.set(ANIMATION, (Object)"chop", true);
    }

    public void finisher() {
        this.entityData.set(SHOULD_RESET, (Object)true, true);
        this.entityData.set(ANIMATION, (Object)"finisher", true);
    }

    public void d4cDimensionalTravel() {
        this.entityData.set(SHOULD_RESET, (Object)true, true);
        this.entityData.set(IS_TRYING_TO_TRAVEL, (Object)true, true);
        this.entityData.set(TRAVEL_TICK, (Object)0, true);
        this.entityData.set(ANIMATION, (Object)"travel", true);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public ResourceLocation getStandUserEntitySkin() {
        return ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/users/funny_valentine.png");
    }
}

