/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.ModEntities.custom.DioBrandoBoss;

import java.util.ArrayList;
import java.util.Random;
import net.hrodebert.mots.ModItems.ModItems;
import net.hrodebert.mots.Mots;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.Skill;
import net.hrodebert.mots.MotsApi.Skills.TheWorld.TwSkills;
import net.hrodebert.mots.ServerQueue.Queue;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class DioBoss
extends Monster {
    private static final EntityDataAccessor<Integer> COOLDOWN = SynchedEntityData.defineId(DioBoss.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private Level level;
    private final ServerBossEvent DioBossBar = new ServerBossEvent((Component)Component.literal((String)"DIO"), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.NOTCHED_20);

    public static AttributeSupplier setAttributes() {
        return Monster.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.9).add(Attributes.MAX_HEALTH, 300.0).add(Attributes.ARMOR, 14.0).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.25).build();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COOLDOWN, (Object)0);
    }

    public void startSeenByPlayer(ServerPlayer serverPlayer) {
        super.startSeenByPlayer(serverPlayer);
        this.DioBossBar.addPlayer(serverPlayer);
    }

    public void stopSeenByPlayer(ServerPlayer serverPlayer) {
        super.stopSeenByPlayer(serverPlayer);
        this.DioBossBar.removePlayer(serverPlayer);
    }

    public DioBoss(EntityType<DioBoss> type, Level world) {
        super(type, world);
        this.xpReward = 120;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        return null;
    }

    public void die(DamageSource damageSource) {
        super.die(damageSource);
        this.spawnAtLocation(new ItemStack((ItemLike)ModItems.DIO_BONE.get()));
    }

    public void aiStep() {
        if (this.isSunBurnTick() && !this.level().isClientSide()) {
            this.getServer().getPlayerList().getPlayers().forEach(p -> {
                p.sendSystemMessage((Component)Component.literal((String)"<DIO> WRYYYYYYYYYYYYYYYY THE WORLD!!! THE TIME IS FROZEN"));
                p.sendSystemMessage((Component)Component.literal((String)"DIO disappears, (boss escaped)").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
            });
            Mots.serverTaskExecutioner.tasks.add(new Queue.Task(0, t -> this.getServer().tickRateManager().setFrozen(true)));
            Mots.serverTaskExecutioner.tasks.add(new Queue.Task(15, t -> this.getServer().tickRateManager().setFrozen(false)));
            this.discard();
        }
        if ((Integer)this.entityData.get(COOLDOWN) > 0) {
            this.entityData.set(COOLDOWN, (Object)((Integer)this.entityData.get(COOLDOWN) - 1));
        } else {
            if (this.getPassengers().isEmpty()) {
                super.aiStep();
                return;
            }
            if (this.getTarget() != null && this.getTarget().distanceTo((Entity)this) < 3.0f && !this.level().isClientSide) {
                ArrayList skills = (ArrayList)this.getData(Attachments.SKILLS);
                Random random = new Random();
                int value = 0;
                if (skills.size() < 1) {
                    TwSkills.getSkills((LivingEntity)this);
                    skills = (ArrayList)this.getData(Attachments.SKILLS);
                    skills.remove(0);
                    value = random.nextInt(0, skills.size());
                    this.setData(Attachments.STAND_SPECIAL_POTENCY, 5.0);
                    this.setData(Attachments.STAND_ATTACK_POTENCY, 10.0);
                } else {
                    value = random.nextInt(0, skills.size());
                }
                ((Skill)skills.get((int)value)).executeSkill.accept((LivingEntity)this);
                this.entityData.set(COOLDOWN, (Object)100);
            }
        }
        super.aiStep();
    }

    public void tick() {
        this.DioBossBar.setProgress(this.getHealth() / this.getMaxHealth());
        super.tick();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(8, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 1.0, true, 4, () -> false));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Ravager.class, true));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Pillager.class, true));
    }

    public double getMyRidingOffset() {
        return -0.35;
    }
}

