/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.ModEntities.custom;

import net.hrodebert.mots.ModEntities.ModEntities;
import net.hrodebert.mots.ModEntities.custom.StandEntity;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class DiverDown
extends StandEntity
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> SHOULD_RESET = SynchedEntityData.defineId(DiverDown.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(DiverDown.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ANIMATION, (Object)"none");
        builder.define(SHOULD_RESET, (Object)false);
    }

    @Override
    public void switchPilot() {
        super.switchPilot();
        this.noPhysics = this.isInPilot();
    }

    @Override
    public int maxDistanceFromUser() {
        return 18;
    }

    public boolean canControlVehicle() {
        return false;
    }

    public DiverDown(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    public static AttributeSupplier setAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.4f).build();
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob ageableMob) {
        return (AgeableMob)ModEntities.D4C.get().create((Level)level);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        Boolean shouldReset = (Boolean)this.entityData.get(SHOULD_RESET);
        if (shouldReset.booleanValue()) {
            tAnimationState.getController().forceAnimationReset();
            shouldReset = false;
            String animation = (String)this.entityData.get(ANIMATION);
            if (animation.equals("chop")) {
                animation = "none";
                tAnimationState.getController().setAnimation(RawAnimation.begin().then("chop", Animation.LoopType.PLAY_ONCE));
            } else if (animation.equals("impale")) {
                animation = "none";
                tAnimationState.getController().setAnimation(RawAnimation.begin().then("strong punch", Animation.LoopType.PLAY_ONCE));
            }
            this.entityData.set(ANIMATION, (Object)animation);
            this.entityData.set(SHOULD_RESET, (Object)shouldReset);
        }
        try {
            if (tAnimationState.getController().hasAnimationFinished() || this.tickCount < 20) {
                tAnimationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            } else if (tAnimationState.getController().getCurrentAnimation().animation().length() == 0.0) {
                tAnimationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            }
        }
        catch (Exception e) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void tick() {
        try {
            if (this.getVehicle() != null) {
                Entity player = this.getVehicle();
                this.setXRot(player.getXRot());
                this.setYRot(player.getYRot());
                this.setYBodyRot(player.getYRot());
                this.setYHeadRot(player.getYRot());
                if (this.getVehicle().getAirSupply() > 0) {
                    // empty if block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.tick();
    }

    public void chop() {
        this.entityData.set(SHOULD_RESET, (Object)true, true);
        this.entityData.set(ANIMATION, (Object)"chop", true);
    }

    public void impale() {
        this.entityData.set(SHOULD_RESET, (Object)true, true);
        this.entityData.set(ANIMATION, (Object)"impale", true);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public ResourceLocation getStandUserEntitySkin() {
        return ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/users/anasui.png");
    }
}

