/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.ModEntities.custom;

import net.hrodebert.mots.ModEntities.ModEntities;
import net.hrodebert.mots.ModEntities.custom.StandEntity;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class MadeInHeaven
extends StandEntity
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> SHOULD_RESET = SynchedEntityData.defineId(MadeInHeaven.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(MadeInHeaven.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> SPEED = SynchedEntityData.defineId(MadeInHeaven.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SPEED_COUNTER = SynchedEntityData.defineId(MadeInHeaven.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> ACCELERATING = SynchedEntityData.defineId(MadeInHeaven.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> UPDATE_CLIENT = SynchedEntityData.defineId(MadeInHeaven.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private boolean dilatation;
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ANIMATION, (Object)"none");
        builder.define(SHOULD_RESET, (Object)false);
        builder.define(UPDATE_CLIENT, (Object)false);
        builder.define(ACCELERATING, (Object)false);
        builder.define(SPEED, (Object)0);
        builder.define(SPEED_COUNTER, (Object)1);
    }

    public boolean canControlVehicle() {
        return false;
    }

    public void startAcceleration() {
        this.entityData.set(ACCELERATING, (Object)true);
        this.setAccel(1);
    }

    public void stopAcceleration() {
        this.entityData.set(ACCELERATING, (Object)false);
    }

    public void dilateTime() {
        this.dilatation = true;
    }

    public void normalizeTime() {
        this.dilatation = false;
    }

    public int getAccel() {
        if (this.getOwner() != null && this.getOwner().hasData(Attachments.SPEED) && ((Float)this.getOwner().getData(Attachments.SPEED)).floatValue() == 101.0f) {
            return 1;
        }
        return (Integer)this.entityData.get(SPEED);
    }

    public void setAccel(int accel) {
        this.entityData.set(SPEED, (Object)accel);
    }

    public void increaseCounter() {
        this.entityData.set(SPEED_COUNTER, (Object)((Integer)this.entityData.get(SPEED_COUNTER) + 1));
    }

    public MadeInHeaven(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    public static AttributeSupplier setAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.4f).build();
    }

    public boolean isAccelerating() {
        return (Boolean)this.entityData.get(ACCELERATING);
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob ageableMob) {
        return (AgeableMob)ModEntities.D4C.get().create((Level)level);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        Boolean shouldReset = (Boolean)this.entityData.get(SHOULD_RESET);
        if (shouldReset.booleanValue()) {
            tAnimationState.getController().forceAnimationReset();
            shouldReset = false;
            String animation = (String)this.entityData.get(ANIMATION);
            if (animation.equals("chop")) {
                animation = "none";
                tAnimationState.getController().setAnimation(RawAnimation.begin().then("chop", Animation.LoopType.PLAY_ONCE));
            } else if (animation.equals("impale")) {
                animation = "none";
                tAnimationState.getController().setAnimation(RawAnimation.begin().then("impale", Animation.LoopType.PLAY_ONCE));
            }
            this.entityData.set(ANIMATION, (Object)animation);
            this.entityData.set(SHOULD_RESET, (Object)shouldReset);
        }
        try {
            if (tAnimationState.getController().hasAnimationFinished() || this.tickCount < 20) {
                tAnimationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            } else if (tAnimationState.getController().getCurrentAnimation().animation().length() == 0.0) {
                tAnimationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            }
        }
        catch (Exception e) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        tAnimationState.getController().setAnimationSpeed((double)Math.max(this.getAccel() / 10, 1));
        return PlayState.CONTINUE;
    }

    @Override
    public void tick() {
        try {
            if ((Integer)this.entityData.get(SPEED) >= 1) {
                if (!this.level().isClientSide() && this.getVehicle() != null) {
                    Integer counter;
                    Player p;
                    Entity entity = this.getVehicle();
                    if (!(entity instanceof Player) || ((Float)(p = (Player)entity).getData(Attachments.SPEED)).floatValue() != 101.0f) {
                        // empty if block
                    }
                    if ((counter = (Integer)this.entityData.get(SPEED_COUNTER)) >= 100) {
                        if (((Boolean)this.entityData.get(ACCELERATING)).booleanValue()) {
                            this.setAccel(this.getAccel() + 1);
                        } else {
                            this.setAccel(this.getAccel() - 1);
                        }
                        this.entityData.set(SPEED_COUNTER, (Object)0);
                        this.getVehicle().setData(Attachments.SKILL, (Object)-1);
                        StandHandler.syncData((LivingEntity)this.getVehicle());
                    }
                }
                this.level().getServer().getAllLevels().forEach(level -> {
                    level.setDayTime(level.getDayTime() + (long)(this.getAccel() / 10));
                    this.level().getServer().getPlayerList().getPlayers().forEach(player -> player.connection.send((Packet)new ClientboundSetTimePacket(level.getGameTime(), level.getDayTime(), true)));
                });
            }
        }
        catch (Exception counter) {
            // empty catch block
        }
        if (this.getVehicle() != null) {
            Entity player = this.getVehicle();
            this.setXRot(player.getXRot());
            this.setYRot(player.getYRot());
            this.setYBodyRot(player.getYRot());
            this.setYHeadRot(player.getYRot());
            if (this.getVehicle().getAirSupply() <= 0) {
                // empty if block
            }
        }
        super.tick();
    }

    public void chop() {
        this.entityData.set(SHOULD_RESET, (Object)true, true);
        this.entityData.set(ANIMATION, (Object)"chop", true);
    }

    public void impale() {
        this.entityData.set(SHOULD_RESET, (Object)true, true);
        this.entityData.set(ANIMATION, (Object)"impale", true);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public ResourceLocation getStandUserEntitySkin() {
        return ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/users/pucci.png");
    }
}

