/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.ModEntities.custom.PlayerClone;

import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import org.jetbrains.annotations.Nullable;

public class D4cPlayerClone
extends TamableAnimal {
    public SimpleContainer armour = new SimpleContainer(4);
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.defineId(D4cPlayerClone.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<String> OWNER_NAME = SynchedEntityData.defineId(D4cPlayerClone.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    @javax.annotation.Nullable
    private static GameProfileCache profileCache;
    private ResourceLocation playerSkin = ResourceLocation.parse((String)"textures/entity/steve.png");
    private Level level;
    boolean skin = false;

    public static AttributeSupplier setAttributes() {
        return Animal.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ARMOR, 14.0).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.25).add(Attributes.ATTACK_KNOCKBACK, 0.5).build();
    }

    public void setOwner(UUID ownerUUUID) {
        this.entityData.set(OWNER, Optional.of(ownerUUUID));
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(OWNER, Optional.of(UUID.fromString("d304be95-225b-495c-b36d-f3db60f8e383")));
        builder.define(OWNER_NAME, (Object)"Okkotsu_Yuta_008");
    }

    public Iterable<ItemStack> getArmorSlots() {
        return Collections.emptyList();
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack stack) {
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("owner_uuid")) {
            this.entityData.set(OWNER, Optional.of(nbt.getUUID("owner_uuid")));
            this.entityData.set(OWNER_NAME, (Object)nbt.getString("name"));
        }
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    public void updatePlayerTexture() {
        if (this.skin) {
            return;
        }
        CompletableFuture future = SkullBlockEntity.fetchGameProfile((UUID)((UUID)((Optional)this.entityData.get(OWNER)).get()));
        try {
            Optional optionalProfile = (Optional)future.get();
            if (optionalProfile.isPresent()) {
                GameProfile profile = (GameProfile)optionalProfile.get();
                System.out.println("Profile fetched: " + String.valueOf(profile));
                PlayerSkin texture = Minecraft.getInstance().getSkinManager().getInsecureSkin(profile);
                System.out.println(texture.texture());
                CompletableFuture futureSkin = Minecraft.getInstance().getSkinManager().getOrLoad(profile);
                futureSkin.thenAccept(consumer -> {
                    this.playerSkin = consumer.texture();
                });
            } else {
                System.out.println("No profile found.");
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        this.skin = true;
        if (Minecraft.getInstance().player == null) {
            return;
        }
        if (((Optional)this.entityData.get(OWNER)).isPresent()) {
            this.playerSkin = DefaultPlayerSkin.getDefaultTexture();
        }
    }

    public ResourceLocation getPlayerSkin() {
        return this.playerSkin;
    }

    public void tick() {
        super.tick();
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        if (((Optional)this.entityData.get(OWNER)).isPresent()) {
            try {
                nbt.putUUID("owner_uuid", (UUID)((Optional)this.entityData.get(OWNER)).get());
                nbt.putString("name", (String)this.entityData.get(OWNER_NAME));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public D4cPlayerClone(EntityType<D4cPlayerClone> type, Level world) {
        super(type, world);
        this.xpReward = 120;
        this.setNoAi(false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Turtle.class, false, Turtle.BABY_ON_LAND_SELECTOR));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
    }

    public double getMyRidingOffset() {
        return -0.35;
    }
}

