/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.ModEntities.custom;

import net.hrodebert.mots.ModSounds.ModSounds;
import net.hrodebert.mots.Mots;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.Skills.SoftAndWet.SoftAndWetAttachments;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.hrodebert.mots.ServerQueue.Queue;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class SoftAndWetBubble
extends AbstractArrow
implements GeoEntity {
    public MobEffectInstance onHitEffect = null;
    public int hitEffectType = 0;
    public DamageSource dmgSrc = null;
    public float damage = 0.0f;
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public SoftAndWetBubble(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    protected void onHitEntity(EntityHitResult result) {
        LivingEntity living;
        Entity entity;
        if (this.onHitEffect != null && (entity = result.getEntity()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            entity2.addEffect(this.onHitEffect);
        }
        if (this.dmgSrc != null && (entity = result.getEntity()) instanceof LivingEntity) {
            living = (LivingEntity)entity;
            living.hurt(this.dmgSrc, this.damage);
        }
        if (this.getOwner() != null && (entity = this.getOwner()) instanceof LivingEntity) {
            Entity entity3;
            living = (LivingEntity)entity;
            double power = (Double)living.getData(Attachments.STAND_SPECIAL_POTENCY);
            power /= 2.0;
            if (this.hitEffectType == 1) {
                result.getEntity().setData(SoftAndWetAttachments.NO_FRICTION, (Object)true);
                Entity entity4 = result.getEntity();
                if (entity4 instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity4;
                    StandHandler.syncData((LivingEntity)player);
                }
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task((int)(power * 20.0), t -> {
                    result.getEntity().setData(SoftAndWetAttachments.NO_FRICTION, (Object)false);
                    Entity patt0$temp = result.getEntity();
                    if (patt0$temp instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)patt0$temp;
                        StandHandler.syncData((LivingEntity)player);
                    }
                }));
            } else if (this.hitEffectType == 2) {
                Entity entity5 = result.getEntity();
                if (entity5 instanceof LivingEntity) {
                    LivingEntity entity6 = (LivingEntity)entity5;
                    entity6.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, (int)(power * 20.0), 255));
                }
            } else if (this.hitEffectType == 3 && (entity3 = result.getEntity()) instanceof LivingEntity) {
                LivingEntity entity7 = (LivingEntity)entity3;
                StandHandler.applyCooldownAbility(entity7, (int)(power * 20.0));
                StandHandler.applyCooldownAttack(entity7, (int)(power * 20.0));
                if (StandHandler.getStand(entity7).isPresent()) {
                    StandHandler.getStand(entity7).get().discard();
                }
            }
        }
        super.onHitEntity(result);
        this.discard();
    }

    public void tick() {
        super.tick();
        this.level().getEntities((Entity)this, this.getBoundingBox()).forEach(e -> {
            if (this.dmgSrc != null) {
                if (e.is(this.getOwner())) {
                    return;
                }
                if (StandHandler.getStand((LivingEntity)this.getOwner()).isPresent() && StandHandler.getStand((LivingEntity)this.getOwner()).get().is((Entity)e)) {
                    return;
                }
                if (e instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)e;
                    living.hurt(this.dmgSrc, this.damage);
                }
                this.discard();
            }
        });
    }

    public void remove(Entity.RemovalReason reason) {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), ModSounds.SOFT_AND_WET_BUBBLE_POP.get(), SoundSource.AMBIENT);
        super.remove(reason);
    }

    protected void onHitBlock(BlockHitResult result) {
        Vec3 vec3 = this.getDeltaMovement();
        vec3 = this.getDeltaMovement();
        double d5 = vec3.x;
        double d6 = vec3.y;
        double d1 = vec3.z;
        double d7 = this.getX() + d5;
        double d2 = this.getY() + d6;
        double d3 = this.getZ() + d1;
        this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, d7 - d5 * 0.25, d2 - d6 * 0.25, d3 - d1 * 0.25, d5, d6, d1);
        for (int j = 0; j < 4; ++j) {
            float f1 = 0.25f;
            this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, d7 - d5 * 0.25, d2 - d6 * 0.25, d3 - d1 * 0.25, d5, d6, d1);
        }
        super.onHitBlock(result);
        this.discard();
    }

    public double getBaseDamage() {
        return 4.0;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        tAnimationState.getController().setAnimation(RawAnimation.begin().then("idle.model.new", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

