/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.ModEntities.custom;

import java.util.Optional;
import java.util.UUID;
import net.hrodebert.mots.ModEntities.Goals.StandMeleeAttackGoal;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandEntity
extends TamableAnimal
implements FlyingAnimal {
    private static final EntityDataAccessor<Boolean> PILOT = SynchedEntityData.defineId(StandEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.defineId(StandEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private boolean particleLimiter = false;

    protected StandEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        if (this.canStandFly()) {
            this.moveControl = new FlyingMoveControl((Mob)this, 10, false);
        }
    }

    protected PathNavigation createNavigation(Level level) {
        if (this.canStandFly()) {
            FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level);
            flyingpathnavigation.setCanOpenDoors(true);
            flyingpathnavigation.setCanFloat(true);
            flyingpathnavigation.setCanPassDoors(true);
            return flyingpathnavigation;
        }
        GroundPathNavigation pathNavigation = new GroundPathNavigation((Mob)this, level);
        pathNavigation.setCanOpenDoors(true);
        pathNavigation.setCanWalkOverFences(true);
        return pathNavigation;
    }

    public boolean shouldHurtUserWhenStandHarmed() {
        return false;
    }

    public static AttributeSupplier setAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.FLYING_SPEED, 2.0).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.STEP_HEIGHT, 3.0).build();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(4, (Goal)new StandMeleeAttackGoal((LivingEntity)this, 4));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 2.0, 1.0f, 10.0f));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
    }

    protected boolean canFlyToOwner() {
        return true;
    }

    public int getMaxHeadYRot() {
        return 0;
    }

    public Optional<UUID> getUUIDOwner() {
        return (Optional)this.entityData.get(OWNER);
    }

    public void switchPilot() {
        this.clampHeadRotationToBody();
        this.entityData.set(PILOT, (Object)((Boolean)this.entityData.get(PILOT) == false ? 1 : 0));
    }

    public boolean isInPilot() {
        return (Boolean)this.entityData.get(PILOT);
    }

    public void aiStep() {
        super.aiStep();
    }

    public boolean canStandFly() {
        return true;
    }

    public double standSpeed() {
        return 0.3;
    }

    public ServerPlayer getUser() {
        if (this.isInPilot() && this.level() != null && !this.level().isClientSide && this.getUUIDOwner().isPresent()) {
            return this.level().getServer().getPlayerList().getPlayer(this.getUUIDOwner().get());
        }
        return null;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(PILOT, (Object)false);
        builder.define(OWNER, Optional.empty());
        super.defineSynchedData(builder);
    }

    public int maxDistanceFromUser() {
        return 10;
    }

    public void tick() {
        Entity player2;
        ServerPlayer user;
        if (!this.isTame() && (user = this.getUser()) != null) {
            this.tame((Player)user);
        }
        if (this.getVehicle() == null && !((Boolean)this.entityData.get(PILOT)).booleanValue()) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (!this.canStandFly() && !this.onGround()) {
            this.addDeltaMovement(this.getDeltaMovement().add(0.0, -0.2, 0.0));
            this.hurtMarked = true;
        }
        if (this.getVehicle() != null) {
            player2 = this.getVehicle();
            this.setXRot(player2.getXRot());
            this.setYRot(player2.getYRot());
            this.setYBodyRot(player2.getYRot());
            this.setYHeadRot(player2.getYRot());
        }
        if (((Boolean)this.entityData.get(PILOT)).booleanValue()) {
            if (this.getVehicle() != null) {
                this.entityData.set(OWNER, Optional.of(this.getVehicle().getUUID()));
            }
            if (this.getVehicle() != null) {
                this.stopRiding();
                this.refreshDimensions();
            }
            if (!this.level().isClientSide() && ((Optional)this.entityData.get(OWNER)).isPresent() && (player2 = this.level().getPlayerByUUID((UUID)((Optional)this.entityData.get(OWNER)).get())) != null && player2.distanceTo((Entity)this) > (float)this.maxDistanceFromUser()) {
                double speed = 0.5;
                Vec3 mov = new Vec3(0.0, 0.0, 0.0);
                mov = this.position().x > player2.position().x ? new Vec3(-speed, mov.y, mov.z) : new Vec3(speed, mov.y, mov.z);
                mov = this.position().y > player2.position().y ? new Vec3(mov.x, -speed, mov.z) : new Vec3(mov.x, speed, mov.z);
                mov = this.position().z > player2.position().z ? new Vec3(mov.x, mov.y, -speed) : new Vec3(mov.x, mov.y, speed);
                this.setDeltaMovement(mov);
                this.hurtMarked = true;
            }
        }
        if (this.level() != null && !this.level().isClientSide) {
            Level level2;
            if (this.isInPilot()) {
                this.getServer().getAllLevels().forEach(level -> level.getEntities().getAll().forEach(entry -> {
                    Targeting m;
                    if (entry instanceof Targeting && (m = (Targeting)entry).getTarget() != null && m.getTarget().is((Entity)this.getUser()) && m instanceof Mob) {
                        Mob l = (Mob)m;
                        l.setTarget((LivingEntity)this);
                    }
                }));
            }
            if ((level2 = this.level()) instanceof ServerLevel) {
                ServerLevel level3 = (ServerLevel)level2;
                level3.players().forEach(player -> {
                    if (StandHandler.canSeeStands((LivingEntity)player)) {
                        for (int i = 0; i < 2; ++i) {
                            if (!this.particleLimiter) {
                                level3.sendParticles(player, (ParticleOptions)ParticleTypes.END_ROD, false, this.position().x, this.position().y + (double)i, this.position().z, 1, 0.2, 0.1, 0.2, 1.0E-4);
                            }
                            level3.sendParticles(player, (ParticleOptions)ParticleTypes.ELECTRIC_SPARK, false, this.position().x, this.position().y + (double)i, this.position().z, 1, 0.2, 0.1, 0.2, 0.001);
                        }
                        this.particleLimiter = !this.particleLimiter;
                    }
                });
            }
        }
        super.tick();
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        return EntityDimensions.fixed((float)0.6f, (float)1.8f);
    }

    public Vec3 getVehicleAttachmentPoint(Entity entity) {
        float yaw = this.getYRot();
        double offsetX = -Math.sin(Math.toRadians(yaw)) + Math.cos(Math.toRadians(yaw));
        double offsetZ = Math.cos(Math.toRadians(yaw)) + Math.sin(Math.toRadians(yaw));
        return new Vec3(offsetX, 1.8, offsetZ);
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        if (!this.level().isClientSide) {
            if (source.is(DamageTypes.FALL)) {
                return false;
            }
            if (this.shouldHurtUserWhenStandHarmed() && this.getUUIDOwner().isPresent() && this.isInPilot()) {
                this.level().getServer().getPlayerList().getPlayer(this.getUUIDOwner().get()).hurt(source, amount);
            }
        }
        return false;
    }

    public ResourceLocation getStandUserEntitySkin() {
        return ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/users/unregister_skin.png");
    }

    public boolean isFlying() {
        return !this.onGround();
    }
}

