/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.ModEntities.custom;

import net.hrodebert.mots.ModEntities.custom.StandEntity;
import net.hrodebert.mots.ModItems.ModItems;
import net.hrodebert.mots.Mots;
import net.hrodebert.mots.ServerQueue.Queue;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class SteelBallBullet
extends AbstractArrow
implements GeoEntity {
    public boolean eco = false;
    public boolean paralyzing = false;
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private boolean dealtDamage = false;

    public SteelBallBullet(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ModItems.STEEL_BALL.get());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        tAnimationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    protected void onHitBlock(BlockHitResult result) {
        if (this.eco) {
            this.level().getEntities(this.getOwner(), this.getBoundingBox().inflate(10.0)).forEach(entity -> {
                if (!(entity instanceof StandEntity) && entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    living.addEffect(new MobEffectInstance(MobEffects.GLOWING, 60, 0));
                }
            });
        }
        super.onHitBlock(result);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        float f = 8.0f;
        Entity entity1 = this.getOwner();
        DamageSource damagesource = this.damageSources().trident((Entity)this, (Entity)(entity1 == null ? this : entity1));
        Level var7 = this.level();
        if (this.paralyzing && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 20));
            living.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 60));
        }
        this.dealtDamage = true;
        if (entity.hurt(damagesource, f)) {
            if (entity.getType() == EntityType.ENDERMAN) {
                return;
            }
            var7 = this.level();
            if (var7 instanceof ServerLevel) {
                ServerLevel serverlevel1 = (ServerLevel)var7;
                EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverlevel1, (Entity)entity, (DamageSource)damagesource, (ItemStack)this.getWeaponItem());
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                this.doKnockback(livingentity, damagesource);
                this.doPostHurtEffects(livingentity);
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
        this.playSound(SoundEvents.TRIDENT_HIT, 1.0f, 1.0f);
    }

    public void tick() {
        if (this.tickCount > 80 || this.inGroundTime > 5 || this.dealtDamage) {
            this.tickCount = 80;
            if (this.getOwner() != null && this.distanceTo(this.getOwner()) > 2.0f) {
                this.setNoPhysics(true);
                double speed = 0.5;
                Vec3 mov = new Vec3(0.0, 0.0, 0.0);
                Entity player = this.getOwner();
                mov = this.position().x > player.position().x ? new Vec3(-speed, mov.y, mov.z) : new Vec3(speed, mov.y, mov.z);
                mov = this.position().y > player.getEyeY() ? new Vec3(mov.x, -speed, mov.z) : new Vec3(mov.x, speed, mov.z);
                mov = this.position().z > player.position().z ? new Vec3(mov.x, mov.y, -speed) : new Vec3(mov.x, mov.y, speed);
                this.setDeltaMovement(mov);
                this.hurtMarked = true;
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(1, t -> this.setNoPhysics(false)));
            }
        }
        super.tick();
    }
}

