/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.ModEntities.custom;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.hrodebert.mots.ModEntities.ModEntities;
import net.hrodebert.mots.ModEntities.custom.TuskAct4;
import net.hrodebert.mots.ModEntities.custom.WormHole;
import net.hrodebert.mots.ModParticles.ModParticleTypes;
import net.hrodebert.mots.Mots;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.hrodebert.mots.ServerQueue.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class TuskNail
extends AbstractArrow
implements GeoEntity {
    public boolean golden_rec = false;
    public MobEffectInstance onHitEffect = null;
    public int hitEffectType = 0;
    public boolean containsTusk = false;
    public DamageSource dmgSrc = null;
    public float damage = 0.0f;
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public TuskNail(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    public double getBaseDamage() {
        return super.getBaseDamage();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        tAnimationState.getController().setAnimation(RawAnimation.begin().then("idle.model.new", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    protected void onHitEntity(EntityHitResult result) {
        if (result.getEntity() == this.getOwner()) {
            return;
        }
        this.level().players().forEach(player -> ((ServerLevel)this.level()).sendParticles((ServerPlayer)player, (ParticleOptions)ModParticleTypes.BLOOD_PARTICLE.get(), true, this.getX(), this.getY(), this.getZ(), 200, 0.1, 0.1, 0.1, 0.2));
        Entity entity2 = result.getEntity();
        if (entity2 instanceof WormHole) {
            WormHole wormHole = (WormHole)entity2;
            if (this.getOwner() != null && wormHole.getOwner() == this.getOwner()) {
                AtomicBoolean executed = new AtomicBoolean(false);
                wormHole.level().getEntities((Entity)wormHole, wormHole.getBoundingBox().inflate(40.0)).forEach(entity -> {
                    if (executed.get()) {
                        return;
                    }
                    if (entity instanceof WormHole) {
                        WormHole wormHole2 = (WormHole)((Object)entity);
                        if (wormHole2 == wormHole) {
                            return;
                        }
                        TuskNail bubble = new TuskNail(ModEntities.TUSK_NAIL.get(), this.level());
                        bubble.teleportTo(wormHole2.getX(), wormHole2.getEyeY(), wormHole2.getZ());
                        bubble.setBaseDamage((Double)this.getOwner().getData(Attachments.STAND_SPECIAL_POTENCY) / 10.0 + (Double)this.getOwner().getData(Attachments.SPIN_AMOUNT) / 10.0);
                        this.level().addFreshEntity((Entity)bubble);
                        float velocity = 2.0f;
                        bubble.setOwner(this.getOwner());
                        bubble.golden_rec = false;
                        velocity = 3.0f;
                        bubble.shoot(wormHole2.getViewVector((float)1.0f).x, wormHole2.getViewVector((float)1.0f).y, wormHole2.getViewVector((float)1.0f).z, velocity, 1.0f);
                        bubble.setNoGravity(true);
                        Mots.serverTaskExecutioner.tasks.add(new Queue.Task(25, o -> bubble.setNoGravity(false)));
                        executed.set(true);
                        return;
                    }
                });
                WormHole wm = new WormHole(ModEntities.WORMHOLE.get(), this.level());
                Entity entity3 = this.getOwner();
                if (entity3 instanceof Player) {
                    Player p = (Player)entity3;
                    wm.tame(p);
                    wm.teleportTo(wormHole.getX(), wormHole.getY(), wormHole.getZ());
                    this.level().addFreshEntity((Entity)wm);
                }
                wormHole.discard();
                this.discard();
            }
        }
        super.onHitEntity(result);
    }

    protected void onHitBlock(BlockHitResult result) {
        if (this.golden_rec) {
            WormHole wormHole = new WormHole(ModEntities.WORMHOLE.get(), this.level());
            Entity entity = this.getOwner();
            if (entity instanceof Player) {
                Player p = (Player)entity;
                wormHole.tame(p);
                wormHole.teleportTo(this.getX(), this.getY(), this.getZ());
                this.level().addFreshEntity((Entity)wormHole);
                if (this.containsTusk) {
                    TuskNail source = this;
                    TuskAct4 standNew = new TuskAct4(ModEntities.TUSK_4.get(), source.level());
                    standNew.startRiding((Entity)source);
                    standNew.startRiding((Entity)wormHole);
                    standNew.moveTo(source.position());
                    standNew.switchPilot();
                    for (int i = 0; i < 70; ++i) {
                        Mots.serverTaskExecutioner2.tasks.add(new Queue.Task(i, task -> {
                            standNew.setXRot(p.getXRot());
                            standNew.setYBodyRot(p.getYRot());
                            standNew.setYHeadRot(p.getYHeadRot());
                        }));
                    }
                    Mots.serverTaskExecutioner2.tasks.add(new Queue.Task(40, task -> standNew.discard()));
                    source.level().addFreshEntity((Entity)standNew);
                    standNew.goalSelector.removeAllGoals(s -> true);
                    Mots.serverTaskExecutioner2.tasks.add(new Queue.Task(20, t -> {
                        standNew.uppercut();
                        wormHole.setData(Attachments.STAND_ATTACK_POTENCY, (Double)this.getData(Attachments.STAND_ATTACK_POTENCY));
                        Mots.serverTaskExecutioner.tasks.add(new Queue.Task(5, s -> {
                            List<Entity> list = StandHandler.executeScalableMeleeAttack((LivingEntity)wormHole, 4, new Vec3(4.0, 1.5, 4.0), Optional.of(false), Optional.empty(), true);
                            list.forEach(e -> {
                                e.addDeltaMovement(new Vec3(0.0, 1.0, 0.0));
                                e.hurtMarked = true;
                            });
                            ArrayList pairs = new ArrayList();
                            ResourceKey dim = source.level().dimension();
                            ServerLevel serverLevel = (ServerLevel)source.level();
                            list.forEach(e -> {
                                pairs.add(new Pair((Object)e.getUUID(), (Object)e.blockPosition()));
                                for (int i = 0; i < 300; ++i) {
                                    Mots.serverTaskExecutioner2.tasks.add(new Queue.Task(i, task -> {
                                        e.setYHeadRot(e.getYHeadRot() + 20.0f);
                                        pairs.forEach(pair -> serverLevel.getServer().getAllLevels().forEach(level -> {
                                            if (level.getEntities().get((UUID)pair.getFirst()) != null) {
                                                Entity target;
                                                if (serverLevel.getEntities().get((UUID)pair.getFirst()) == null) {
                                                    target = level.getEntity((UUID)pair.getFirst());
                                                    ((Entity)level.getEntities().get((UUID)pair.getFirst())).teleportTo(serverLevel, (double)((BlockPos)pair.getSecond()).getX(), (double)((BlockPos)pair.getSecond()).getY(), (double)((BlockPos)pair.getSecond()).getZ(), null, target.getYRot(), target.getXRot());
                                                }
                                                if ((target = level.getEntity((UUID)pair.getFirst())).distanceToSqr((double)((BlockPos)pair.getSecond()).getX(), (double)((BlockPos)pair.getSecond()).getY(), (double)((BlockPos)pair.getSecond()).getZ()) > 7.0 && target instanceof LivingEntity) {
                                                    LivingEntity player = (LivingEntity)target;
                                                    double speed = 0.5;
                                                    Vec3 mov = new Vec3(0.0, 0.0, 0.0);
                                                    mov = (double)((BlockPos)pair.getSecond()).getX() < player.position().x ? new Vec3(-speed, mov.y, mov.z) : new Vec3(speed, mov.y, mov.z);
                                                    mov = (double)((BlockPos)pair.getSecond()).getY() < player.getEyeY() ? new Vec3(mov.x, -speed, mov.z) : new Vec3(mov.x, speed, mov.z);
                                                    mov = (double)((BlockPos)pair.getSecond()).getZ() < player.position().z ? new Vec3(mov.x, mov.y, -speed) : new Vec3(mov.x, mov.y, speed);
                                                    player.setDeltaMovement(mov);
                                                    player.hurtMarked = true;
                                                }
                                            }
                                        }));
                                    }));
                                }
                            });
                        }));
                    }));
                }
            }
            this.discard();
        }
        super.onHitBlock(result);
    }

    public void tick() {
        Direction[] directionArray;
        if (this.golden_rec && this.isNoGravity()) {
            BlockPos pos = this.blockPosition();
            directionArray = Direction.values();
            int n = directionArray.length;
            for (int i = 0; i < n; ++i) {
                Direction dir = directionArray[i];
                BlockPos nearbyPos = pos.relative(dir);
                BlockState nearbyBlock = this.level().getBlockState(nearbyPos);
                if (nearbyBlock.getBlock() != Blocks.WATER) continue;
                this.level().setBlock(nearbyPos, Blocks.AIR.defaultBlockState(), 3);
            }
        }
        if ((directionArray = this.level()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)directionArray;
            this.level().players().forEach(p -> level.sendParticles((ServerPlayer)p, (ParticleOptions)ParticleTypes.END_ROD, false, this.position().x, this.position().y, this.position().z, 3, 0.0, 0.0, 0.0, 1.0E-4));
        }
        super.tick();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

