/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.ModEntities.custom;

import java.util.ArrayList;
import java.util.List;
import net.hrodebert.mots.ModEntities.custom.StandEntity;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class WhiteSnake
extends StandEntity
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> SHOULD_RESET = SynchedEntityData.defineId(WhiteSnake.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> EXTRACTING = SynchedEntityData.defineId(WhiteSnake.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> PILOT = SynchedEntityData.defineId(WhiteSnake.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FIRST_RENDERER = SynchedEntityData.defineId(WhiteSnake.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> TICK_BEGIN = SynchedEntityData.defineId(WhiteSnake.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TICK_END = SynchedEntityData.defineId(WhiteSnake.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(WhiteSnake.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public List<WrappedGoal> goals = new ArrayList<WrappedGoal>();
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public AnimationState<WhiteSnake> state;

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ANIMATION, (Object)"none");
        builder.define(TICK_BEGIN, (Object)0);
        builder.define(TICK_END, (Object)0);
        builder.define(SHOULD_RESET, (Object)false);
        builder.define(FIRST_RENDERER, (Object)false);
        builder.define(EXTRACTING, (Object)false);
        builder.define(PILOT, (Object)false);
    }

    public void setFirstRenderer(boolean val) {
        this.entityData.set(FIRST_RENDERER, (Object)val);
    }

    public boolean getFirstRenderer() {
        return (Boolean)this.entityData.get(FIRST_RENDERER);
    }

    public WhiteSnake(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 2, state -> {
            if (!state.getController().isPlayingTriggeredAnimation()) {
                state.getController().setAnimationSpeed(1.0);
                state.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
            } else {
                state.getController().setAnimationSpeed(2.0);
            }
            return PlayState.CONTINUE;
        }).triggerableAnim("barrage", RawAnimation.begin().thenPlayXTimes("barrage", 20)).triggerableAnim("Power punch", RawAnimation.begin().thenPlay("Power punch")).triggerableAnim("spit", RawAnimation.begin().thenPlay("spit")).triggerableAnim("illusion_mist", RawAnimation.begin().thenPlay("illusion_mist")).triggerableAnim("disk removal", RawAnimation.begin().thenPlay("disk removal")));
    }

    public Boolean getPilot() {
        return (Boolean)this.entityData.get(PILOT);
    }

    public boolean canControlVehicle() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void tick() {
        try {
            if (this.getVehicle() != null) {
                Entity player = this.getVehicle();
                this.setXRot(player.getXRot());
                this.setYRot(player.getYRot());
                this.setYBodyRot(player.getYRot());
                this.setYHeadRot(player.getYRot());
                if (this.getVehicle().getAirSupply() <= 0 && ((Boolean)this.entityData.get(PILOT)).booleanValue()) {
                    // empty if block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.tick();
    }

    @Override
    public boolean canStandFly() {
        return false;
    }

    @Override
    public int maxDistanceFromUser() {
        return 60;
    }

    public void chop() {
        this.entityData.set(SHOULD_RESET, (Object)true, true);
        this.entityData.set(ANIMATION, (Object)"chop", true);
    }

    public void extraction() {
        this.entityData.set(SHOULD_RESET, (Object)true, true);
        this.entityData.set(EXTRACTING, (Object)true, true);
        this.entityData.set(ANIMATION, (Object)"extraction", true);
        this.entityData.set(TICK_BEGIN, (Object)0, true);
    }

    public void insert() {
        this.entityData.set(SHOULD_RESET, (Object)true, true);
        this.entityData.set(ANIMATION, (Object)"insert", true);
    }

    public void spit() {
        this.entityData.set(SHOULD_RESET, (Object)true, true);
        this.entityData.set(ANIMATION, (Object)"spit", true);
    }

    @Override
    public ResourceLocation getStandUserEntitySkin() {
        return ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/users/pucci.png");
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

