/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.ModEntities.custom;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.hrodebert.mots.ModEntities.ModEntities;
import net.hrodebert.mots.ModEntities.custom.StandEntity;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class WonderOfYou
extends StandEntity
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> SHOULD_RESET = SynchedEntityData.defineId(WonderOfYou.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(WonderOfYou.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private ArrayList<Pair<Entity, Integer>> calamity = new ArrayList();
    private int c = 0;

    @Override
    public boolean canStandFly() {
        return false;
    }

    @Override
    public int maxDistanceFromUser() {
        return 100;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ANIMATION, (Object)"none");
        builder.define(SHOULD_RESET, (Object)false);
    }

    public boolean canControlVehicle() {
        return false;
    }

    public WonderOfYou(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    public static AttributeSupplier setAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.4f).build();
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob ageableMob) {
        return (AgeableMob)ModEntities.D4C.get().create((Level)level);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate));
    }

    @Override
    public double standSpeed() {
        return 0.1;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        if (this.getDeltaMovement().x != 0.0 || this.getDeltaMovement().z != 0.0 || this.getDeltaMovement().x != 0.0 && this.getDeltaMovement().z != 0.0 && this.getVehicle() == null) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
        } else {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public ArrayList<Pair<Entity, Integer>> getCalamity() {
        return this.calamity;
    }

    public boolean isLookingAtMyBack(LivingEntity target) {
        Vec3 vec3 = target.getViewVector(1.0f).normalize();
        Vec3 vec31 = new Vec3(this.getX() - target.getX(), this.getEyeY() - target.getEyeY(), this.getZ() - target.getZ());
        double d1 = vec3.dot(vec31 = vec31.normalize());
        return d1 > 0.99875 && target.hasLineOfSight((Entity)this);
    }

    public boolean calamityContains(LivingEntity target) {
        for (Pair<Entity, Integer> entityIntegerPair : this.calamity) {
            if (!((Entity)entityIntegerPair.getFirst()).equals((Object)target)) continue;
            return true;
        }
        return false;
    }

    public int getCalamityForEntity(LivingEntity living) {
        if (this.calamityContains(living)) {
            for (Pair<Entity, Integer> entityIntegerPair : this.calamity) {
                if (!((Entity)entityIntegerPair.getFirst()).equals((Object)living)) continue;
                return (Integer)entityIntegerPair.getSecond();
            }
        }
        return 0;
    }

    public void setCalamityForEntity(LivingEntity living, Integer calamity) {
        if (this.calamityContains(living)) {
            for (int i = 0; i < this.calamity.size(); ++i) {
                if (!((Entity)this.calamity.get(i).getFirst()).equals((Object)living)) continue;
                this.calamity.set(i, (Pair<Entity, Integer>)new Pair((Object)living, (Object)calamity));
                return;
            }
        } else {
            this.calamity.add((Pair<Entity, Integer>)new Pair((Object)living, (Object)calamity));
        }
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide()) {
            ++this.c;
            if (this.c == 10) {
                this.c = 0;
                List list = this.level().getEntities(null, this.getBoundingBox().inflate(40.0));
                for (Entity entity : list) {
                    LivingEntity living;
                    if (!(entity instanceof LivingEntity) || !this.isLookingAtMyBack(living = (LivingEntity)entity)) continue;
                    this.setCalamityForEntity(living, this.getCalamityForEntity(living) + 1);
                    if (living.hasEffect(MobEffects.CONFUSION)) continue;
                    living.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 20));
                    living.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 20));
                    living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 20));
                }
                for (Pair pair : this.getCalamity()) {
                    Random random = new Random();
                    if (random.nextInt(0, 600) > (Integer)pair.getSecond()) continue;
                    this.executeCalamityForEntity((LivingEntity)pair.getFirst());
                }
            }
        }
        super.tick();
    }

    void executeCalamityForEntity(LivingEntity entity) {
        int severity = this.getCalamityForEntity(entity);
        if (severity < 10) {
            boolean tier = false;
        } else if (severity < 20) {
            boolean tier = true;
        } else if (severity < 30) {
            int tier = 2;
        } else {
            int tier = 3;
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public boolean hurt(@NotNull DamageSource source, float amount) {
        if (!this.level().isClientSide && this.getUUIDOwner().isPresent()) {
            this.level().getServer().getPlayerList().getPlayer(this.getUUIDOwner().get()).hurt(source, amount);
        }
        return false;
    }

    @Override
    public ResourceLocation getStandUserEntitySkin() {
        return ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/users/tooru.png");
    }
}

