/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.ModItems.custom;

import java.util.List;
import java.util.Random;
import net.hrodebert.mots.ModItems.ModItems;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ArrowHead
extends Item {
    public ArrowHead(Item.Properties pProperties) {
        super(pProperties);
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.arrow.description").withStyle(ChatFormatting.AQUA));
        tooltipComponents.add((Component)Component.literal((String)""));
        tooltipComponents.add((Component)Component.translatable((String)"mots.press_alt_to_see_more").withStyle(ChatFormatting.DARK_PURPLE));
        if (tooltipFlag.hasAltDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.arrow.more_info"));
            tooltipComponents.add((Component)Component.translatable((String)"item.arrow.stands"));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        for (int i = 0; i < pPlayer.getInventory().items.size(); ++i) {
            ItemStack stack = pPlayer.getInventory().getItem(i);
            if (stack.getItem() != ModItems.STAND_ARROW.get()) continue;
            pPlayer.getInventory().removeItem(i, 1);
            break;
        }
        if (!pLevel.isClientSide()) {
            ArrowHead.giveRandomStandArrow((LivingEntity)pPlayer);
        }
        pLevel.playSeededSound(null, pPlayer.getX(), pPlayer.getY(), pPlayer.getZ(), SoundEvents.PLAYER_BURP, SoundSource.PLAYERS, 1.0f, 1.0f, 0L);
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    public static void assignMaxStaminaByStandId(Entity player) {
        int standId = (Integer)player.getData(Attachments.STAND_ID);
        int maxStamina = switch (standId) {
            case 1 -> 10;
            case 2 -> 7;
            case 3 -> 6;
            case 4 -> 10;
            case 5 -> 8;
            case 6 -> 4;
            case 7 -> 7;
            case 8 -> 7;
            case 9 -> 20;
            case 10 -> 5;
            case 11 -> 15;
            case 12 -> 8;
            case 13 -> 8;
            case 14 -> 13;
            case 15 -> 10;
            case 16 -> 13;
            default -> 0;
        };
        player.setData(Attachments.MAX_STAMINA, (Object)maxStamina);
    }

    public static int giveRandomStandArrow(LivingEntity pPlayer) {
        int val = new Random().nextInt(9);
        if (pPlayer instanceof ServerPlayer) {
            ServerPlayer o = (ServerPlayer)pPlayer;
            o.sendSystemMessage((Component)Component.translatable((String)"manifestation_of_the_souls.tutorials.stand"));
        }
        if (!((Boolean)pPlayer.getData(Attachments.HAS_STAND)).booleanValue()) {
            pPlayer.setData(Attachments.HAS_STAND, (Object)true);
            pPlayer.setData(Attachments.SKILL, (Object)0);
            switch (val) {
                case 0: {
                    pPlayer.setData(Attachments.STAND_ID, (Object)2);
                    break;
                }
                case 1: {
                    pPlayer.setData(Attachments.STAND_ID, (Object)3);
                    break;
                }
                case 2: {
                    pPlayer.setData(Attachments.STAND_ID, (Object)4);
                    break;
                }
                case 3: {
                    pPlayer.setData(Attachments.STAND_ID, (Object)5);
                    break;
                }
                case 4: {
                    pPlayer.setData(Attachments.STAND_ID, (Object)6);
                    break;
                }
                case 5: {
                    pPlayer.setData(Attachments.STAND_ID, (Object)11);
                    break;
                }
                case 6: {
                    pPlayer.setData(Attachments.STAND_ID, (Object)12);
                    break;
                }
                case 7: {
                    pPlayer.setData(Attachments.STAND_ID, (Object)13);
                    break;
                }
                case 8: {
                    pPlayer.setData(Attachments.STAND_ID, (Object)16);
                }
            }
            ArrowHead.assignMaxStaminaByStandId((Entity)pPlayer);
            if (pPlayer instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                StandHandler.registerSkills((LivingEntity)serverPlayer);
                StandHandler.syncData((LivingEntity)serverPlayer);
                StandHandler.givePlayerStandAdvancement(serverPlayer);
            }
        }
        return val;
    }
}

