/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.ModItems.custom;

import java.util.ArrayList;
import java.util.List;
import net.hrodebert.mots.ModEntities.ModEntities;
import net.hrodebert.mots.ModEntities.custom.DioBrandoBoss.DioBoss;
import net.hrodebert.mots.ModItems.DataComponents.Components;
import net.hrodebert.mots.ModItems.DataComponents.StandDiskRecord;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public class StandDisk
extends Item {
    public StandDisk(Item.Properties pProperties) {
        super(pProperties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.disk.description").withStyle(ChatFormatting.AQUA));
        tooltipComponents.add((Component)Component.literal((String)""));
        tooltipComponents.add((Component)Component.translatable((String)"mots.press_alt_to_see_more").withStyle(ChatFormatting.DARK_PURPLE));
        if (tooltipFlag.hasAltDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.disk.more_info"));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static void useOnEntity(LivingEntity pPlayer, StandDiskRecord data, InteractionHand pUsedHand) {
        StandDiskRecord newComponent = new StandDiskRecord((Integer)pPlayer.getData(Attachments.STAND_ID), ((Integer)pPlayer.getData(Attachments.MAX_STAMINA)).intValue(), (Double)pPlayer.getData(Attachments.STAND_ATTACK_POTENCY), (Double)pPlayer.getData(Attachments.STAND_SPECIAL_POTENCY), (Double)pPlayer.getData(Attachments.DAMAGE_RESISTANCE), (Integer)pPlayer.getData(Attachments.STAND_REBIRTH));
        if (pPlayer instanceof ZombieVillager && data.standId() == 4) {
            DioBoss boss = new DioBoss(ModEntities.DIO_BOSS.get(), pPlayer.level());
            boss.teleportTo(pPlayer.getX(), pPlayer.getY(), pPlayer.getZ());
            pPlayer.level().addFreshEntity((Entity)boss);
            pPlayer.discard();
            return;
        }
        pPlayer.setData(Attachments.STAND_ID, (Object)data.standId());
        pPlayer.setData(Attachments.MAX_STAMINA, (Object)((int)data.maxStamina()));
        pPlayer.setData(Attachments.STAND_ATTACK_POTENCY, (Object)data.damageLevel());
        pPlayer.setData(Attachments.STAND_SPECIAL_POTENCY, (Object)data.specialLevel());
        pPlayer.setData(Attachments.DAMAGE_RESISTANCE, (Object)data.damageResistance());
        pPlayer.setData(Attachments.SKILL, (Object)0);
        pPlayer.setData(Attachments.COOLDOWN_TIME_ABILITY, (Object)500);
        pPlayer.setData(Attachments.HAS_STAND.get(), (Object)(data.standId() != 0 ? 1 : 0));
        pPlayer.setData(Attachments.STAND_REBIRTH.get(), (Object)data.rebirth());
        pPlayer.setData(Attachments.COOLDOWN_TIME_ATTACK, (Object)500);
        pPlayer.getItemInHand(pUsedHand).set(Components.STAND_DISK, (Object)newComponent);
        pPlayer.getPassengers().forEach(p -> p.stopRiding());
        if (pPlayer instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)pPlayer;
            StandHandler.givePlayerStandAdvancement(player);
        }
        pPlayer.setData(Attachments.SKILLS, new ArrayList());
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pLevel.isClientSide()) {
            return super.use(pLevel, pPlayer, pUsedHand);
        }
        if (pPlayer.isCrouching()) {
            return super.use(pLevel, pPlayer, pUsedHand);
        }
        StandDiskRecord data = (StandDiskRecord)pPlayer.getItemInHand(pUsedHand).get(Components.STAND_DISK);
        StandDisk.useOnEntity((LivingEntity)pPlayer, data, pUsedHand);
        StandHandler.syncData((LivingEntity)pPlayer);
        pLevel.playSeededSound(null, pPlayer.getX(), pPlayer.getY(), pPlayer.getZ(), SoundEvents.PLAYER_BURP, SoundSource.PLAYERS, 1.0f, 1.0f, 0L);
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        return false;
    }
}

