/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.ModItems.custom;

import java.util.function.Consumer;
import net.hrodebert.mots.ModEntities.client.SteelBall.SteelBallRenderer;
import net.hrodebert.mots.MotsApi.Attachments;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class SteelBall
extends Item
implements GeoItem {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public double speed = 0.0;

    public SteelBall(Item.Properties properties) {
        super(properties);
        GeoItem.registerSyncedAnimatable((GeoAnimatable)this);
    }

    private PlayState predicate(AnimationState animationState) {
        if (this.speed < 0.1) {
            animationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        } else {
            animationState.getController().setAnimation(RawAnimation.begin().then("spincharge", Animation.LoopType.LOOP));
        }
        animationState.getController().setAnimationSpeed(this.speed);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private SteelBallRenderer renderer;

            @Nullable
            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new SteelBallRenderer();
                }
                return this.renderer;
            }
        });
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 1000000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        player.startUsingItem(usedHand);
        return super.use(level, player, usedHand);
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (livingEntity.hasData(Attachments.KNOWS_SPIN.get()) && ((Boolean)livingEntity.getData(Attachments.KNOWS_SPIN.get())).booleanValue()) {
            if (livingEntity.hasData(Attachments.SPIN_AMOUNT)) {
                livingEntity.setData(Attachments.SPIN_AMOUNT.get(), (Object)((Double)livingEntity.getData(Attachments.SPIN_AMOUNT) + 0.15));
            } else {
                livingEntity.setData(Attachments.SPIN_AMOUNT.get(), (Object)0.2);
            }
        }
        super.onUseTick(level, livingEntity, stack, remainingUseDuration);
    }
}

