/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.ModItems.custom;

import java.util.List;
import net.hrodebert.mots.ModItems.ModItems;
import net.hrodebert.mots.Mots;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.Skills.Vampirism.VampirismAttachments;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.hrodebert.mots.ServerQueue.Queue;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class StoneMask
extends Item {
    public StoneMask(Item.Properties pProperties) {
        super(pProperties);
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }

    public void useStoneMask(LivingEntity entity) {
        if (((Boolean)entity.getData(Attachments.KNOWS_SPIN)).booleanValue()) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.sendSystemMessage((Component)Component.literal((String)"You need to get rid of spin first (use locacaca)"));
            }
        } else {
            ItemStack stack = new ItemStack((ItemLike)ModItems.ACTIVE_STONE_MASK.get());
            stack.enchant((Holder)entity.level().holderLookup(Registries.ENCHANTMENT).getOrThrow(Enchantments.BINDING_CURSE), 1);
            ItemStack originalMask = entity.getItemBySlot(EquipmentSlot.HEAD);
            entity.setItemSlot(EquipmentSlot.HEAD, stack);
            Mots.serverTaskExecutioner.tasks.add(new Queue.Task(62, t -> {
                ItemEntity stoneMask = new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), originalMask);
                entity.level().addFreshEntity((Entity)stoneMask);
                entity.setItemSlot(EquipmentSlot.HEAD, ItemStack.EMPTY);
                entity.setData(VampirismAttachments.IS_VAMPIRE, (Object)true);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer p = (ServerPlayer)entity;
                    StandHandler.syncVampireData(p);
                }
            }));
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"manifestation_of_the_souls.description.stone_mask"));
        tooltipComponents.add((Component)Component.translatable((String)"manifestation_of_the_souls.description.stone_mask2").withStyle(ChatFormatting.DARK_RED));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack item = player.getItemInHand(usedHand);
        player.setItemSlot(EquipmentSlot.HEAD, item);
        player.setItemInHand(usedHand, ItemStack.EMPTY);
        return super.use(level, player, usedHand);
    }
}

