/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.MotsApi;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;

public class Skill {
    public Optional<ResourceLocation> icon = Optional.empty();
    public boolean holdable = false;
    public String name;
    public int cost;
    public Boolean isSpecial;
    public Consumer<LivingEntity> executeSkill;

    public Skill(String name, Integer cost, Boolean isSpecial, Consumer<LivingEntity> entityConsumer) {
        this.name = name;
        this.cost = cost;
        this.isSpecial = isSpecial;
        this.executeSkill = entityConsumer;
    }

    public Skill(String name, Integer cost, Boolean isSpecial, Consumer<LivingEntity> entityConsumer, SoundEvent sound) {
        this.name = name;
        this.cost = cost;
        this.isSpecial = isSpecial;
        this.holdable = false;
        this.executeSkill = s -> {
            entityConsumer.accept((LivingEntity)s);
            s.level().playSound(null, s.blockPosition(), sound, SoundSource.AMBIENT, 1.0f, 1.0f);
        };
    }

    public Skill setIcon(Optional<ResourceLocation> pIcon) {
        this.icon = pIcon;
        return this;
    }

    public Skill setHoldable(boolean holdable) {
        this.holdable = true;
        return this;
    }
}

