/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.MotsApi.Skills.Cmoon;

import java.util.ArrayList;
import java.util.Optional;
import net.hrodebert.mots.ModEntities.ModEntities;
import net.hrodebert.mots.ModEntities.custom.Cmoon;
import net.hrodebert.mots.ModEntities.custom.StandEntity;
import net.hrodebert.mots.ModParticles.ModParticleTypes;
import net.hrodebert.mots.ModSounds.ModSounds;
import net.hrodebert.mots.Mots;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.Events.OnStandTimedAbilityEvent;
import net.hrodebert.mots.MotsApi.Skill;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.hrodebert.mots.PayLoads.SyncStandData;
import net.hrodebert.mots.ServerQueue.Queue;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.bossevents.CustomBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;

public class CmoonSkills {
    public static void getSkills(LivingEntity entity) {
        StandEntity standEntity;
        ArrayList skills = (ArrayList)entity.getData(Attachments.SKILLS);
        skills.add(new Skill("Manifest / Vanish", 0, false, source -> {
            Optional<StandEntity> stand = StandHandler.getStand(entity);
            if (stand.isPresent()) {
                stand.get().discard();
                ((ServerPlayer)source).connection.send((Packet)new ClientboundSetPassengersPacket((Entity)((ServerPlayer)source)));
                StandHandler.syncData(source);
                source.level().playSound(null, source.blockPosition(), ModSounds.WS_OFF.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                return;
            }
            Cmoon newStand = new Cmoon(ModEntities.CMOON.get(), source.level());
            newStand.startRiding((Entity)source);
            newStand.moveTo(source.position());
            source.level().addFreshEntity((Entity)newStand);
            source.level().playSound(null, source.blockPosition(), ModSounds.CMOON_SUMMON.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            if (source instanceof ServerPlayer) {
                ServerPlayer p = (ServerPlayer)source;
                p.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)((ServerPlayer)source)));
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(1, task -> PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new SyncStandData((Integer)source.getData(Attachments.STAND_ID), (Integer)source.getData(Attachments.COOLDOWN_TIME_ATTACK), (Integer)source.getData(Attachments.COOLDOWN_TIME_ABILITY), (Integer)source.getData(Attachments.STAMINA), (Integer)source.getData(Attachments.SKILL), (Integer)source.getData(Attachments.MAX_STAMINA)), (CustomPacketPayload[])new CustomPacketPayload[0])));
            }
        }).setIcon(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/ui/summon.png"))));
        Optional<StandEntity> p = StandHandler.getStand(entity);
        if (p.isPresent() && (standEntity = p.get()) instanceof Cmoon) {
            Cmoon stand = (Cmoon)standEntity;
            skills.add(new Skill("Uppercut", 3, false, source -> {
                StandHandler.applyCooldownAttack(source, 100);
                stand.uppercut();
                source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> ONLY ONE PUNCH!"))));
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(13, task -> StandHandler.executeScalableMeleeAttack(source, 10, new Vec3(2.0, 0.25, 2.0), Optional.of(true), Optional.of(1), false).forEach(hit -> {
                    hit.setDeltaMovement(new Vec3(0.0, 2.0, 0.0));
                    hit.hurtMarked = true;
                    source.level().players().forEach(player -> ((ServerLevel)source.level()).sendParticles((ServerPlayer)player, (ParticleOptions)ModParticleTypes.BLOOD_PARTICLE.get(), true, hit.getX(), hit.getEyeY() - 1.0, hit.getZ(), 200, 0.3, 0.3, 0.3, 0.2));
                })));
            }, ModSounds.CMOON_UPPERCUT.get()));
            skills.add(new Skill("Arm crusher", 4, false, source -> {
                StandHandler.applyCooldownAttack(source, 100);
                stand.armCrusher();
                source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> USHA"))));
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(10, task -> StandHandler.executeScalableMeleeAttack(source, 4, new Vec3(3.0, 0.25, 3.0), Optional.of(true), Optional.of(6), true).forEach(hit -> source.level().players().forEach(player -> ((ServerLevel)source.level()).sendParticles((ServerPlayer)player, (ParticleOptions)ModParticleTypes.BLOOD_PARTICLE.get(), true, hit.getX(), hit.getEyeY() - 1.0, hit.getZ(), 200, 0.3, 0.3, 0.3, 0.2)))));
            }, ModSounds.CMOON_ARM_CRUSHER.get()));
            skills.add(new Skill("Gravity manipulation: repulsion", 2, true, source -> {
                StandHandler.applyCooldownAbility(source, 80);
                source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> C-MOON!!!!"))));
                OnStandTimedAbilityEvent.Pre eventPre = new OnStandTimedAbilityEvent.Pre((int)(20.0 * StandHandler.getStandSpecial(source)) + 25, new GravityAbility());
                eventPre.source = source;
                OnStandTimedAbilityEvent.Pre eventResult = (OnStandTimedAbilityEvent.Pre)NeoForge.EVENT_BUS.post((Event)eventPre);
                if (eventResult.isCanceled()) {
                    return;
                }
                CustomBossEvent bar = new CustomBossEvent(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"cmoon_repulse"), (Component)Component.literal((String)"C-moon Repulsion"));
                bar.setColor(BossEvent.BossBarColor.GREEN);
                if (source instanceof ServerPlayer) {
                    ServerPlayer v = (ServerPlayer)source;
                    StandHandler.scalingBar(bar, v, eventResult.getDuration(), 0, Optional.of(true));
                }
                stand.setRepulsion(eventResult.getDuration());
                source.setData(Attachments.STAND_SPECIAL_POTENCY, (Object)((Double)source.getData(Attachments.STAND_SPECIAL_POTENCY) + (double)0.1f));
            }, ModSounds.CMOON_REPULSION.get()));
            skills.add(new Skill("Gravity manipulation: inversion", 3, true, source -> {
                CustomBossEvent bar = new CustomBossEvent(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"gravity_inversion"), (Component)Component.literal((String)"C-moon Inversion"));
                bar.setColor(BossEvent.BossBarColor.GREEN);
                OnStandTimedAbilityEvent.Pre eventPre = new OnStandTimedAbilityEvent.Pre((int)(10.0 * StandHandler.getStandSpecial(source)) + 25, new GravityAbility());
                eventPre.source = source;
                OnStandTimedAbilityEvent.Pre eventResult = (OnStandTimedAbilityEvent.Pre)NeoForge.EVENT_BUS.post((Event)eventPre);
                if (eventResult.isCanceled()) {
                    return;
                }
                if (source instanceof ServerPlayer) {
                    ServerPlayer v = (ServerPlayer)source;
                    StandHandler.scalingBar(bar, v, (int)(10.0 * StandHandler.getStandSpecial((LivingEntity)v)) + 20, 0, Optional.of(true));
                }
                source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> I am the center of the gravitational pull!"))));
                source.setData(Attachments.COOLDOWN_TIME_ABILITY, (Object)(60 + (int)(20.0 * StandHandler.getStandSpecial(source) + 20.0)));
                stand.switchGravity();
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task((int)(20.0 * StandHandler.getStandSpecial(source) + 20.0 + 5.0), task -> {
                    stand.switchGravity();
                    OnStandTimedAbilityEvent.Pre eventPost = new OnStandTimedAbilityEvent.Pre((int)(20.0 * StandHandler.getStandSpecial(source)) + 20, new GravityAbility());
                    eventPost.source = source;
                    NeoForge.EVENT_BUS.post((Event)eventPost);
                }));
            }, ModSounds.CMOON_INVERSION.get()));
        }
    }

    public static class GravityAbility
    extends OnStandTimedAbilityEvent.AbilityType {
        @Override
        public ResourceLocation getAbilityType() {
            return ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"gravity_ability");
        }
    }
}

