/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.MotsApi.Skills.CrazyDiamond;

import com.llamalad7.mixinextras.lib.apache.commons.tuple.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.hrodebert.mots.ModEntities.ModEntities;
import net.hrodebert.mots.ModEntities.custom.CrazyDiamond;
import net.hrodebert.mots.ModEntities.custom.StandEntity;
import net.hrodebert.mots.ModParticles.ModParticleTypes;
import net.hrodebert.mots.ModSounds.ModSounds;
import net.hrodebert.mots.Mots;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.Skill;
import net.hrodebert.mots.MotsApi.Skills.CrazyDiamond.CrazyDiamondsAttachments;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.hrodebert.mots.PayLoads.SyncStandData;
import net.hrodebert.mots.ServerQueue.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class CrazyDiamondSkills {
    public static void getSkills(LivingEntity entity) {
        StandEntity standEntity;
        ArrayList skills = (ArrayList)entity.getData(Attachments.SKILLS);
        skills.add(new Skill("Manifest / Vanish", 0, false, source -> {
            Optional<StandEntity> stand = StandHandler.getStand(source);
            if (stand.isPresent()) {
                stand.get().discard();
                ((ServerPlayer)source).connection.send((Packet)new ClientboundSetPassengersPacket((Entity)((ServerPlayer)source)));
                StandHandler.syncData(source);
                source.level().playSound(null, source.blockPosition(), ModSounds.CRAZY_DIAMOND_OFF.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                return;
            }
            CrazyDiamond newStand = new CrazyDiamond(ModEntities.CRAZY_DIAMOND.get(), source.level());
            newStand.startRiding((Entity)source);
            newStand.moveTo(source.position());
            source.level().addFreshEntity((Entity)newStand);
            source.level().playSound(null, source.blockPosition(), ModSounds.CRAZY_DIAMOND_SUMMON.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            if (source instanceof ServerPlayer) {
                ServerPlayer p = (ServerPlayer)source;
                p.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)p));
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(1, task -> PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new SyncStandData((Integer)source.getData(Attachments.STAND_ID), (Integer)source.getData(Attachments.COOLDOWN_TIME_ATTACK), (Integer)source.getData(Attachments.COOLDOWN_TIME_ABILITY), (Integer)source.getData(Attachments.STAMINA), (Integer)source.getData(Attachments.SKILL), (Integer)source.getData(Attachments.MAX_STAMINA)), (CustomPacketPayload[])new CustomPacketPayload[0])));
            }
        }).setIcon(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/ui/summon.png"))));
        Optional<StandEntity> s = StandHandler.getStand(entity);
        if (s.isPresent() && (standEntity = s.get()) instanceof CrazyDiamond) {
            CrazyDiamond passenger = (CrazyDiamond)standEntity;
            skills.add(new Skill("Chop", 2, false, source -> {
                source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> Dora!"))));
                passenger.chop();
                StandHandler.applyCooldownAttack(source, 40);
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(10, task -> {
                    Integer damage = 2;
                    if (((Boolean)source.getData(CrazyDiamondsAttachments.HEAL_MODE)).booleanValue()) {
                        damage = null;
                    }
                    Integer finalDamage = damage;
                    StandHandler.executeScalableMeleeAttack(source, damage, new Vec3(3.0, 0.25, 3.0), Optional.of(true), Optional.of(2), true).forEach(t -> {
                        if (finalDamage == null && !(t instanceof StandEntity) && t instanceof LivingEntity) {
                            LivingEntity living = (LivingEntity)t;
                            living.heal(2.0f);
                            source.level().playSound(null, source.blockPosition(), ModSounds.CRAZY_DIAMOND_HEAL.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                        }
                        source.level().players().forEach(player -> ((ServerLevel)source.level()).sendParticles((ServerPlayer)player, (ParticleOptions)ModParticleTypes.BLOOD_PARTICLE.get(), true, t.getX(), t.getEyeY() - 1.0, t.getZ(), 200, 0.3, 0.3, 0.3, 0.2));
                    });
                }));
            }, ModSounds.CRAZY_DIAMOND_CHOP.get()));
            skills.add(new Skill("Finisher", 4, false, source -> {
                source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + ">DORA!!!!"))));
                passenger.finisher();
                StandHandler.applyCooldownAttack(source, 40);
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(10, task -> {
                    Integer damage = 6;
                    if (((Boolean)source.getData(CrazyDiamondsAttachments.HEAL_MODE)).booleanValue()) {
                        damage = null;
                    }
                    Integer finalDamage = damage;
                    List<Entity> targets = StandHandler.executeScalableMeleeAttack(source, damage, new Vec3(3.0, 0.25, 3.0), Optional.of(true), Optional.of(2), true);
                    targets.forEach(t -> {
                        if (finalDamage == null && !(t instanceof StandEntity) && t instanceof LivingEntity) {
                            LivingEntity living = (LivingEntity)t;
                            living.heal(5.0f);
                            source.level().playSound(null, source.blockPosition(), ModSounds.CRAZY_DIAMOND_HEAL.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                        }
                    });
                    StandHandler.knockBackEntityList(source, targets);
                }));
            }, ModSounds.CRAZY_DIAMOND_FINISHER.get()));
            skills.add(new Skill("Ground kick", 5, false, source -> {
                source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + ">DORA!!!!"))));
                passenger.ground_kick();
                StandHandler.applyCooldownAttack(source, 40);
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(9, task -> {
                    Integer damage = 7;
                    if (((Boolean)source.getData(CrazyDiamondsAttachments.HEAL_MODE)).booleanValue()) {
                        damage = null;
                    }
                    Integer finalDamage = damage;
                    List<Entity> targets = StandHandler.executeScalableMeleeAttack(source, damage, new Vec3(3.0, 4.0, 3.0), Optional.of(true), Optional.of(0), true);
                    targets.forEach(t -> {
                        if (finalDamage == null && !(t instanceof StandEntity) && t instanceof LivingEntity) {
                            LivingEntity living = (LivingEntity)t;
                            living.heal(5.0f);
                            source.level().playSound(null, source.blockPosition(), ModSounds.CRAZY_DIAMOND_HEAL.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                        }
                    });
                }));
            }, ModSounds.CRAZY_DIAMOND_FINISHER.get()));
            skills.add(new Skill("Barrage", 6, false, source -> {
                try {
                    source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> DORARARARARARARARARA!"))));
                    passenger.barrage();
                    StandHandler.applyCooldownAttack(source, 20);
                    source.setData(Attachments.STAND_ATTACK_POTENCY, (Object)((Double)source.getData(Attachments.STAND_ATTACK_POTENCY) + 0.1));
                    Double damage = 7.0;
                    damage = damage + (double)StandHandler.getStandPowerModifier(source);
                    if (((Boolean)source.getData(CrazyDiamondsAttachments.HEAL_MODE)).booleanValue()) {
                        damage = null;
                    }
                    Double finalDamage = damage / 30.0;
                    for (int i = 0; i < 118; ++i) {
                        if (i % 2 == 0) {
                            Mots.serverTaskExecutioner.tasks.add(new Queue.Task(i + 5, task -> {
                                StandHandler.applyCooldownAttack(source, 20);
                                StandHandler.executeMeleAttack(source, Float.valueOf(finalDamage.floatValue()), new Vec3(2.0, 0.25, 2.0), Optional.of(true), Optional.of(3), true).forEach(t -> {
                                    if (finalDamage == null && !(t instanceof StandEntity) && t instanceof LivingEntity) {
                                        LivingEntity living = (LivingEntity)t;
                                        living.heal(5.0f);
                                        source.level().playSound(null, source.blockPosition(), ModSounds.CRAZY_DIAMOND_HEAL.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                                    }
                                });
                            }));
                            continue;
                        }
                        Mots.serverTaskExecutioner.tasks.add(new Queue.Task(i + 5, task -> {
                            StandHandler.applyCooldownAttack(source, 20);
                            StandHandler.executeMeleAttack(source, null, new Vec3(2.0, 0.25, 2.0), Optional.of(true), Optional.of(3), true);
                        }));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, ModSounds.CRAZY_DIAMOND_BARRAGE.get()));
            if (!entity.hasData(CrazyDiamondsAttachments.HEAL_MODE)) {
                entity.setData(CrazyDiamondsAttachments.HEAL_MODE, (Object)false);
            }
            skills.add(new Skill("Mode switch", 0, true, source -> {
                source.setData(CrazyDiamondsAttachments.HEAL_MODE, (Object)((Boolean)source.getData(CrazyDiamondsAttachments.HEAL_MODE) == false ? 1 : 0));
                if (source instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)source;
                    Object mode = "Mode: ";
                    mode = (Boolean)source.getData(CrazyDiamondsAttachments.HEAL_MODE) != false ? (String)mode + "Heal" : (String)mode + "Break";
                    player.sendSystemMessage((Component)Component.literal((String)mode));
                }
            }));
            skills.add(new Skill("Replace broken blocks", 5, true, source -> {
                if (source.hasData(CrazyDiamondsAttachments.BLOCKS)) {
                    ArrayList data = (ArrayList)source.getData(CrazyDiamondsAttachments.BLOCKS);
                    for (int i = 0; i < data.size(); ++i) {
                        Mots.serverTaskExecutioner.tasks.add(new Queue.Task(i, task -> {
                            source.level().playSound(null, (BlockPos)((Pair)data.get((int)task)).getLeft(), ModSounds.CRAZY_DIAMOND_HEAL.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                            source.level().setBlock((BlockPos)((Pair)data.get((int)task)).getLeft(), (BlockState)((Pair)data.get((int)task)).getRight(), 3);
                        }));
                    }
                    StandHandler.applyCooldownAbility(source, data.size() + 1);
                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(data.size() + 1, task -> ((ArrayList)source.getData(CrazyDiamondsAttachments.BLOCKS)).clear()));
                }
            }));
            return;
        }
    }
}

