/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.MotsApi.Skills;

import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.hrodebert.mots.ModEntities.ModEntities;
import net.hrodebert.mots.ModEntities.custom.D4c;
import net.hrodebert.mots.ModEntities.custom.PlayerClone.D4cPlayerClone;
import net.hrodebert.mots.ModEntities.custom.StandEntity;
import net.hrodebert.mots.ModParticles.ModParticleTypes;
import net.hrodebert.mots.ModSounds.ModSounds;
import net.hrodebert.mots.Mots;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.Skill;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.hrodebert.mots.PayLoads.SyncStandData;
import net.hrodebert.mots.ServerQueue.Queue;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class D4cSkills {
    public static void getSkills(LivingEntity entity) {
        ArrayList skills = (ArrayList)entity.getData(Attachments.SKILLS);
        skills.add(new Skill("Manifest / Vanish", 0, false, source -> {
            StandEntity patt0$temp;
            Optional<StandEntity> v = StandHandler.getStand(entity);
            if (v.isPresent() && (patt0$temp = v.get()) instanceof D4c) {
                D4c stand = (D4c)patt0$temp;
                stand.discard();
                ((ServerPlayer)source).connection.send((Packet)new ClientboundSetPassengersPacket((Entity)((ServerPlayer)source)));
                StandHandler.syncData(source);
                source.level().playSound(null, source.blockPosition(), ModSounds.D4C_OFF.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                return;
            }
            D4c stand = new D4c(ModEntities.D4C.get(), source.level());
            stand.startRiding((Entity)source);
            stand.moveTo(source.position());
            source.level().playSound(null, source.blockPosition(), ModSounds.D4C_SUMMON.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            source.level().addFreshEntity((Entity)stand);
            if (source instanceof ServerPlayer) {
                ServerPlayer p = (ServerPlayer)source;
                p.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)p));
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(1, task -> PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new SyncStandData((Integer)source.getData(Attachments.STAND_ID), (Integer)source.getData(Attachments.COOLDOWN_TIME_ATTACK), (Integer)source.getData(Attachments.COOLDOWN_TIME_ABILITY), (Integer)source.getData(Attachments.STAMINA), (Integer)source.getData(Attachments.SKILL), (Integer)source.getData(Attachments.MAX_STAMINA)), (CustomPacketPayload[])new CustomPacketPayload[0])));
            }
        }).setIcon(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/ui/summon.png"))));
        Optional<StandEntity> s = StandHandler.getStand(entity);
        if (s.isPresent()) {
            StandEntity passenger = s.get();
            skills.add(new Skill("Chop", 3, false, source -> {
                source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> Hora!"))));
                if (passenger instanceof D4c) {
                    D4c stand = (D4c)passenger;
                    try {
                        stand.chop();
                        StandHandler.applyCooldownAttack(source, 40);
                        Mots.serverTaskExecutioner.tasks.add(new Queue.Task(8, task -> StandHandler.executeScalableMeleeAttack(source, 5, new Vec3(3.0, 0.25, 3.0), Optional.of(true), Optional.of(2), true).forEach(livingTarget -> source.level().players().forEach(player -> ((ServerLevel)source.level()).sendParticles((ServerPlayer)player, (ParticleOptions)ModParticleTypes.BLOOD_PARTICLE.get(), true, livingTarget.getX(), livingTarget.getEyeY() - 1.0, livingTarget.getZ(), 200, 0.3, 0.3, 0.3, 0.2)))));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, ModSounds.D4C_HORA.get()));
            skills.add(new Skill("Finisher", 4, false, source -> {
                if (passenger instanceof D4c) {
                    D4c stand = (D4c)passenger;
                    try {
                        source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> USHAAAA!"))));
                        stand.finisher();
                        StandHandler.applyCooldownAttack(source, 60);
                        Mots.serverTaskExecutioner.tasks.add(new Queue.Task(13, task -> StandHandler.knockBackEntityList(source, StandHandler.executeScalableMeleeAttack(source, 5, new Vec3(2.0, 0.25, 2.0), Optional.of(false), Optional.of(0), true))));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, ModSounds.D4C_TODOMEDA.get()));
            skills.add(new Skill("Dimensional manipulation: Travel", 4, true, source -> {
                if (passenger instanceof D4c) {
                    D4c stand = (D4c)passenger;
                    stand.d4cDimensionalTravel();
                    source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> D4C BRING ME TO AN OTHER DIMENSION!"))));
                    StandHandler.applyCooldownAbility(source, 200);
                }
            }, ModSounds.D4C_DIMENSIONAL_TRAVEL.get()));
            skills.add(new Skill("Dimensional manipulation: Clones", 4, true, source -> {
                if (passenger instanceof D4c) {
                    D4c stand = (D4c)passenger;
                    source.getServer().getPlayerList().getPlayers().forEach(player -> {
                        StandHandler.applyCooldownAbility(source, 200);
                        player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> Dojaaaaaan~ ")));
                        D4cPlayerClone clone = new D4cPlayerClone(ModEntities.CLONE.get(), source.level());
                        clone.moveTo(source.position());
                        clone.tame((Player)source);
                        clone.setOwner(source.getUUID());
                        source.level().addFreshEntity((Entity)clone);
                        clone.setCustomName(((ServerPlayer)source).getDisplayName());
                        StandHandler.applyCooldownAbility(source, 200);
                    });
                }
            }, ModSounds.D4C_DIMENSIONAL_CLONES.get()));
            skills.add(new Skill("Dimensional manipulation: Clone swap", 0, true, source -> {
                if (passenger instanceof D4c) {
                    D4c stand = (D4c)passenger;
                    source.getServer().getPlayerList().getPlayers().forEach(player -> {
                        player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> Tadaaaaannn~ ")));
                        StandHandler.applyCooldownAbility(source, 100);
                        source.level().getEntities((Entity)source, source.getBoundingBox().inflate(40.0)).forEach(ent -> {
                            D4cPlayerClone clone;
                            if (ent instanceof D4cPlayerClone && (clone = (D4cPlayerClone)((Object)((Object)((Object)ent)))).getOwner().is((Entity)source)) {
                                Vec3 oldPos = source.position();
                                source.teleportTo(clone.position().x, clone.position().y, clone.position().z);
                                clone.teleportTo(oldPos.x, oldPos.y, oldPos.z);
                                return;
                            }
                        });
                    });
                }
            }));
            skills.add(new Skill("Dimensional manipulation: Clone heal", 6, true, source -> {
                if (passenger instanceof D4c) {
                    D4c stand = (D4c)passenger;
                    source.getServer().getPlayerList().getPlayers().forEach(player -> {
                        player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> Surprise!!!!~ ")));
                        StandHandler.applyCooldownAbility(source, 300);
                        AtomicBoolean executed = new AtomicBoolean(false);
                        source.level().getEntities((Entity)source, source.getBoundingBox().inflate(40.0)).forEach(ent -> {
                            D4cPlayerClone clone;
                            if (!executed.get() && ent instanceof D4cPlayerClone && (clone = (D4cPlayerClone)((Object)((Object)((Object)ent)))).getOwner().is((Entity)source)) {
                                source.teleportTo(clone.position().x, clone.position().y, clone.position().z);
                                clone.remove(Entity.RemovalReason.DISCARDED);
                                source.heal(6.0f);
                                executed.set(true);
                            }
                        });
                    });
                }
            }));
        }
    }
}

