/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.MotsApi.Skills.DiverDownSkills;

import com.llamalad7.mixinextras.lib.apache.commons.tuple.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.hrodebert.mots.ModEntities.ModEntities;
import net.hrodebert.mots.ModEntities.custom.DiverDown;
import net.hrodebert.mots.ModEntities.custom.StandEntity;
import net.hrodebert.mots.ModParticles.ModParticleTypes;
import net.hrodebert.mots.ModSounds.ModSounds;
import net.hrodebert.mots.Mots;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.Skill;
import net.hrodebert.mots.MotsApi.Skills.DiverDownSkills.DiverDownAttachments;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.hrodebert.mots.PayLoads.SyncStandData;
import net.hrodebert.mots.ServerQueue.Queue;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class DiverDownSkill {
    public static void getSkills(LivingEntity entity) {
        StandEntity standEntity;
        ArrayList skills = (ArrayList)entity.getData(Attachments.SKILLS);
        skills.add(new Skill("Manifest / Vanish", 0, false, source -> {
            StandEntity patt0$temp;
            Optional<StandEntity> v = StandHandler.getStand(entity);
            if (v.isPresent() && (patt0$temp = v.get()) instanceof DiverDown) {
                DiverDown stand = (DiverDown)patt0$temp;
                stand.discard();
                ((ServerPlayer)source).connection.send((Packet)new ClientboundSetPassengersPacket((Entity)((ServerPlayer)source)));
                StandHandler.syncData(source);
                source.level().playSound(null, source.blockPosition(), ModSounds.DIVER_DOWN_OFF.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                return;
            }
            DiverDown stand = new DiverDown(ModEntities.DIVER_DOWN.get(), source.level());
            stand.startRiding((Entity)source);
            stand.moveTo(source.position());
            source.level().playSound(null, source.blockPosition(), ModSounds.DIVER_DOWN_SUMMON.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            source.level().addFreshEntity((Entity)stand);
            if (source instanceof ServerPlayer) {
                ServerPlayer p = (ServerPlayer)source;
                p.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)p));
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(1, task -> PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new SyncStandData((Integer)source.getData(Attachments.STAND_ID), (Integer)source.getData(Attachments.COOLDOWN_TIME_ATTACK), (Integer)source.getData(Attachments.COOLDOWN_TIME_ABILITY), (Integer)source.getData(Attachments.STAMINA), (Integer)source.getData(Attachments.SKILL), (Integer)source.getData(Attachments.MAX_STAMINA)), (CustomPacketPayload[])new CustomPacketPayload[0])));
            }
        }).setIcon(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/ui/summon.png"))));
        Optional<StandEntity> standOptional = StandHandler.getStand(entity);
        if (standOptional.isPresent() && (standEntity = standOptional.get()) instanceof DiverDown) {
            DiverDown stand = (DiverDown)standEntity;
            skills.add(new Skill("Disfigurative chop", 4, false, source -> {
                source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> My diver down can modify your structure!"))));
                stand.chop();
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(15, t -> {
                    if (source.hasData(DiverDownAttachments.STORING_KINETIC)) {
                        if (!source.hasData(DiverDownAttachments.KINETIC_ENERGY)) {
                            source.setData(DiverDownAttachments.KINETIC_ENERGY, new ArrayList());
                        }
                        if (((Boolean)source.getData(DiverDownAttachments.STORING_KINETIC)).booleanValue()) {
                            ArrayList kinetic = (ArrayList)source.getData(DiverDownAttachments.KINETIC_ENERGY);
                            List<Entity> entities = StandHandler.executeScalableMeleeAttack(source, null, new Vec3(4.0, 0.25, 4.0), Optional.of(false), Optional.of(0), true);
                            entities.forEach(entry -> {
                                int i;
                                if (source.isCrouching()) {
                                    if (entry instanceof LivingEntity) {
                                        livingTarget = (LivingEntity)entry;
                                        livingTarget.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 80));
                                        livingTarget.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 80));
                                    }
                                } else if (entry instanceof LivingEntity) {
                                    livingTarget = (LivingEntity)entry;
                                    for (i = 0; i < 10; ++i) {
                                        Mots.serverTaskExecutioner2.tasks.add(new Queue.Task(20 * i, task -> {
                                            livingTarget.addEffect(new MobEffectInstance(MobEffects.JUMP, 20, 2));
                                            livingTarget.jumpFromGround();
                                            livingTarget.hurt(source.damageSources().generic(), livingTarget.getMaxHealth() / 100.0f * 2.0f);
                                            source.level().players().forEach(player -> ((ServerLevel)source.level()).sendParticles((ServerPlayer)player, (ParticleOptions)ModParticleTypes.BLOOD_PARTICLE.get(), true, livingTarget.getX(), livingTarget.getEyeY() - 1.0, livingTarget.getZ(), 200, 0.3, 0.3, 0.3, 0.2));
                                        }));
                                    }
                                }
                                if (entry instanceof LivingEntity) {
                                    LivingEntity living = (LivingEntity)entry;
                                    for (i = 0; i < kinetic.size(); ++i) {
                                        Pair obj = (Pair)kinetic.get(i);
                                        if (!((LivingEntity)obj.getLeft()).equals((Object)living)) continue;
                                        kinetic.add(Pair.of((Object)living, (Object)((int)((float)((Integer)obj.getRight()).intValue() + StandHandler.getStandPowerModifier(source) + 3.0f))));
                                        kinetic.remove(i);
                                        return;
                                    }
                                    kinetic.add(Pair.of((Object)living, (Object)((int)(StandHandler.getStandPowerModifier(source) + 3.0f))));
                                }
                            });
                            return;
                        }
                    }
                    StandHandler.executeScalableMeleeAttack(source, 3, new Vec3(2.0, 1.0, 2.0), Optional.of(false), Optional.of(0), true).forEach(target -> {
                        if (source.isCrouching()) {
                            if (target instanceof LivingEntity) {
                                LivingEntity livingTarget = (LivingEntity)target;
                                livingTarget.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 80));
                                livingTarget.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 80));
                            }
                        } else if (target instanceof LivingEntity) {
                            LivingEntity livingTarget = (LivingEntity)target;
                            for (int i = 0; i < 10; ++i) {
                                Mots.serverTaskExecutioner2.tasks.add(new Queue.Task(20 * i, task -> {
                                    livingTarget.addEffect(new MobEffectInstance(MobEffects.JUMP, 20, 2));
                                    livingTarget.jumpFromGround();
                                    livingTarget.hurt(source.damageSources().generic(), livingTarget.getMaxHealth() / 100.0f * 2.0f);
                                }));
                            }
                        }
                    });
                }));
                StandHandler.applyCooldownAttack(source, 60);
            }, ModSounds.DIVER_DOWN_CHOP.get()));
            skills.add(new Skill("Finisher", 4, false, source -> {
                source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> Take this!"))));
                stand.impale();
                StandHandler.applyCooldownAttack(source, 100);
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(12, task -> {
                    if (source.hasData(DiverDownAttachments.STORING_KINETIC)) {
                        if (!source.hasData(DiverDownAttachments.KINETIC_ENERGY)) {
                            source.setData(DiverDownAttachments.KINETIC_ENERGY, new ArrayList());
                        }
                        if (((Boolean)source.getData(DiverDownAttachments.STORING_KINETIC)).booleanValue()) {
                            ArrayList kinetic = (ArrayList)source.getData(DiverDownAttachments.KINETIC_ENERGY);
                            List<Entity> entities = StandHandler.executeScalableMeleeAttack(source, null, new Vec3(4.0, 0.25, 4.0), Optional.of(false), Optional.of(0), true);
                            entities.forEach(entry -> {
                                if (entry instanceof LivingEntity) {
                                    LivingEntity living = (LivingEntity)entry;
                                    for (int i = 0; i < kinetic.size(); ++i) {
                                        Pair obj = (Pair)kinetic.get(i);
                                        if (!((LivingEntity)obj.getLeft()).equals((Object)living)) continue;
                                        kinetic.add(Pair.of((Object)living, (Object)((int)((float)((Integer)obj.getRight()).intValue() + StandHandler.getStandPowerModifier(source) + 5.0f))));
                                        kinetic.remove(i);
                                        return;
                                    }
                                    kinetic.add(Pair.of((Object)living, (Object)((int)(StandHandler.getStandPowerModifier(source) + 5.0f))));
                                }
                            });
                            StandHandler.knockBackEntityList(source, entities);
                            return;
                        }
                    }
                    StandHandler.knockBackEntityList(source, StandHandler.executeScalableMeleeAttack(source, 5, new Vec3(4.0, 0.25, 4.0), Optional.of(false), Optional.of(0), true));
                }));
            }, ModSounds.DIVER_DOWN_STRONG_PUNCH.get()));
            skills.add(new Skill("Storage mode", 0, true, source -> {
                if (!source.hasData(DiverDownAttachments.STORING_KINETIC)) {
                    source.setData(DiverDownAttachments.STORING_KINETIC, (Object)true);
                    source.sendSystemMessage((Component)Component.literal((String)"You are now in storing mode"));
                } else {
                    source.setData(DiverDownAttachments.STORING_KINETIC, (Object)((Boolean)source.getData(DiverDownAttachments.STORING_KINETIC) == false ? 1 : 0));
                    if (((Boolean)source.getData(DiverDownAttachments.STORING_KINETIC)).booleanValue()) {
                        source.sendSystemMessage((Component)Component.literal((String)"You are now in storing mode"));
                    } else {
                        source.sendSystemMessage((Component)Component.literal((String)"You exited storing mode"));
                    }
                }
            }));
            skills.add(new Skill("Release kinetic energy", 0, true, source -> {
                if (source.hasData(DiverDownAttachments.KINETIC_ENERGY)) {
                    ArrayList kinetic = (ArrayList)source.getData(DiverDownAttachments.KINETIC_ENERGY);
                    kinetic.forEach(entry -> {
                        try {
                            if (!(entry.getLeft() instanceof StandEntity)) {
                                ((LivingEntity)entry.getLeft()).hurt(new DamageSource(source.level().damageSources().mobAttack(source).typeHolder()), (float)((Integer)entry.getRight()).intValue());
                                LivingEntity livingTarget = (LivingEntity)entry.getLeft();
                                source.level().players().forEach(player -> ((ServerLevel)source.level()).sendParticles((ServerPlayer)player, (ParticleOptions)ModParticleTypes.BLOOD_PARTICLE.get(), true, livingTarget.getX(), livingTarget.getEyeY() - 1.0, livingTarget.getZ(), 200, 0.3, 0.3, 0.3, 0.2));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                    kinetic.clear();
                }
            }));
        }
    }
}

