/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.MotsApi.Skills.GoldenExperience;

import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.hrodebert.mots.ModEntities.ModEntities;
import net.hrodebert.mots.ModEntities.custom.GoldenExperience;
import net.hrodebert.mots.ModEntities.custom.StandEntity;
import net.hrodebert.mots.ModSounds.ModSounds;
import net.hrodebert.mots.Mots;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.Skill;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.hrodebert.mots.PayLoads.SyncStandData;
import net.hrodebert.mots.ServerQueue.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class GoldenExperienceSkills {
    public static void getSkills(LivingEntity entity) {
        StandEntity standEntity;
        ArrayList skills = (ArrayList)entity.getData(Attachments.SKILLS);
        skills.add(new Skill("Manifest / Vanish", 0, false, source -> {
            Optional<StandEntity> stand = StandHandler.getStand(source);
            if (stand.isPresent()) {
                stand.get().discard();
                ((ServerPlayer)source).connection.send((Packet)new ClientboundSetPassengersPacket((Entity)((ServerPlayer)source)));
                StandHandler.syncData(source);
                source.level().playSound(null, source.blockPosition(), ModSounds.GOLDEN_EXPERIENCE_UNSUMMON.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                return;
            }
            GoldenExperience standNew = new GoldenExperience(ModEntities.GOLDEN_EXPERIENCE.get(), source.level());
            standNew.startRiding((Entity)source);
            source.level().playSound(null, source.blockPosition(), ModSounds.GOLDEN_EXPERIENCE_SUMMON.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            standNew.moveTo(source.position());
            source.level().addFreshEntity((Entity)standNew);
            standNew.triggerAnim("controller", "summon");
            if (source instanceof ServerPlayer) {
                ServerPlayer p = (ServerPlayer)source;
                p.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)p));
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(20, task -> PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new SyncStandData((Integer)source.getData(Attachments.STAND_ID), (Integer)source.getData(Attachments.COOLDOWN_TIME_ATTACK), (Integer)source.getData(Attachments.COOLDOWN_TIME_ABILITY), (Integer)source.getData(Attachments.STAMINA), (Integer)source.getData(Attachments.SKILL), (Integer)source.getData(Attachments.MAX_STAMINA)), (CustomPacketPayload[])new CustomPacketPayload[0])));
            }
        }).setIcon(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/ui/summon.png"))));
        Optional<StandEntity> s = StandHandler.getStand(entity);
        if (s.isPresent() && (standEntity = s.get()) instanceof GoldenExperience) {
            GoldenExperience passenger = (GoldenExperience)standEntity;
            skills.add(new Skill("Finisher", 4, false, source -> {
                passenger.triggerAnim("controller", "strong punch");
                StandHandler.applyCooldownAttack(source, 40);
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(12, t -> StandHandler.knockBackEntityList(source, StandHandler.executeScalableMeleeAttack(source, 4, new Vec3(3.0, 0.5, 3.0), Optional.of(false), Optional.empty(), false))));
            }, ModSounds.GOLDEN_EXPERIENCE_SOUL_PUNCH.get()));
            skills.add(new Skill("Soul punch", 6, false, source -> {
                passenger.triggerAnim("controller", "strong punch");
                StandHandler.applyCooldownAttack(source, 40);
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(12, t -> StandHandler.executeScalableMeleeAttack(source, 4, new Vec3(3.0, 0.5, 3.0), Optional.of(false), Optional.empty(), false).forEach(e -> {
                    if (e instanceof LivingEntity) {
                        LivingEntity l = (LivingEntity)e;
                        l.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 255));
                        l.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 100, 255));
                        l.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 100, 255));
                    }
                })));
            }, ModSounds.GOLDEN_EXPERIENCE_SOUL_PUNCH.get()));
            skills.add(new Skill("Barrage", 3, false, source -> {
                if (passenger instanceof GoldenExperience) {
                    GoldenExperience stand = passenger;
                    try {
                        source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> MUDA,MUDA,MUDA,MUDA,MUDA,MUDA,MUDA!!!!!!"))));
                        passenger.triggerAnim("controller", "barrage");
                        Double damage = 7.0;
                        damage = damage + (double)StandHandler.getStandPowerModifier(source);
                        Double finalDamage = damage / 30.0;
                        StandHandler.applyCooldownAttack(source, 20);
                        source.setData(Attachments.STAND_ATTACK_POTENCY, (Object)((Double)source.getData(Attachments.STAND_ATTACK_POTENCY) + 0.1));
                        for (int i = 0; i < 158; ++i) {
                            if (i % 2 == 0) {
                                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(i + 5, task -> {
                                    StandHandler.applyCooldownAttack(source, 20);
                                    StandHandler.executeMeleAttack(source, Float.valueOf(finalDamage.floatValue()), new Vec3(2.0, 0.25, 2.0), Optional.of(true), Optional.of(3), true);
                                }));
                                continue;
                            }
                            Mots.serverTaskExecutioner.tasks.add(new Queue.Task(i + 5, task -> {
                                StandHandler.applyCooldownAttack(source, 20);
                                StandHandler.executeMeleAttack(source, null, new Vec3(2.0, 0.25, 2.0), Optional.of(true), Optional.of(3), true);
                            }));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, ModSounds.GOLDEN_EXPERIENCE_BARRAGE.get()));
            skills.add(new Skill("Spawn bee army", 3, true, source -> {
                StandHandler.applyCooldownAbility(source, 160);
                source.setData(Attachments.STAND_SPECIAL_POTENCY, (Object)((Double)source.getData(Attachments.STAND_SPECIAL_POTENCY) + 0.1));
                ArrayList<Bee> bees = new ArrayList<Bee>();
                int i = 0;
                while ((double)i < StandHandler.getStandSpecial(entity) / 2.0) {
                    if (source.getLastHurtMob() != null) {
                        bees.add(new Bee(EntityType.BEE, source.level()));
                        ((Bee)bees.get(i)).setTarget(source.getLastHurtMob());
                        ((Bee)bees.get(i)).teleportTo(source.getX(), source.getY(), source.getZ());
                        source.level().addFreshEntity((Entity)bees.get(i));
                        ((Bee)bees.get(i)).setInvulnerable(true);
                    }
                    ++i;
                }
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(140, t -> bees.forEach(Entity::discard)));
            }, ModSounds.GOLDEN_EXPERIENCE_BEE.get()));
            skills.add(new Skill("Create tree", 4, true, source -> {
                passenger.triggerAnim("controller", "Tree kick");
                source.setData(Attachments.STAND_SPECIAL_POTENCY, (Object)((Double)source.getData(Attachments.STAND_SPECIAL_POTENCY) + 0.1));
                AtomicReference oldPos = new AtomicReference();
                StandHandler.applyCooldownAbility(source, 40);
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(12, t -> {
                    source.level().explode((Entity)source, source.getX(), source.getY(), source.getZ(), 5.0f, Level.ExplosionInteraction.NONE);
                    TreeGrower grower = TreeGrower.OAK;
                    ServerLevel level = (ServerLevel)source.level();
                    oldPos.set(source.blockPosition());
                    source.setInvulnerable(true);
                    grower.growTree(level, level.getChunkSource().getGenerator(), source.blockPosition(), source.getBlockStateOn(), RandomSource.create());
                }));
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(13, t -> {
                    BlockPos pos = source.blockPosition();
                    while (!source.level().getBlockState(pos).isAir()) {
                        pos = new BlockPos(pos.getX(), pos.getY() + 1, pos.getZ());
                    }
                    source.teleportTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                }));
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(20, t -> {
                    ServerLevel level = (ServerLevel)source.level();
                    BlockPos origin = (BlockPos)oldPos.get();
                    int radius = 5;
                    int height = 10;
                    BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                    for (int dx = -radius; dx <= radius; ++dx) {
                        for (int dz = -radius; dz <= radius; ++dz) {
                            for (int dy = 0; dy <= height; ++dy) {
                                mutablePos.set(origin.getX() + dx, origin.getY() + dy, origin.getZ() + dz);
                                BlockState state = level.getBlockState((BlockPos)mutablePos);
                                if (!state.is(BlockTags.LOGS) && !state.is(BlockTags.LEAVES)) continue;
                                level.setBlock((BlockPos)mutablePos, Blocks.AIR.defaultBlockState(), 3);
                            }
                        }
                    }
                }));
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(40, t -> source.setInvulnerable(false)));
            }, ModSounds.GOLDEN_EXPERIENCE_TREE.get()));
            if (entity.isCrouching()) {
                skills.add(new Skill("Self Heal", 6, true, source -> {
                    StandHandler.applyCooldownAbility(source, 40);
                    source.setData(Attachments.STAND_SPECIAL_POTENCY, (Object)((Double)source.getData(Attachments.STAND_SPECIAL_POTENCY) + 0.1));
                    source.heal((float)(StandHandler.getStandSpecial(source) / 1.5));
                }, ModSounds.GOLDEN_EXPERIENCE_HEAL.get()));
            } else {
                skills.add(new Skill("Heal", 6, true, source -> {
                    StandHandler.applyCooldownAbility(source, 40);
                    passenger.triggerAnim("controller", "strong punch");
                    StandHandler.applyCooldownAttack(source, 40);
                    source.setData(Attachments.STAND_SPECIAL_POTENCY, (Object)((Double)source.getData(Attachments.STAND_SPECIAL_POTENCY) + 0.1));
                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(12, t -> StandHandler.executeScalableMeleeAttack(source, null, new Vec3(3.0, 0.5, 3.0), Optional.of(false), Optional.empty(), false).forEach(e -> {
                        if (e instanceof LivingEntity) {
                            LivingEntity living = (LivingEntity)e;
                            living.heal((float)(StandHandler.getStandSpecial(source) / 1.5));
                        }
                    })));
                }, ModSounds.GOLDEN_EXPERIENCE_HEAL.get()));
            }
            skills.add(new Skill("Turn item in frog", 3, true, source -> {
                Frog frog = new Frog(EntityType.FROG, source.level());
                frog.teleportTo(source.getX(), source.getY(), source.getZ());
                frog.setItemSlot(EquipmentSlot.BODY, source.getItemInHand(InteractionHand.MAIN_HAND));
                frog.setGuaranteedDrop(EquipmentSlot.BODY);
                source.level().addFreshEntity((Entity)frog);
                frog.setInvulnerable(true);
                frog.setData(Attachments.TW_OH_ALLY, (Object)source.getUUID());
                source.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.AIR));
            }));
            skills.add(new Skill("Set frog target position", 0, true, source -> source.setData(Attachments.TARGET_POS.get(), (Object)source.position())));
        }
    }
}

