/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.MotsApi.Skills;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.hrodebert.mots.ModEntities.ModEntities;
import net.hrodebert.mots.ModEntities.custom.KillerQueen;
import net.hrodebert.mots.ModEntities.custom.SheerHearthAttack;
import net.hrodebert.mots.ModEntities.custom.StandEntity;
import net.hrodebert.mots.ModItems.DataComponents.Components;
import net.hrodebert.mots.ModItems.DataComponents.KillerQueenItemBombRecord;
import net.hrodebert.mots.ModParticles.ModParticleTypes;
import net.hrodebert.mots.ModSounds.ModSounds;
import net.hrodebert.mots.Mots;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.Skill;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.hrodebert.mots.PayLoads.SyncStandData;
import net.hrodebert.mots.ServerQueue.Queue;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetCameraPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class KillerQueenSkill {
    public static void livingHurtEvent(LivingDamageEvent.Pre dmg) {
        if (dmg.getEntity().hasData(Attachments.BITE_THE_DUST.get()) && ((Boolean)dmg.getEntity().getData(Attachments.BITE_THE_DUST.get())).booleanValue() && dmg.getEntity().getHealth() - dmg.getNewDamage() <= 0.0f) {
            LivingEntity source = dmg.getEntity();
            dmg.setNewDamage(0.0f);
            source.setData(Attachments.BITE_THE_DUST, (Object)false);
            ArrayList entities = (ArrayList)source.getData(Attachments.BITE_THE_DUST_ENTITIES.get());
            entities.forEach(e -> {
                ((Entity)e.getFirst()).teleportTo(((Vec3)e.getSecond()).x, ((Vec3)e.getSecond()).y, ((Vec3)e.getSecond()).z);
                if (((Entity)e.getFirst()).is((Entity)source)) {
                    source.heal(source.getMaxHealth());
                } else {
                    double density = 0.5;
                    float damage = 3.0f * StandHandler.getStandPowerModifier((LivingEntity)((ServerPlayer)source));
                    ((Entity)e.getFirst()).hurt(new DamageSource(((Entity)e.getFirst()).damageSources().generic().typeHolder()), damage);
                    if (e.getFirst() instanceof LivingEntity) {
                        StandHandler.applyCooldownAttack((LivingEntity)e.getFirst(), 200);
                        StandHandler.applyCooldownAttack((LivingEntity)e.getFirst(), 200);
                    }
                    AABB hitbox = ((Entity)e.getFirst()).getBoundingBox();
                    for (double x = hitbox.minX; x < hitbox.maxX; x += density) {
                        for (double y = hitbox.minY; y < hitbox.maxY; y += density) {
                            for (double z = hitbox.minZ; z < hitbox.maxZ; z += density) {
                                double finalX = x;
                                double finalY = y;
                                double finalZ = z;
                                source.level().players().forEach(player -> {
                                    ((ServerLevel)((Entity)e.getFirst()).level()).sendParticles((ServerPlayer)player, (ParticleOptions)ParticleTypes.EXPLOSION, true, finalX, finalY, finalZ, 1, 0.0, 0.0, 0.0, 0.0);
                                    ((ServerLevel)((Entity)e.getFirst()).level()).sendParticles((ServerPlayer)player, (ParticleOptions)ParticleTypes.FLAME, true, finalX, finalY, finalZ, 1, 0.0, 0.0, 0.0, 0.0);
                                });
                            }
                        }
                    }
                }
            });
        }
    }

    public static void getSkills(LivingEntity entity) {
        ArrayList skills = (ArrayList)entity.getData(Attachments.SKILLS);
        skills.add(new Skill("Manifest / Vanish", 0, false, source -> {
            Optional<StandEntity> stand = StandHandler.getStand(source);
            if (stand.isPresent()) {
                stand.get().discard();
                source.level().playSound(null, source.blockPosition(), ModSounds.KQ_OFF.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                ((ServerPlayer)source).connection.send((Packet)new ClientboundSetPassengersPacket((Entity)((ServerPlayer)source)));
                StandHandler.syncData(source);
                return;
            }
            KillerQueen newStand = new KillerQueen(ModEntities.KILLER_QUEEN.get(), source.level());
            newStand.startRiding((Entity)source);
            newStand.moveTo(source.position());
            source.level().addFreshEntity((Entity)newStand);
            source.level().playSound(null, source.blockPosition(), ModSounds.KQ_SUMMON.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            if (source instanceof ServerPlayer) {
                ServerPlayer p = (ServerPlayer)source;
                p.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)((ServerPlayer)source)));
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(1, task -> PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new SyncStandData((Integer)source.getData(Attachments.STAND_ID), (Integer)source.getData(Attachments.COOLDOWN_TIME_ATTACK), (Integer)source.getData(Attachments.COOLDOWN_TIME_ABILITY), (Integer)source.getData(Attachments.STAMINA), (Integer)source.getData(Attachments.SKILL), (Integer)source.getData(Attachments.MAX_STAMINA)), (CustomPacketPayload[])new CustomPacketPayload[0])));
            }
        }).setIcon(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/ui/summon.png"))));
        Optional<StandEntity> s = StandHandler.getStand(entity);
        if (s.isPresent()) {
            StandEntity passenger = s.get();
            skills.add(new Skill("Plant", 0, false, source -> {
                source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> FIRST BOMB PLANT!"))));
                if (passenger instanceof KillerQueen) {
                    KillerQueen stand = (KillerQueen)passenger;
                    try {
                        stand.plant();
                        Mots.serverTaskExecutioner.tasks.add(new Queue.Task(19, task -> StandHandler.executeScalableMeleeAttack(source, 0, new Vec3(4.0, 0.25, 4.0), Optional.empty(), Optional.empty(), true).forEach(possibleTarget -> {
                            if (!(possibleTarget instanceof StandEntity)) {
                                source.setData(Attachments.BOMB_UUID, (Object)possibleTarget.getUUID());
                                source.setData(Attachments.BOMB_PRESENT, (Object)true);
                                return;
                            }
                            if (possibleTarget instanceof StandEntity) {
                                StandEntity standEntity = (StandEntity)((Object)((Object)((Object)possibleTarget)));
                                try {
                                    source.setData(Attachments.BOMB_UUID, (Object)standEntity.getUser().getUUID());
                                    source.setData(Attachments.BOMB_PRESENT, (Object)true);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        })));
                        StandHandler.applyCooldownAttack(source, 40);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, ModSounds.KQ_TRIPLE_EXPLOSION.get()));
            skills.add(new Skill("Impale ignition", 4, false, source -> {
                source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> You are starting to annoy me."))));
                if (passenger instanceof KillerQueen) {
                    KillerQueen stand = (KillerQueen)passenger;
                    try {
                        stand.plant();
                        Mots.serverTaskExecutioner.tasks.add(new Queue.Task(19, task -> {
                            List<Entity> targets = StandHandler.executeScalableMeleeAttack(source, 4, new Vec3(4.0, 0.25, 4.0), Optional.empty(), Optional.empty(), true);
                            Mots.serverTaskExecutioner2.tasks.add(new Queue.Task(8, t -> StandHandler.knockBackEntityList(source, targets)));
                            targets.forEach(target -> {
                                for (int i = 0; i < 7; ++i) {
                                    Mots.serverTaskExecutioner2.tasks.add(new Queue.Task(i, t -> {
                                        source.level().players().forEach(player -> ((ServerLevel)source.level()).sendParticles((ServerPlayer)player, (ParticleOptions)ModParticleTypes.BLOOD_PARTICLE.get(), true, target.getX(), target.getEyeY() - 1.0, target.getZ(), 200, 0.3, 0.3, 0.3, 0.2));
                                        Vec3 vec = source.getViewVector(1.0f);
                                        target.moveTo(source.position().add(new Vec3(vec.x, 0.5, vec.z)));
                                    }));
                                }
                                if (!(target instanceof StandEntity)) {
                                    source.setData(Attachments.BOMB_UUID, (Object)target.getUUID());
                                    source.setData(Attachments.BOMB_PRESENT, (Object)true);
                                    return;
                                }
                                if (target instanceof StandEntity) {
                                    StandEntity standEntity = (StandEntity)((Object)((Object)((Object)target)));
                                    try {
                                        source.setData(Attachments.BOMB_UUID, (Object)standEntity.getUser().getUUID());
                                        source.setData(Attachments.BOMB_PRESENT, (Object)true);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            });
                        }));
                        StandHandler.applyCooldownAttack(source, 40);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, ModSounds.KQ_TRIPLE_EXPLOSION.get()));
            skills.add(new Skill("Explosion barrage", 4, false, source -> {
                source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> This is killer queen power."))));
                if (passenger instanceof KillerQueen) {
                    KillerQueen stand = (KillerQueen)passenger;
                    stand.plant();
                    StandHandler.applyCooldownAttack(source, 120);
                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(15, task -> {
                        source.setInvulnerable(true);
                        StandHandler.executeScalableMeleeAttack(source, 2, new Vec3(2.0, 0.5, 2.0), Optional.of(true), Optional.of(1), true).forEach(hit -> {
                            if (hit.is((Entity)stand)) {
                                return;
                            }
                            hit.setInvulnerable(true);
                            Mots.serverTaskExecutioner2.tasks.add(new Queue.Task(20, t -> hit.level().explode(null, hit.getX(), hit.getY() - 1.0, hit.getZ(), 4.0f, Level.ExplosionInteraction.NONE)));
                            Mots.serverTaskExecutioner2.tasks.add(new Queue.Task(30, t -> hit.level().explode(null, hit.getX() - 1.0, hit.getY(), hit.getZ(), 4.0f, Level.ExplosionInteraction.NONE)));
                            Mots.serverTaskExecutioner2.tasks.add(new Queue.Task(45, t -> {
                                hit.setInvulnerable(false);
                                if (!((Boolean)source.getData(Attachments.BREAK_BLOCKS)).booleanValue()) {
                                    hit.level().explode(null, hit.getX(), hit.getY() + 0.5, hit.getZ(), 4.0f, Level.ExplosionInteraction.NONE);
                                } else {
                                    hit.level().explode(null, hit.getX(), hit.getY() + 0.5, hit.getZ(), 4.0f, Level.ExplosionInteraction.MOB);
                                }
                                if (hit instanceof LivingEntity) {
                                    LivingEntity living = (LivingEntity)hit;
                                    living.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 40, 0));
                                }
                            }));
                            if (!(hit instanceof StandEntity)) {
                                source.setData(Attachments.BOMB_UUID, (Object)hit.getUUID());
                                source.setData(Attachments.BOMB_PRESENT, (Object)true);
                            }
                        });
                    }));
                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(25, task -> stand.explode()));
                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(70, task -> source.setInvulnerable(false)));
                }
            }, ModSounds.KQ_TRIPLE_EXPLOSION.get()));
            skills.add(new Skill("Ignite", 0, true, source -> {
                block8: {
                    block7: {
                        block6: {
                            if (!(passenger instanceof KillerQueen)) break block6;
                            KillerQueen stand = (KillerQueen)passenger;
                            break block7;
                        }
                        if (!(passenger instanceof SheerHearthAttack)) break block8;
                    }
                    try {
                        if (passenger instanceof KillerQueen) {
                            KillerQueen stand = (KillerQueen)passenger;
                            stand.explode();
                        }
                        source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> KILLER QUEEN, FIRST ABILITY.... SWITCH ON!"))));
                        Mots.serverTaskExecutioner.tasks.add(new Queue.Task(21, task -> {
                            source.getServer().getPlayerList().getPlayers().forEach(player -> {
                                if (source.equals(player)) {
                                    return;
                                }
                                player.getInventory().items.forEach(itemStack -> {
                                    if (itemStack.has(Components.KILLER_QUEEN_ITEM_BOMB_COMPONENT) && ((KillerQueenItemBombRecord)itemStack.get(Components.KILLER_QUEEN_ITEM_BOMB_COMPONENT)).ownerUUID().equals(source.getUUID().toString())) {
                                        source.setData(Attachments.BOMB_PRESENT.get(), (Object)true);
                                        source.setData(Attachments.BOMB_UUID.get(), (Object)player.getUUID());
                                        itemStack.remove(Components.KILLER_QUEEN_ITEM_BOMB_COMPONENT);
                                    }
                                });
                            });
                            try {
                                source.getServer().getAllLevels().forEach(level -> level.getAllEntities().forEach(instance -> {
                                    if (((Boolean)source.getData(Attachments.BOMB_PRESENT)).booleanValue() && instance.getUUID().equals(source.getData(Attachments.BOMB_UUID))) {
                                        if (instance instanceof SheerHearthAttack) {
                                            SheerHearthAttack sha = (SheerHearthAttack)((Object)((Object)((Object)((Object)instance))));
                                            source.level().playSound(null, sha.blockPosition(), ModSounds.SHA_EXPLODE.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                                            sha.level().explode((Entity)sha, sha.getX(), sha.getY(), sha.getZ(), 3.0f, Level.ExplosionInteraction.NONE);
                                        } else {
                                            source.setData(Attachments.BOMB_PRESENT, (Object)false);
                                            source.level().playSound((Player)null, source.position().x, source.position().y, source.position().z, SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
                                            double density = 0.5;
                                            source.setData(Attachments.STAND_SPECIAL_POTENCY, (Object)((Double)source.getData(Attachments.STAND_SPECIAL_POTENCY) + 0.01));
                                            double resistance = (Double)instance.getData(Attachments.DAMAGE_RESISTANCE.get()) / 100.0;
                                            double scalingFactor = 0.1658;
                                            float damage = (float)((double)(3.0f * StandHandler.getStandPowerModifier(source)) * scalingFactor * (1.0 - resistance));
                                            instance.hurt(new DamageSource(instance.damageSources().generic().typeHolder()), damage);
                                            if (instance instanceof LivingEntity) {
                                                StandHandler.applyCooldownAttack((LivingEntity)instance, 200);
                                                StandHandler.applyCooldownAttack((LivingEntity)instance, 200);
                                            }
                                            AABB hitbox = instance.getBoundingBox();
                                            for (double x = hitbox.minX; x < hitbox.maxX; x += density) {
                                                for (double y = hitbox.minY; y < hitbox.maxY; y += density) {
                                                    for (double z = hitbox.minZ; z < hitbox.maxZ; z += density) {
                                                        double finalX = x;
                                                        double finalY = y;
                                                        double finalZ = z;
                                                        source.level().players().forEach(player -> {
                                                            ((ServerLevel)instance.level()).sendParticles((ServerPlayer)player, (ParticleOptions)ParticleTypes.EXPLOSION, true, finalX, finalY, finalZ, 1, 0.0, 0.0, 0.0, 0.0);
                                                            ((ServerLevel)instance.level()).sendParticles((ServerPlayer)player, (ParticleOptions)ParticleTypes.FLAME, true, finalX, finalY, finalZ, 1, 0.0, 0.0, 0.0, 0.0);
                                                        });
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }));
                        StandHandler.applyCooldownAbility(source, 40);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, ModSounds.KQ_SWITCH_ON.get()));
            skills.add(new Skill("Sheer Hearth Atrack", 3, true, source -> {
                source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> SECOND BOBM, SHEER HEARTH ATTACK!"))));
                if (passenger instanceof KillerQueen) {
                    KillerQueen stand = (KillerQueen)passenger;
                    try {
                        stand.plantSha();
                        Mots.serverTaskExecutioner.tasks.add(new Queue.Task(20, task -> {
                            if (source instanceof ServerPlayer) {
                                ServerPlayer p = (ServerPlayer)source;
                                stand.discard();
                                ((ServerPlayer)source).connection.send((Packet)new ClientboundSetPassengersPacket((Entity)((ServerPlayer)source)));
                                StandHandler.syncData(source);
                                SheerHearthAttack sha = new SheerHearthAttack(ModEntities.SHEER_HEARTH_ATTACK.get(), source.level());
                                sha.teleportTo(source.position().x, source.position().y, source.position().z);
                                sha.startRiding((Entity)source);
                                source.level().addFreshEntity((Entity)sha);
                                p.connection.send((Packet)new ClientboundSetCameraPacket((Entity)sha));
                                p.sendSystemMessage((Component)Component.literal((String)"Use the 'Ignite' skill to ignite sheer hearth attack"));
                                sha.switchPilot();
                                source.setData(Attachments.BOMB_PRESENT, (Object)true);
                                source.setData(Attachments.BOMB_UUID, (Object)sha.getUUID());
                            }
                        }));
                        StandHandler.applyCooldownAbility(source, 200);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }));
            skills.add(new Skill("Bite the dust", 6, true, source -> {
                source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> KILLER QUEEN, THIRD BOMB BITE THE DUST!"))));
                StandHandler.applyCooldownAbility(source, 6000);
                if (passenger instanceof KillerQueen) {
                    KillerQueen stand = (KillerQueen)passenger;
                    if (!source.hasData(Attachments.BITE_THE_DUST)) {
                        source.setData(Attachments.BITE_THE_DUST, (Object)false);
                    }
                    if (!((Boolean)source.getData(Attachments.BITE_THE_DUST)).booleanValue()) {
                        stand.plant();
                        Mots.serverTaskExecutioner.tasks.add(new Queue.Task(19, task -> {
                            AtomicReference e = new AtomicReference();
                            StandHandler.executeScalableMeleeAttack(source, 0, new Vec3(4.0, 0.25, 4.0), Optional.empty(), Optional.empty(), true).forEach(possibleTarget -> {
                                if (possibleTarget instanceof StandEntity) {
                                    return;
                                }
                                if (((Boolean)source.getData(Attachments.BITE_THE_DUST)).booleanValue()) {
                                    return;
                                }
                                source.setData(Attachments.BOMB_UUID, (Object)possibleTarget.getUUID());
                                source.setData(Attachments.BITE_THE_DUST.get(), (Object)true);
                                source.level().playSound(null, source.blockPosition(), ModSounds.KQ_BTD_1.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                                e.set(possibleTarget);
                            });
                            if (((Boolean)source.getData(Attachments.BITE_THE_DUST)).booleanValue()) {
                                ArrayList entitiesList = new ArrayList();
                                ((Entity)e.get()).level().getEntities(null, ((Entity)e.get()).getBoundingBox().inflate(100.0)).forEach(btd -> entitiesList.add(new Pair(btd, (Object)btd.position())));
                                source.setData(Attachments.BITE_THE_DUST_ENTITIES.get(), entitiesList);
                            }
                        }));
                    } else if (source.hasData(Attachments.BITE_THE_DUST_ENTITIES.get())) {
                        source.setData(Attachments.BITE_THE_DUST, (Object)false);
                        ArrayList entities = (ArrayList)source.getData(Attachments.BITE_THE_DUST_ENTITIES.get());
                        entities.forEach(e -> {
                            ((Entity)e.getFirst()).teleportTo(((Vec3)e.getSecond()).x, ((Vec3)e.getSecond()).y, ((Vec3)e.getSecond()).z);
                            if (((Entity)e.getFirst()).is((Entity)source)) {
                                source.heal(source.getMaxHealth());
                                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(10, t -> source.level().playSound(null, source.blockPosition(), ModSounds.KQ_BTD_2.get(), SoundSource.AMBIENT, 1.0f, 1.0f)));
                            } else {
                                Object patt0$temp = e.getFirst();
                                if (patt0$temp instanceof Mob) {
                                    Mob living = (Mob)patt0$temp;
                                    living.setNoAi(true);
                                    living.getBrain().clearMemories();
                                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(1, t -> living.setNoAi(false)));
                                }
                                double density = 0.5;
                                float damage = 3.0f * StandHandler.getStandPowerModifier((LivingEntity)((ServerPlayer)source));
                                ((Entity)e.getFirst()).hurt(new DamageSource(((Entity)e.getFirst()).damageSources().generic().typeHolder()), damage);
                                if (e.getFirst() instanceof LivingEntity) {
                                    StandHandler.applyCooldownAttack((LivingEntity)e.getFirst(), 200);
                                    StandHandler.applyCooldownAttack((LivingEntity)e.getFirst(), 200);
                                }
                                AABB hitbox = ((Entity)e.getFirst()).getBoundingBox();
                                for (double x = hitbox.minX; x < hitbox.maxX; x += density) {
                                    for (double y = hitbox.minY; y < hitbox.maxY; y += density) {
                                        for (double z = hitbox.minZ; z < hitbox.maxZ; z += density) {
                                            double finalX = x;
                                            double finalY = y;
                                            double finalZ = z;
                                            source.level().players().forEach(player -> {
                                                ((ServerLevel)((Entity)e.getFirst()).level()).sendParticles((ServerPlayer)player, (ParticleOptions)ParticleTypes.EXPLOSION, true, finalX, finalY, finalZ, 1, 0.0, 0.0, 0.0, 0.0);
                                                ((ServerLevel)((Entity)e.getFirst()).level()).sendParticles((ServerPlayer)player, (ParticleOptions)ParticleTypes.FLAME, true, finalX, finalY, finalZ, 1, 0.0, 0.0, 0.0, 0.0);
                                            });
                                        }
                                    }
                                }
                            }
                        });
                    }
                }
            }));
            return;
        }
        skills.add(new Skill("First bomb: item bomb", 3, true, source -> source.getItemInHand(InteractionHand.MAIN_HAND).set(Components.KILLER_QUEEN_ITEM_BOMB_COMPONENT, (Object)new KillerQueenItemBombRecord(source.getUUID().toString()))));
    }
}

