/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.MotsApi.Skills.KingCrimson;

import java.util.ArrayList;
import java.util.Optional;
import net.hrodebert.mots.ModEntities.ModEntities;
import net.hrodebert.mots.ModEntities.custom.KingCrimson;
import net.hrodebert.mots.ModEntities.custom.StandEntity;
import net.hrodebert.mots.ModParticles.ModParticleTypes;
import net.hrodebert.mots.ModSounds.ModSounds;
import net.hrodebert.mots.Mots;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.Events.OnStandTimedAbilityEvent;
import net.hrodebert.mots.MotsApi.Skill;
import net.hrodebert.mots.MotsApi.Skills.KingCrimson.KingCrimsonAttachments;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.hrodebert.mots.MotsApi.StandTimeHandler;
import net.hrodebert.mots.PayLoads.SyncStandData;
import net.hrodebert.mots.ServerQueue.Queue;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.bossevents.CustomBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;

public class KingCrimsonSkills {
    public void getSkills(LivingEntity entity) {
        StandEntity standEntity;
        ArrayList skills = (ArrayList)entity.getData(Attachments.SKILLS);
        skills.add(new Skill("Manifest / Vanish", 0, false, source -> {
            Optional<StandEntity> stand = StandHandler.getStand(source);
            if (stand.isPresent()) {
                stand.get().discard();
                ((ServerPlayer)source).connection.send((Packet)new ClientboundSetPassengersPacket((Entity)((ServerPlayer)source)));
                StandHandler.syncData(source);
                source.level().playSound(null, source.blockPosition(), ModSounds.KC_OFF.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                return;
            }
            KingCrimson newStand = new KingCrimson(ModEntities.KING_CRIMSON.get(), source.level());
            newStand.startRiding((Entity)source);
            newStand.moveTo(source.position());
            source.level().addFreshEntity((Entity)newStand);
            source.level().playSound(null, source.blockPosition(), ModSounds.KC_SUMMON.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            if (source instanceof ServerPlayer) {
                ServerPlayer p = (ServerPlayer)source;
                p.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)p));
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(1, task -> PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new SyncStandData((Integer)source.getData(Attachments.STAND_ID), (Integer)source.getData(Attachments.COOLDOWN_TIME_ATTACK), (Integer)source.getData(Attachments.COOLDOWN_TIME_ABILITY), (Integer)source.getData(Attachments.STAMINA), (Integer)source.getData(Attachments.SKILL), (Integer)source.getData(Attachments.MAX_STAMINA)), (CustomPacketPayload[])new CustomPacketPayload[0])));
            }
        }).setIcon(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/ui/summon.png"))));
        Optional<StandEntity> s = StandHandler.getStand(entity);
        if (s.isPresent() && (standEntity = s.get()) instanceof KingCrimson) {
            KingCrimson passenger = (KingCrimson)standEntity;
            skills.add(new Skill("Chop", 2, false, source -> {
                source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> Take this!"))));
                passenger.chop();
                StandHandler.applyCooldownAttack(source, 40);
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(15, task -> StandHandler.executeScalableMeleeAttack(source, 2, new Vec3(3.0, 0.25, 3.0), Optional.of(true), Optional.of(2), true).forEach(target -> source.level().players().forEach(player -> ((ServerLevel)source.level()).sendParticles((ServerPlayer)player, (ParticleOptions)ModParticleTypes.BLOOD_PARTICLE.get(), true, target.getX(), target.getEyeY() - 1.0, target.getZ(), 200, 0.3, 0.3, 0.3, 0.2)))));
            }, ModSounds.KC_CHOP.get()));
            skills.add(new Skill("Impale", 4, false, source -> {
                try {
                    source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> DIE!!!!"))));
                    passenger.impale();
                    StandHandler.applyCooldownAttack(source, 60);
                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(12, task -> StandHandler.executeScalableMeleeAttack(source, 6, new Vec3(4.0, 3.0, 4.0), Optional.of(true), Optional.of(4), false).forEach(hit -> {
                        for (int i = 0; i < 20; ++i) {
                            Mots.serverTaskExecutioner2.tasks.add(new Queue.Task(i, taskNew -> {
                                if (!hit.equals(s.get())) {
                                    Vec3 vec = ((StandEntity)((Object)((Object)((Object)((Object)((Object)s.get())))))).getViewVector(1.0f);
                                    hit.moveTo(((StandEntity)((Object)((Object)((Object)((Object)((Object)s.get())))))).position().add(new Vec3(vec.x, 0.5, vec.z)));
                                    source.level().players().forEach(player -> ((ServerLevel)source.level()).sendParticles((ServerPlayer)player, (ParticleOptions)ModParticleTypes.BLOOD_PARTICLE.get(), true, hit.getX(), hit.getEyeY() - 1.0, hit.getZ(), 200, 0.3, 0.3, 0.3, 0.2));
                                }
                            }));
                        }
                    })));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, ModSounds.KC_IMPALE.get()));
            if (!((Boolean)entity.getData(KingCrimsonAttachments.TIME_ERASE)).booleanValue()) {
                skills.add(new Skill("Time Erase", 4, true, source -> {
                    try {
                        passenger.timeErasure();
                        source.setData(Attachments.STAND_SPECIAL_POTENCY, (Object)((Double)source.getData(Attachments.STAND_SPECIAL_POTENCY) + 0.1));
                        source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> KING CRIMSON"))));
                        StandTimeHandler.timeErase(source, Optional.empty(), Optional.empty());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }, ModSounds.TIME_ERASE.get()));
            } else {
                skills.add(new Skill("Time resume", 0, true, source -> {
                    try {
                        passenger.timeErasure();
                        source.level().tickRateManager().setTickRate(20.0f);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }, ModSounds.TIME_ERASE.get()));
            }
            skills.add(new Skill("Time skip", 3, true, source -> {
                source.setData(Attachments.STAND_SPECIAL_POTENCY, (Object)((Double)source.getData(Attachments.STAND_SPECIAL_POTENCY) + 0.1));
                StandTimeHandler.timeErase(source, Optional.of(40), Optional.of(true));
                StandHandler.registerSkills(source);
                StandHandler.syncData(source);
                source.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 60, 255, false, false));
                source.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 60, 1, false, false));
                source.addEffect(new MobEffectInstance(MobEffects.JUMP, 60, 1, false, false));
                StandHandler.applyCooldownAttack(source, 40);
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(41, t -> {
                    source.setData(Attachments.COOLDOWN_TIME_ABILITY, (Object)0);
                    StandHandler.applyCooldownAbility(source, 140);
                }));
            }).setIcon(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/ui/time_resume.png"))));
            skills.add(new Skill("Epitaph", 2, true, source -> {
                try {
                    StandHandler.applyCooldownAbility(source, 400);
                    source.setData(Attachments.STAND_SPECIAL_POTENCY, (Object)((Double)source.getData(Attachments.STAND_SPECIAL_POTENCY) + 0.1));
                    source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> EPITAPH!!!"))));
                    OnStandTimedAbilityEvent.Pre eventPre = new OnStandTimedAbilityEvent.Pre((int)((StandHandler.getStandSpecial((LivingEntity)((ServerPlayer)source)) * 20.0 + 20.0 + 30.0) / 2.0), new EpitaphAbility());
                    eventPre.source = source;
                    NeoForge.EVENT_BUS.post((Event)eventPre);
                    if (eventPre.isCanceled()) {
                        return;
                    }
                    source.setData(KingCrimsonAttachments.EPITAPH, (Object)eventPre.getDuration());
                    if (source instanceof ServerPlayer) {
                        ServerPlayer p = (ServerPlayer)source;
                        CustomBossEvent bar = new CustomBossEvent(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"epitaph"), (Component)Component.literal((String)"Epitaph"));
                        bar.setColor(BossEvent.BossBarColor.PINK);
                        StandHandler.scalingBar(bar, p, eventPre.getDuration(), 0, Optional.of(true));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, ModSounds.KC_EPITAPH.get()));
            return;
        }
    }

    public static class EpitaphAbility
    extends OnStandTimedAbilityEvent.AbilityType {
        @Override
        public ResourceLocation getAbilityType() {
            return ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"time_erase");
        }
    }
}

