/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.MotsApi.Skills.MadeInHeavenSkills;

import java.util.ArrayList;
import java.util.Optional;
import net.hrodebert.mots.ModEntities.ModEntities;
import net.hrodebert.mots.ModEntities.custom.Knife;
import net.hrodebert.mots.ModEntities.custom.MadeInHeaven;
import net.hrodebert.mots.ModEntities.custom.StandEntity;
import net.hrodebert.mots.ModItems.ModItems;
import net.hrodebert.mots.ModParticles.ModParticleTypes;
import net.hrodebert.mots.ModSounds.ModSounds;
import net.hrodebert.mots.Mots;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.Skill;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.hrodebert.mots.PayLoads.SyncStandData;
import net.hrodebert.mots.ServerQueue.Queue;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class MadeInHeavenSkills {
    public static void getSkills(LivingEntity entity) {
        StandEntity passenger;
        ArrayList skills = (ArrayList)entity.getData(Attachments.SKILLS);
        skills.add(new Skill("Manifest / Vanish", 0, false, source -> {
            Optional<StandEntity> s = StandHandler.getStand(entity);
            if (s.isPresent()) {
                StandEntity stand = s.get();
                stand.discard();
                ((ServerPlayer)source).connection.send((Packet)new ClientboundSetPassengersPacket((Entity)((ServerPlayer)source)));
                StandHandler.syncData(source);
                source.level().playSound(null, source.blockPosition(), ModSounds.WS_OFF.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                return;
            }
            MadeInHeaven stand = new MadeInHeaven(ModEntities.MADE_IN_HEAVEN.get(), source.level());
            stand.startRiding((Entity)source);
            stand.moveTo(source.position());
            source.level().addFreshEntity((Entity)stand);
            source.level().playSound(null, source.blockPosition(), ModSounds.MIH_SUMMON.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            if (source instanceof ServerPlayer) {
                ServerPlayer p = (ServerPlayer)source;
                p.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)((ServerPlayer)source)));
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(1, task -> PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new SyncStandData((Integer)source.getData(Attachments.STAND_ID), (Integer)source.getData(Attachments.COOLDOWN_TIME_ATTACK), (Integer)source.getData(Attachments.COOLDOWN_TIME_ABILITY), (Integer)source.getData(Attachments.STAMINA), (Integer)source.getData(Attachments.SKILL), (Integer)source.getData(Attachments.MAX_STAMINA)), (CustomPacketPayload[])new CustomPacketPayload[0])));
            }
        }).setIcon(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/ui/summon.png"))));
        Optional<StandEntity> s = StandHandler.getStand(entity);
        if (s.isPresent() && (passenger = s.get()) instanceof MadeInHeaven) {
            MadeInHeaven m = (MadeInHeaven)passenger;
            int mihPrice = Math.min((m.getAccel() - 1) / 4, 10);
            if (m.getAccel() > 0) {
                skills.add(new Skill("Throat slash", 3, false, source -> {
                    if (passenger instanceof MadeInHeaven) {
                        MadeInHeaven stand = (MadeInHeaven)passenger;
                        Entity e = StandHandler.getEntityUserIsLookingAt(source, 30);
                        if (e != null) {
                            source.setInvulnerable(true);
                            for (int i = 0; i < 6 / Math.max(stand.getAccel() / 10, 1) + 1; ++i) {
                                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(i, task -> {
                                    source.teleportTo(e.position().x - e.getLookAngle().z, e.getEyePosition((float)1.0f).y + 0.2, e.position().z - e.getLookAngle().z);
                                    source.lookAt(EntityAnchorArgument.Anchor.EYES, e.getEyePosition());
                                }));
                            }
                            stand.chop();
                            StandHandler.applyCooldownAttack(source, 40);
                            Mots.serverTaskExecutioner.tasks.add(new Queue.Task(7 / Math.max(stand.getAccel() / 10, 1), task -> {
                                source.setInvulnerable(false);
                                StandHandler.executeScalableMeleeAttack((LivingEntity)((ServerPlayer)source), 4, new Vec3(4.0, 2.0, 4.0), Optional.of(true), Optional.of(3), false).forEach(hit -> source.level().players().forEach(player -> ((ServerLevel)source.level()).sendParticles((ServerPlayer)player, (ParticleOptions)ModParticleTypes.BLOOD_PARTICLE.get(), true, hit.getX(), hit.getEyeY() - 1.0, hit.getZ(), 200, 0.3, 0.3, 0.3, 0.2)));
                            }));
                        }
                    }
                }, ModSounds.MIH_THROAT_SLASH.get()));
            } else {
                skills.add(new Skill("Chop", 1 + mihPrice, false, source -> {
                    if (passenger instanceof MadeInHeaven) {
                        MadeInHeaven stand = (MadeInHeaven)passenger;
                        try {
                            stand.chop();
                            StandHandler.applyCooldownAttack(source, 40);
                            Mots.serverTaskExecutioner.tasks.add(new Queue.Task(6 / Math.max(stand.getAccel() / 10, 1), task -> StandHandler.executeScalableMeleeAttack(source, 4, new Vec3(4.0, 0.25, 4.0), Optional.of(true), Optional.of(3), true).forEach(hit -> source.level().players().forEach(player -> ((ServerLevel)source.level()).sendParticles((ServerPlayer)player, (ParticleOptions)ModParticleTypes.BLOOD_PARTICLE.get(), true, hit.getX(), hit.getEyeY() - 1.0, hit.getZ(), 200, 0.3, 0.3, 0.3, 0.2)))));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }, ModSounds.MIH_CHOP.get()));
            }
            if (m.getAccel() > 5) {
                skills.add(new Skill("Heavenly smite", 3 + mihPrice, false, source -> {
                    Entity e = StandHandler.getEntityUserIsLookingAt(source, 30);
                    if (e != null) {
                        source.setInvulnerable(true);
                        for (int i = 0; i < 2; ++i) {
                            int pointNum = 360 / (mihPrice + 4);
                            double slice = Math.PI * 2 / (double)pointNum;
                            Mots.serverTaskExecutioner2.tasks.add(new Queue.Task(i * 360 / (mihPrice + 4), t -> {
                                for (int j = 0; j < pointNum; ++j) {
                                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(j, task -> {
                                        if (!e.isAlive()) {
                                            return;
                                        }
                                        double angle = slice * (double)task.intValue();
                                        double range = 3.0;
                                        source.teleportTo((double)((int)(e.position().x + range * Math.cos(angle))), (double)((int)e.position().y), (double)((int)(e.position().z + range * Math.sin(angle))));
                                        source.lookAt(EntityAnchorArgument.Anchor.EYES, e.getEyePosition());
                                    }));
                                }
                            }));
                        }
                        Mots.serverTaskExecutioner.tasks.add(new Queue.Task(720 / (mihPrice + 4), t -> {
                            source.setInvulnerable(false);
                            m.impale();
                        }));
                        Mots.serverTaskExecutioner.tasks.add(new Queue.Task(7 / Math.max(m.getAccel() / 10, 1) + 720 / (mihPrice + 4), task -> {
                            source.teleportTo(e.position().x - e.getLookAngle().z, e.getEyePosition((float)1.0f).y + 0.2, e.position().z - e.getLookAngle().z);
                            source.lookAt(EntityAnchorArgument.Anchor.EYES, e.position());
                            StandHandler.executeScalableMeleeAttack(source, 4, new Vec3(4.0, 2.0, 4.0), Optional.of(true), Optional.of(3), false).forEach(hit -> Mots.serverTaskExecutioner2.tasks.add(new Queue.Task(1, taskNew -> {
                                if (!hit.equals((Object)m)) {
                                    Vec3 vec = m.getViewVector(1.0f);
                                    hit.moveTo(m.position().add(new Vec3(vec.x, 0.5, vec.z)));
                                    source.level().players().forEach(player -> ((ServerLevel)source.level()).sendParticles((ServerPlayer)player, (ParticleOptions)ModParticleTypes.BLOOD_PARTICLE.get(), true, hit.getX(), hit.getEyeY() - 1.0, hit.getZ(), 200, 0.3, 0.3, 0.3, 0.2));
                                }
                            })));
                        }));
                    }
                }, ModSounds.MIH_JUDGMENT.get()));
            } else {
                skills.add(new Skill("Impale", 4 + mihPrice, false, source -> {
                    if (passenger instanceof MadeInHeaven) {
                        MadeInHeaven stand = (MadeInHeaven)passenger;
                        try {
                            stand.impale();
                            StandHandler.applyCooldownAttack(source, 40);
                            Mots.serverTaskExecutioner.tasks.add(new Queue.Task(7 / Math.max(stand.getAccel() / 10, 1), task -> StandHandler.executeScalableMeleeAttack(source, 4, new Vec3(4.0, 0.25, 4.0), Optional.of(true), Optional.of(3), true).forEach(hit -> Mots.serverTaskExecutioner2.tasks.add(new Queue.Task(1, taskNew -> {
                                if (!hit.equals((Object)m)) {
                                    Vec3 vec = m.getViewVector(1.0f);
                                    hit.moveTo(m.position().add(new Vec3(vec.x, 0.5, vec.z)));
                                    source.level().players().forEach(player -> ((ServerLevel)source.level()).sendParticles((ServerPlayer)player, (ParticleOptions)ModParticleTypes.BLOOD_PARTICLE.get(), true, hit.getX(), hit.getEyeY() - 1.0, hit.getZ(), 200, 0.3, 0.3, 0.3, 0.2));
                                }
                            })))));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }, ModSounds.MIH_IMPALE.get()));
            }
            skills.add(new Skill("Stand jump", mihPrice, false, source -> {
                if (passenger instanceof MadeInHeaven) {
                    MadeInHeaven stand = (MadeInHeaven)passenger;
                    try {
                        StandHandler.applyCooldownAttack(source, 80);
                        source.setDeltaMovement(source.getViewVector(1.0f).multiply(-1.5, -1.5, -1.5));
                        source.hurtMarked = true;
                        source.setInvulnerable(true);
                        Mots.serverTaskExecutioner.tasks.add(new Queue.Task(5, task -> {
                            if (source.getItemInHand(InteractionHand.MAIN_HAND).is((Item)ModItems.KNIFE.get()) && source instanceof Player) {
                                source.getItemInHand(InteractionHand.MAIN_HAND).use(source.level(), (Player)source, InteractionHand.MAIN_HAND);
                                for (double i = 0.0; i < 1.0; i += 0.25) {
                                    Knife knife = new Knife(ModEntities.KNIFE.get(), source.level());
                                    knife.moveTo(source.getEyePosition().add(new Vec3(i, i, i)));
                                    knife.setOwner((Entity)source);
                                    knife.setDeltaMovement(source.getViewVector(1.0f).scale(2.0));
                                    source.level().addFreshEntity((Entity)knife);
                                }
                            }
                        }));
                        Mots.serverTaskExecutioner.tasks.add(new Queue.Task(40, task -> source.setInvulnerable(false)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, ModSounds.MIH_STAND_JUMP.get()));
            if (!m.isAccelerating()) {
                skills.add(new Skill("Time: Acceleration", 20, true, source -> {
                    if (passenger instanceof MadeInHeaven) {
                        MadeInHeaven stand = (MadeInHeaven)passenger;
                        try {
                            stand.startAcceleration();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }, ModSounds.MIH_ACCEL.get()).setIcon(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/ui/time_speed_up.png"))));
            } else {
                skills.add(new Skill("Time: Deceleration", 20, true, source -> {
                    if (passenger instanceof MadeInHeaven) {
                        MadeInHeaven stand = (MadeInHeaven)passenger;
                        try {
                            stand.stopAcceleration();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }, ModSounds.MIH_ACCEL.get()).setIcon(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/ui/time_deceleration.png"))));
                skills.add(new Skill("Time: Dilatation", 0, true, source -> {
                    if (passenger instanceof MadeInHeaven) {
                        MadeInHeaven stand = (MadeInHeaven)passenger;
                        if (!source.hasData(Attachments.SPEED)) {
                            source.setData(Attachments.SPEED, (Object)Float.valueOf(100.0f));
                        }
                        if (((Float)source.getData(Attachments.SPEED)).floatValue() == 100.0f) {
                            int acceleration = stand.getAccel();
                            acceleration = Math.min(acceleration, 100);
                            int accelerationStatus = acceleration / 2;
                            float finalSpeed = 100 - accelerationStatus;
                            int a = stand.getAccel();
                            stand.setAccel(0);
                            boolean stop = false;
                            if (stand.isAccelerating()) {
                                stand.stopAcceleration();
                                stop = true;
                            }
                            Iterable entities = ((ServerLevel)source.level()).getEntities().getAll();
                            for (Entity e : entities) {
                                StandEntity patt0$temp;
                                LivingEntity living;
                                Optional<StandEntity> entityStand;
                                if (e instanceof LivingEntity && (entityStand = StandHandler.getStand(living = (LivingEntity)e)).isPresent() && (patt0$temp = entityStand.get()) instanceof MadeInHeaven) {
                                    MadeInHeaven mih = (MadeInHeaven)patt0$temp;
                                    int entityAccel = mih.getAccel();
                                    entityAccel = Math.min(100, entityAccel);
                                    int entityAccelStatus = entityAccel / 2;
                                    e.setData(Attachments.SPEED, (Object)Float.valueOf(finalSpeed + (float)entityAccelStatus));
                                    continue;
                                }
                                e.setData(Attachments.SPEED, (Object)Float.valueOf(finalSpeed));
                            }
                            source.setData(Attachments.SPEED, (Object)Float.valueOf(101.0f));
                            boolean finalStop = stop;
                            Mots.serverTaskExecutioner.tasks.add(new Queue.Task(140, t -> {
                                Iterable entities = ((ServerLevel)source.level()).getEntities().getAll();
                                for (Entity e : entities) {
                                    e.setData(Attachments.SPEED, (Object)Float.valueOf(100.0f));
                                }
                                if (finalStop) {
                                    stand.startAcceleration();
                                }
                                stand.setAccel(a);
                            }));
                        }
                    }
                }, ModSounds.MIH_ACCEL.get()).setIcon(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/ui/time_deceleration.png"))));
            }
            return;
        }
    }
}

