/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.MotsApi.Skills.SoftAndWet;

import java.util.ArrayList;
import java.util.Optional;
import net.hrodebert.mots.ModEntities.ModEntities;
import net.hrodebert.mots.ModEntities.custom.SoftAndWet;
import net.hrodebert.mots.ModEntities.custom.SoftAndWetBubble;
import net.hrodebert.mots.ModEntities.custom.SoftAndWetBubbleGiant;
import net.hrodebert.mots.ModEntities.custom.StandEntity;
import net.hrodebert.mots.ModParticles.ModParticleTypes;
import net.hrodebert.mots.ModSounds.ModSounds;
import net.hrodebert.mots.Mots;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.Skill;
import net.hrodebert.mots.MotsApi.Skills.SoftAndWet.SoftAndWetAttachments;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.hrodebert.mots.PayLoads.SyncStandData;
import net.hrodebert.mots.ServerQueue.Queue;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class SoftAndWetSkills {
    public static void getSkills(LivingEntity entity) {
        SoftAndWet passenger;
        ArrayList skills = (ArrayList)entity.getData(Attachments.SKILLS);
        skills.add(new Skill("Manifest / Vanish", 0, false, source -> {
            Optional<StandEntity> stand = StandHandler.getStand(source);
            if (stand.isPresent()) {
                stand.get().discard();
                ((ServerPlayer)source).connection.send((Packet)new ClientboundSetPassengersPacket((Entity)((ServerPlayer)source)));
                StandHandler.syncData(source);
                source.level().playSound(null, source.blockPosition(), ModSounds.SOFT_AND_WET_UNSUMMON.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                return;
            }
            SoftAndWet standNew = new SoftAndWet(ModEntities.SOFT_AND_WET.get(), source.level());
            standNew.startRiding((Entity)source);
            source.level().playSound(null, source.blockPosition(), ModSounds.SOFT_AND_WET_SUMMON.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            standNew.moveTo(source.position());
            source.level().addFreshEntity((Entity)standNew);
            if (source instanceof ServerPlayer) {
                ServerPlayer p = (ServerPlayer)source;
                p.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)p));
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(1, task -> PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new SyncStandData((Integer)source.getData(Attachments.STAND_ID), (Integer)source.getData(Attachments.COOLDOWN_TIME_ATTACK), (Integer)source.getData(Attachments.COOLDOWN_TIME_ABILITY), (Integer)source.getData(Attachments.STAMINA), (Integer)source.getData(Attachments.SKILL), (Integer)source.getData(Attachments.MAX_STAMINA)), (CustomPacketPayload[])new CustomPacketPayload[0])));
            }
        }).setIcon(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/ui/summon.png"))));
        Optional<StandEntity> s = StandHandler.getStand(entity);
        if (s.isPresent() && (passenger = (SoftAndWet)s.get()) instanceof SoftAndWet) {
            skills.add(new Skill("Shovel chop", 4, false, source -> {
                source.setData(Attachments.STAND_ATTACK_POTENCY, (Object)((Double)source.getData(Attachments.STAND_ATTACK_POTENCY) + 0.1));
                passenger.chop();
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(10, t -> StandHandler.executeScalableMeleeAttack(source, 6, new Vec3(4.5, 1.0, 4.5), Optional.of(true), Optional.of(8), true).forEach(livingTarget -> {
                    livingTarget.setSwimming(true);
                    source.level().players().forEach(player -> ((ServerLevel)source.level()).sendParticles((ServerPlayer)player, (ParticleOptions)ModParticleTypes.BLOOD_PARTICLE.get(), true, livingTarget.getX(), livingTarget.getEyeY() - 1.0, livingTarget.getZ(), 200, 0.3, 0.3, 0.3, 0.2));
                })));
            }, ModSounds.SOFT_AND_WET_CHOP.get()));
            skills.add(new Skill("Finisher", 5, false, source -> {
                passenger.finisher();
                source.setData(Attachments.STAND_ATTACK_POTENCY, (Object)((Double)source.getData(Attachments.STAND_ATTACK_POTENCY) + 0.1));
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(8, t -> StandHandler.knockBackEntityList(source, StandHandler.executeScalableMeleeAttack(source, 4, new Vec3(3.0, 1.0, 3.0), Optional.of(true), Optional.of(2), true))));
            }, ModSounds.SOFT_AND_WET_FINISHER.get()));
            skills.add(new Skill("Barrage", 3, false, source -> {
                source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> ORA ORA ORA ORA ORA ORA!!!!!!"))));
                passenger.barrage();
                Double damage = 7.0;
                damage = damage + (double)StandHandler.getStandPowerModifier(source);
                Double finalDamage = damage / 30.0;
                StandHandler.applyCooldownAttack(source, 20);
                source.setData(Attachments.STAND_ATTACK_POTENCY, (Object)((Double)source.getData(Attachments.STAND_ATTACK_POTENCY) + 0.1));
                for (int i = 0; i < 58; ++i) {
                    if (i % 2 == 0) {
                        Mots.serverTaskExecutioner.tasks.add(new Queue.Task(i + 5, task -> {
                            StandHandler.applyCooldownAttack(source, 20);
                            StandHandler.executeMeleAttack(source, Float.valueOf(finalDamage.floatValue()), new Vec3(2.0, 0.25, 2.0), Optional.of(true), Optional.of(3), true);
                        }));
                        continue;
                    }
                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(i + 5, task -> {
                        StandHandler.applyCooldownAttack(source, 20);
                        StandHandler.executeMeleAttack(source, null, new Vec3(2.0, 0.25, 2.0), Optional.of(true), Optional.of(3), true);
                    }));
                }
            }, ModSounds.SOFT_AND_WET_BARRAGE.get()));
            skills.add(new Skill("Shoot bubble", 1, true, source -> {
                SoftAndWetBubble bubble = new SoftAndWetBubble(ModEntities.SOFT_AND_WET_BUBBLE.get(), source.level());
                bubble.teleportTo(source.getX(), source.getEyeY(), source.getZ());
                bubble.setNoGravity(true);
                source.setData(Attachments.STAND_SPECIAL_POTENCY.get(), (Object)((Double)source.getData(Attachments.STAND_SPECIAL_POTENCY) + 0.1));
                bubble.shoot(source.getViewVector((float)1.0f).x, source.getViewVector((float)1.0f).y, source.getViewVector((float)1.0f).z, 0.4f, 1.0f);
                Integer level = (Integer)source.getData(SoftAndWetAttachments.BUBBLE_TYPE);
                if (level == 0) {
                    if (source.getItemInHand(InteractionHand.MAIN_HAND).is(Items.POTION) || source.getItemInHand(InteractionHand.OFF_HAND).is(Items.POTION)) {
                        ItemStack potion = null;
                        potion = source.getItemInHand(InteractionHand.MAIN_HAND).is(Items.POTION) ? source.getItemInHand(InteractionHand.MAIN_HAND) : source.getItemInHand(InteractionHand.OFF_HAND);
                        PotionContents content = (PotionContents)potion.get(DataComponents.POTION_CONTENTS);
                        if (content.potion().isPresent()) {
                            content.getAllEffects().forEach(effect -> {
                                bubble.onHitEffect = new MobEffectInstance(effect);
                            });
                        }
                    }
                } else {
                    bubble.hitEffectType = level;
                }
                source.level().addFreshEntity((Entity)bubble);
            }, ModSounds.SOFT_AND_WET_BUBBLE_SHOT.get()));
            skills.add(new Skill("Change bubble type", 0, true, source -> {
                Integer level;
                StandHandler.applyCooldownAbility(source, 40);
                Integer n = level = (Integer)source.getData(SoftAndWetAttachments.BUBBLE_TYPE);
                level = level + 1;
                if (source.isCrouching()) {
                    level = level - 2;
                }
                if (level > 3) {
                    level = 0;
                }
                if (level < 0) {
                    level = 3;
                }
                source.setData(SoftAndWetAttachments.BUBBLE_TYPE, (Object)level);
                if (level == 0) {
                    source.sendSystemMessage((Component)Component.literal((String)"Potion infuse"));
                } else if (level == 1) {
                    source.sendSystemMessage((Component)Component.literal((String)"No friction"));
                } else if (level == 2) {
                    source.sendSystemMessage((Component)Component.literal((String)"No vision"));
                } else if (level == 3) {
                    source.sendSystemMessage((Component)Component.literal((String)"No stand"));
                }
            }));
            skills.add(new Skill("Bubble counter", 4, true, source -> {
                source.setData(SoftAndWetAttachments.COUNTER, (Object)true);
                source.setData(Attachments.STAND_SPECIAL_POTENCY.get(), (Object)((Double)source.getData(Attachments.STAND_ATTACK_POTENCY) + 0.1));
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task((int)((Double)source.getData(Attachments.STAND_ATTACK_POTENCY) * 10.0), t -> source.setData(SoftAndWetAttachments.COUNTER, (Object)false)));
            }, ModSounds.SOFT_AND_WET_COUNTER.get()));
            skills.add(new Skill("Bubble enclosure", 5, true, source -> {
                SoftAndWetBubbleGiant bubble = new SoftAndWetBubbleGiant(ModEntities.SOFT_AND_WET_BUBBLE_GIANT.get(), source.level());
                bubble.teleportTo(source.getX(), source.getEyeY(), source.getZ());
                bubble.setNoGravity(true);
                source.level().addFreshEntity((Entity)bubble);
                source.setData(Attachments.STAND_SPECIAL_POTENCY.get(), (Object)((Double)source.getData(Attachments.STAND_ATTACK_POTENCY) + 0.1));
                source.startRiding((Entity)bubble);
            }));
        }
    }
}

