/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.MotsApi.Skills.TheWorld;

import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.hrodebert.mots.ModEntities.ModEntities;
import net.hrodebert.mots.ModEntities.custom.StandEntity;
import net.hrodebert.mots.ModEntities.custom.TheWorld;
import net.hrodebert.mots.ModEntities.custom.TheWorldOverHeaven;
import net.hrodebert.mots.ModParticles.ModParticleTypes;
import net.hrodebert.mots.ModSounds.ModSounds;
import net.hrodebert.mots.Mots;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.Skill;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.hrodebert.mots.MotsApi.StandTimeHandler;
import net.hrodebert.mots.PayLoads.SyncStandData;
import net.hrodebert.mots.ServerQueue.Queue;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class TwSkills {
    public static void overWriteListOfEntities(ArrayList<Entity> entities, LivingEntity source) {
        block12: {
            Integer overWriteType;
            block13: {
                block11: {
                    overWriteType = (Integer)source.getData(Attachments.THE_WORLD_REALITY_OVERWRITE.get());
                    if (overWriteType != 0) break block11;
                    for (int i = 0; i < entities.size(); ++i) {
                        Entity entity = entities.get(i);
                        if (!(entity instanceof LivingEntity)) continue;
                        LivingEntity entity2 = (LivingEntity)entity;
                        entity2.setData(Attachments.TW_OH_ALLY.get(), (Object)source.getUUID());
                    }
                    break block12;
                }
                if (overWriteType != 1) break block13;
                for (int i = 0; i < entities.size(); ++i) {
                    Entity entity = entities.get(i);
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity entity3 = (LivingEntity)entity;
                    if (entity3 instanceof ZombifiedPiglin) {
                        ((Piglin)((Mob)entity3).convertTo(EntityType.PIGLIN, true)).setNoAi(false);
                    }
                    if (entity3 instanceof ZombieVillager) {
                        ((Villager)((Mob)entity3).convertTo(EntityType.VILLAGER, true)).setNoAi(false);
                    }
                    if (entity3 instanceof ZombieHorse) {
                        ((Horse)((Mob)entity3).convertTo(EntityType.HORSE, true)).setNoAi(false);
                    }
                    if (entity3 instanceof Zoglin) {
                        ((Hoglin)((Mob)entity3).convertTo(EntityType.HOGLIN, true)).setNoAi(false);
                    }
                    entity3.heal((float)((Double)source.getData(Attachments.STAND_SPECIAL_POTENCY) / 2.0));
                    entity3.getActiveEffects().forEach(mobEffectInstance -> {
                        if (!((MobEffect)mobEffectInstance.getEffect().value()).isBeneficial()) {
                            try {
                                entity3.removeEffect(mobEffectInstance.getEffect());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
                break block12;
            }
            if (overWriteType != 2) break block12;
            for (int i = 0; i < entities.size(); ++i) {
                Entity entity = entities.get(i);
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity entity4 = (LivingEntity)entity;
                if (entity4 instanceof Piglin) {
                    ((ZombifiedPiglin)((Mob)entity4).convertTo(EntityType.ZOMBIFIED_PIGLIN, true)).setNoAi(false);
                }
                if (entity4 instanceof Villager) {
                    ((ZombieVillager)((Mob)entity4).convertTo(EntityType.ZOMBIE_VILLAGER, true)).setNoAi(false);
                }
                if (entity4 instanceof Horse) {
                    ((ZombieHorse)((Mob)entity4).convertTo(EntityType.ZOMBIE_HORSE, true)).setNoAi(false);
                }
                if (entity4 instanceof Hoglin) {
                    ((Zoglin)((Mob)entity4).convertTo(EntityType.ZOGLIN, true)).setNoAi(false);
                }
                entity4.hurt(source.damageSources().generic(), (float)((Double)source.getData(Attachments.STAND_SPECIAL_POTENCY) / 2.0));
                entity4.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 60, 0));
                entity4.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 60, 0));
                entity4.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 0));
                entity4.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 60, 0));
            }
        }
    }

    public static void getSkills(LivingEntity entity) {
        StandEntity passenger;
        ArrayList skills = (ArrayList)entity.getData(Attachments.SKILLS);
        skills.add(new Skill("Manifest / Vanish", 0, false, source -> {
            Optional<StandEntity> stand = StandHandler.getStand(source);
            if (stand.isPresent()) {
                stand.get().discard();
                ((ServerPlayer)source).connection.send((Packet)new ClientboundSetPassengersPacket((Entity)((ServerPlayer)source)));
                StandHandler.syncData(source);
                source.level().playSound(null, source.blockPosition(), ModSounds.TW_OFF.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                return;
            }
            TheWorld standNew = source.hasData(Attachments.OVER_HEAVEN) && (Boolean)source.getData(Attachments.OVER_HEAVEN) != false ? new TheWorldOverHeaven(ModEntities.THE_WORLD_OH.get(), source.level()) : new TheWorld(ModEntities.THE_WORLD.get(), source.level());
            standNew.startRiding((Entity)source);
            source.level().playSound(null, source.blockPosition(), ModSounds.TW_SUMMON.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            standNew.moveTo(source.position());
            source.level().addFreshEntity((Entity)standNew);
            if (source instanceof ServerPlayer) {
                ServerPlayer p = (ServerPlayer)source;
                p.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)p));
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(1, task -> PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new SyncStandData((Integer)source.getData(Attachments.STAND_ID), (Integer)source.getData(Attachments.COOLDOWN_TIME_ATTACK), (Integer)source.getData(Attachments.COOLDOWN_TIME_ABILITY), (Integer)source.getData(Attachments.STAMINA), (Integer)source.getData(Attachments.SKILL), (Integer)source.getData(Attachments.MAX_STAMINA)), (CustomPacketPayload[])new CustomPacketPayload[0])));
            }
        }).setIcon(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/ui/summon.png"))));
        Optional<StandEntity> s = StandHandler.getStand(entity);
        if (s.isPresent() && (passenger = s.get()) instanceof TheWorld) {
            skills.add(new Skill("Chop", 2, false, source -> {
                source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> Useless..."))));
                if (passenger instanceof TheWorld) {
                    TheWorld stand = (TheWorld)passenger;
                    try {
                        stand.chop();
                        StandHandler.applyCooldownAttack(source, 40);
                        Mots.serverTaskExecutioner.tasks.add(new Queue.Task(10, task -> StandHandler.executeScalableMeleeAttack((LivingEntity)((ServerPlayer)source), 2, new Vec3(4.0, 0.25, 4.0), Optional.of(true), Optional.of(2), true).forEach(target -> source.level().players().forEach(player -> ((ServerLevel)source.level()).sendParticles((ServerPlayer)player, (ParticleOptions)ModParticleTypes.BLOOD_PARTICLE.get(), true, target.getX(), target.getEyeY() - 1.0, target.getZ(), 200, 0.3, 0.3, 0.3, 0.2)))));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, ModSounds.TW_CHOP.get()));
            skills.add(new Skill("Finisher", 4, false, source -> {
                if (passenger instanceof TheWorld) {
                    TheWorld stand = (TheWorld)passenger;
                    try {
                        source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> DIE!!!!"))));
                        stand.finisher();
                        StandHandler.applyCooldownAttack(source, 60);
                        Mots.serverTaskExecutioner.tasks.add(new Queue.Task(10, task -> StandHandler.knockBackEntityList(source, StandHandler.executeScalableMeleeAttack(source, 5, new Vec3(4.0, 0.25, 4.0), Optional.of(false), Optional.of(0), true))));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, ModSounds.TW_FINISHER.get()));
            skills.add(new Skill("Barrage", 3, false, source -> {
                if (passenger instanceof TheWorld) {
                    TheWorld stand = (TheWorld)passenger;
                    try {
                        source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> MUDA,MUDA,MUDA,MUDA,MUDA,MUDA,MUDA!!!!!!"))));
                        stand.barrage();
                        Double damage = 7.0;
                        damage = damage + (double)StandHandler.getStandPowerModifier(source);
                        Double finalDamage = damage / 30.0;
                        StandHandler.applyCooldownAttack(source, 20);
                        source.setData(Attachments.STAND_ATTACK_POTENCY, (Object)((Double)source.getData(Attachments.STAND_ATTACK_POTENCY) + 0.1));
                        for (int i = 0; i < 158; ++i) {
                            if (i % 2 == 0) {
                                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(i + 5, task -> {
                                    StandHandler.applyCooldownAttack(source, 20);
                                    StandHandler.executeMeleAttack(source, Float.valueOf(finalDamage.floatValue()), new Vec3(2.0, 0.25, 2.0), Optional.of(true), Optional.of(3), true);
                                }));
                                continue;
                            }
                            Mots.serverTaskExecutioner.tasks.add(new Queue.Task(i + 5, task -> {
                                StandHandler.applyCooldownAttack(source, 20);
                                StandHandler.executeMeleAttack(source, null, new Vec3(2.0, 0.25, 2.0), Optional.of(true), Optional.of(3), true);
                            }));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, ModSounds.TW_BARRAGE.get()));
            skills.add(new Skill("Grab", 4, true, source -> {
                if (passenger instanceof TheWorld) {
                    TheWorld stand = (TheWorld)passenger;
                    try {
                        StandHandler.applyCooldownAbility(source, 20);
                        if (!stand.isInPilot()) {
                            stand.grabbing = true;
                            stand.switchPilot();
                            stand.teleportTo(source.getX(), source.getY(), source.getZ());
                            AtomicBoolean executed = new AtomicBoolean(false);
                            for (int i = 0; i < 20; ++i) {
                                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(i, t -> {
                                    if (!executed.get()) {
                                        stand.lookAt(EntityAnchorArgument.Anchor.EYES, source.getViewVector(1.0f));
                                        stand.setDeltaMovement(source.getViewVector(1.0f).multiply(1.0, 1.0, 1.0));
                                        stand.level().getEntities(null, stand.getBoundingBox()).forEach(e -> {
                                            if (e.equals(source) || e.equals((Object)stand)) {
                                                return;
                                            }
                                            if (e instanceof LivingEntity) {
                                                LivingEntity living = (LivingEntity)e;
                                                executed.set(true);
                                                StandHandler.applyCooldownAbility(living, 20);
                                                StandHandler.applyCooldownAttack(living, 20);
                                                living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 20, 255));
                                                living.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 20, 255));
                                                stand.switchPilot();
                                                source.level().tickRateManager().setFrozen(true);
                                                source.setData(Attachments.TIME_STOP_TICKS_LEFT.get(), (Object)((Integer)source.getData(Attachments.TIME_STOP_TICKS_LEFT) + 15));
                                                source.teleportTo(living.getX(), living.getY(), living.getZ());
                                                TheWorld standNew = source.hasData(Attachments.OVER_HEAVEN) && (Boolean)source.getData(Attachments.OVER_HEAVEN) != false ? new TheWorldOverHeaven(ModEntities.THE_WORLD_OH.get(), source.level()) : new TheWorld(ModEntities.THE_WORLD.get(), source.level());
                                                standNew.startRiding((Entity)source);
                                                source.level().playSound(null, source.blockPosition(), ModSounds.TW_SUMMON.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                                                standNew.moveTo(source.position());
                                                source.level().addFreshEntity((Entity)standNew);
                                                if (source instanceof ServerPlayer) {
                                                    ServerPlayer p = (ServerPlayer)source;
                                                    p.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)p));
                                                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(1, task -> PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new SyncStandData((Integer)source.getData(Attachments.STAND_ID), (Integer)source.getData(Attachments.COOLDOWN_TIME_ATTACK), (Integer)source.getData(Attachments.COOLDOWN_TIME_ABILITY), (Integer)source.getData(Attachments.STAMINA), (Integer)source.getData(Attachments.SKILL), (Integer)source.getData(Attachments.MAX_STAMINA)), (CustomPacketPayload[])new CustomPacketPayload[0])));
                                                }
                                            }
                                        });
                                    }
                                }));
                            }
                            Mots.serverTaskExecutioner.tasks.add(new Queue.Task(25, t -> {
                                if (!executed.get()) {
                                    stand.switchPilot();
                                }
                                source.setData(Attachments.COOLDOWN_TIME_ABILITY.get(), (Object)0);
                            }));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, ModSounds.TW_FINISHER.get()));
            if (passenger instanceof TheWorldOverHeaven) {
                skills.add(new Skill("Over heaven dimensional shift", 4, true, source -> {
                    source.setData(Attachments.STAMINA.get(), (Object)((Integer)source.getData(Attachments.STAMINA) + 4));
                    StandHandler.syncData(source);
                    source.sendSystemMessage((Component)Component.literal((String)"<The world over heaven> Who would you like to teleport(4 stamina)?"));
                    source.level().getServer().getPlayerList().getPlayers().forEach(player -> {
                        MutableComponent yesComponent = Component.literal((String)player.getName().getString()).withStyle(style -> style.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/teleport_to_oh_dim " + player.getStringUUID())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to send the player in that dimension")))).withStyle(ChatFormatting.DARK_AQUA);
                        source.sendSystemMessage((Component)yesComponent);
                    });
                }));
                skills.add(new Skill("Light bolt fury", 6, true, source -> source.level().getEntities(null, source.getBoundingBox().inflate(15.0)).forEach(entry -> {
                    if (entry.equals(source) || entry.equals((Object)passenger)) {
                        return;
                    }
                    source.setInvulnerable(true);
                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(10, t -> {
                        LightningBolt bolt = new LightningBolt(EntityType.LIGHTNING_BOLT, source.level());
                        bolt.teleportTo(entry.getX(), entry.getY(), entry.getZ());
                        source.level().addFreshEntity((Entity)bolt);
                        AreaEffectCloud areaeffectcloud = new AreaEffectCloud(entry.level(), entry.getX(), entry.getY(), entry.getZ());
                        if (entity instanceof LivingEntity) {
                            areaeffectcloud.setOwner(entity);
                        }
                        areaeffectcloud.setParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH);
                        areaeffectcloud.setRadius(1.5f);
                        areaeffectcloud.setDuration(80);
                        areaeffectcloud.setRadiusPerTick((7.0f - areaeffectcloud.getRadius()) / (float)areaeffectcloud.getDuration());
                        areaeffectcloud.addEffect(new MobEffectInstance(MobEffects.HARM, 1, 1));
                        entry.level().addFreshEntity((Entity)areaeffectcloud);
                    }));
                    Mots.serverTaskExecutioner2.tasks.add(new Queue.Task(15, t -> source.setInvulnerable(false)));
                })));
                Consumer<LivingEntity> overwrite = source -> {
                    ArrayList<Entity> hits = new ArrayList<Entity>();
                    if (source.isCrouching()) {
                        hits.add((Entity)source);
                        TwSkills.overWriteListOfEntities(hits, source);
                    } else {
                        TheWorld stand = (TheWorld)passenger;
                        try {
                            source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> DIE!!!!"))));
                            stand.finisher();
                            StandHandler.applyCooldownAttack(source, 60);
                            Mots.serverTaskExecutioner.tasks.add(new Queue.Task(12, task -> {
                                hits.addAll(StandHandler.executeScalableMeleeAttack(source, null, new Vec3(4.0, 0.25, 4.0), Optional.of(true), Optional.of(2), true));
                                StandHandler.knockBackEntityList(source, hits);
                                TwSkills.overWriteListOfEntities(hits, source);
                            }));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                if (entity.isCrouching()) {
                    skills.add(new Skill("Self reality rewrite", 2, true, overwrite));
                } else {
                    skills.add(new Skill("Reality rewrite", 4, true, overwrite));
                }
                skills.add(new Skill("Change overwrite type", 0, true, source -> {
                    Integer level;
                    Integer n = level = (Integer)source.getData(Attachments.THE_WORLD_REALITY_OVERWRITE);
                    level = level + 1;
                    if (source.isCrouching()) {
                        level = level - 2;
                    }
                    int size = 2;
                    if (level > size) {
                        level = 0;
                    }
                    if (level < 0) {
                        level = size;
                    }
                    source.setData(Attachments.THE_WORLD_REALITY_OVERWRITE, (Object)level);
                    if (level == 0) {
                        source.sendSystemMessage((Component)Component.literal((String)"Mind wash (all entities that get hit will become friendly)"));
                    } else if (level == 1) {
                        source.sendSystemMessage((Component)Component.literal((String)"Wound eraser (erases the wounds from reality)"));
                    } else if (level == 2) {
                        source.sendSystemMessage((Component)Component.literal((String)"Debuff overwriter (gives debuffes to the entities that get hit)"));
                    }
                }));
            }
            skills.add(new Skill("Time skip", 3, true, source -> {
                if (passenger instanceof TheWorld) {
                    TheWorld stand = (TheWorld)passenger;
                    source.setData(Attachments.STAND_SPECIAL_POTENCY, (Object)((Double)source.getData(Attachments.STAND_SPECIAL_POTENCY) + 0.1));
                    StandTimeHandler.timeStop(source, 0);
                    StandHandler.registerSkills(source);
                    StandHandler.syncData(source);
                    source.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 60, 255, false, false));
                    source.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 60, 1, false, false));
                    source.addEffect(new MobEffectInstance(MobEffects.JUMP, 60, 1, false, false));
                    source.setData(Attachments.COOLDOWN_TIME_ABILITY, (Object)0);
                    StandHandler.applyCooldownAttack(source, 70);
                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(60, t -> {
                        source.setData(Attachments.TIME_STOP_TICKS_LEFT, (Object)1);
                        source.setData(Attachments.COOLDOWN_TIME_ABILITY, (Object)0);
                    }));
                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(71, t -> {
                        source.setData(Attachments.COOLDOWN_TIME_ABILITY, (Object)0);
                        StandHandler.applyCooldownAbility(source, 140);
                    }));
                }
            }).setIcon(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/ui/time_resume.png"))));
            if ((Integer)entity.getData(Attachments.TIME_STOP_TICKS_LEFT) <= 0) {
                skills.add(new Skill("Time stop", 5, true, source -> {
                    if (passenger instanceof TheWorld) {
                        TheWorld stand = (TheWorld)passenger;
                        stand.timeStop();
                        source.setData(Attachments.STAND_SPECIAL_POTENCY, (Object)((Double)source.getData(Attachments.STAND_SPECIAL_POTENCY) + 0.1));
                        source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> THE WORLD!!!"))));
                        StandTimeHandler.timeStop(source, 30);
                        StandHandler.registerSkills(source);
                        StandHandler.syncData(source);
                    }
                }).setIcon(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/ui/time_stop.png"))));
            } else {
                skills.add(new Skill("Time resume", 0, true, source -> {
                    if (passenger instanceof TheWorld) {
                        TheWorld stand = (TheWorld)passenger;
                        source.setData(Attachments.TIME_STOP_TICKS_LEFT, (Object)1);
                        source.setData(Attachments.COOLDOWN_TIME_ABILITY, (Object)2);
                        source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> THE WORLD!!!"))));
                        StandHandler.registerSkills(source);
                        StandHandler.syncData(source);
                    }
                }).setIcon(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/ui/time_resume.png"))));
            }
            return;
        }
    }
}

