/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.MotsApi.Skills.TuskSkills;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.hrodebert.mots.ModEntities.ModEntities;
import net.hrodebert.mots.ModEntities.custom.StandEntity;
import net.hrodebert.mots.ModEntities.custom.Tusk;
import net.hrodebert.mots.ModEntities.custom.TuskAct2;
import net.hrodebert.mots.ModEntities.custom.TuskAct3;
import net.hrodebert.mots.ModEntities.custom.TuskAct4;
import net.hrodebert.mots.ModEntities.custom.TuskNail;
import net.hrodebert.mots.ModEntities.custom.WormHole;
import net.hrodebert.mots.ModParticles.ModParticleTypes;
import net.hrodebert.mots.ModSounds.ModSounds;
import net.hrodebert.mots.Mots;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.Skill;
import net.hrodebert.mots.MotsApi.Skills.TuskSkills.TuskProgression;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.hrodebert.mots.PayLoads.SetPlayerAnimation;
import net.hrodebert.mots.PayLoads.SwingArm;
import net.hrodebert.mots.PayLoads.SyncStandData;
import net.hrodebert.mots.ServerQueue.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class TuskSkills {
    public static void getSkills(LivingEntity entity) {
        ArrayList skills = (ArrayList)entity.getData(Attachments.SKILLS);
        skills.add(new Skill("Manifest / Vanish", 0, false, source -> {
            Optional<StandEntity> stand = StandHandler.getStand(source);
            if (stand.isPresent()) {
                stand.get().discard();
                ((ServerPlayer)source).connection.send((Packet)new ClientboundSetPassengersPacket((Entity)((ServerPlayer)source)));
                StandHandler.syncData(source);
                source.level().playSound(null, source.blockPosition(), ModSounds.TUSK_OFF.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                return;
            }
            StandEntity standNew = (Integer)entity.getData(TuskProgression.TUSK_ACT) == 1 ? new Tusk(ModEntities.TUSK.get(), source.level()) : ((Integer)entity.getData(TuskProgression.TUSK_ACT) == 2 ? new TuskAct2(ModEntities.TUSK_ACT_2.get(), source.level()) : ((Integer)entity.getData(TuskProgression.TUSK_ACT) == 3 ? new TuskAct3(ModEntities.TUSK_3.get(), source.level()) : new TuskAct4(ModEntities.TUSK_4.get(), source.level())));
            standNew.startRiding((Entity)source);
            source.level().playSound(null, source.blockPosition(), ModSounds.TUSK_ON.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            standNew.moveTo(source.position());
            source.level().addFreshEntity((Entity)standNew);
            if (source instanceof ServerPlayer) {
                ServerPlayer p = (ServerPlayer)source;
                p.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)p));
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(1, task -> PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new SyncStandData((Integer)source.getData(Attachments.STAND_ID), (Integer)source.getData(Attachments.COOLDOWN_TIME_ATTACK), (Integer)source.getData(Attachments.COOLDOWN_TIME_ABILITY), (Integer)source.getData(Attachments.STAMINA), (Integer)source.getData(Attachments.SKILL), (Integer)source.getData(Attachments.MAX_STAMINA)), (CustomPacketPayload[])new CustomPacketPayload[0])));
            }
        }).setIcon(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/ui/summon.png"))));
        Optional<StandEntity> s = StandHandler.getStand(entity);
        if (s.isPresent()) {
            StandEntity passenger = s.get();
            Integer current_act = (Integer)entity.getData(TuskProgression.CURRENT_ACT);
            skills.add(new Skill("Shoot nail", 1, true, source -> {
                Random random;
                int chance;
                TuskNail bubble = new TuskNail(ModEntities.TUSK_NAIL.get(), source.level());
                bubble.teleportTo(source.getX(), source.getEyeY(), source.getZ());
                source.setData(Attachments.STAND_SPECIAL_POTENCY.get(), (Object)((Double)source.getData(Attachments.STAND_SPECIAL_POTENCY) + 0.1));
                bubble.setBaseDamage((Double)source.getData(Attachments.STAND_SPECIAL_POTENCY) / 10.0 + (Double)source.getData(Attachments.SPIN_AMOUNT) / 10.0);
                StandHandler.applyCooldownAbility(source, 5);
                source.level().addFreshEntity((Entity)bubble);
                source.swing(InteractionHand.MAIN_HAND);
                if (source instanceof ServerPlayer) {
                    ServerPlayer p = (ServerPlayer)source;
                    PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new SwingArm(true, source.getUUID().toString()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                float velocity = 2.0f;
                if ((Integer)entity.getData(TuskProgression.TUSK_ACT) >= 2) {
                    bubble.setOwner((Entity)source);
                    bubble.golden_rec = true;
                    velocity = 3.0f;
                    bubble.setNoGravity(true);
                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(25, o -> bubble.setNoGravity(false)));
                }
                if ((chance = (random = new Random()).nextInt(100)) < 2 && (Integer)source.getData(TuskProgression.TUSK_ACT) == 2) {
                    source.setData(TuskProgression.TUSK_ACT, (Object)3);
                    source.sendSystemMessage((Component)Component.literal((String)"<Jesus> If your heart is wavering, then stop shooting. Grow... and once again, the door to a new path will open."));
                }
                bubble.shoot(source.getViewVector((float)1.0f).x, source.getViewVector((float)1.0f).y, source.getViewVector((float)1.0f).z, velocity, 1.0f);
            }, ModSounds.TUSK_NAIL.get()));
            skills.add(new Skill("Triple shoot", 3, true, source -> {
                StandHandler.applyCooldownAbility(source, 25);
                for (int i = 0; i < 3; ++i) {
                    Mots.serverTaskExecutioner2.tasks.add(new Queue.Task(i * 5, t -> {
                        source.level().playSound(null, source.blockPosition(), ModSounds.TUSK_NAIL.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                        TuskNail bubble = new TuskNail(ModEntities.TUSK_NAIL.get(), source.level());
                        bubble.teleportTo(source.getX(), source.getEyeY(), source.getZ());
                        source.setData(Attachments.STAND_SPECIAL_POTENCY.get(), (Object)((Double)source.getData(Attachments.STAND_SPECIAL_POTENCY) + 0.1));
                        bubble.setBaseDamage((Double)source.getData(Attachments.STAND_SPECIAL_POTENCY) / 10.0 + (Double)source.getData(Attachments.SPIN_AMOUNT) / 10.0);
                        StandHandler.applyCooldownAbility(source, 5);
                        source.level().addFreshEntity((Entity)bubble);
                        source.swing(InteractionHand.MAIN_HAND);
                        float velocity = 2.0f;
                        if ((Integer)entity.getData(TuskProgression.TUSK_ACT) >= 2) {
                            bubble.setOwner((Entity)source);
                            bubble.golden_rec = true;
                            velocity = 3.0f;
                            bubble.setNoGravity(true);
                            Mots.serverTaskExecutioner.tasks.add(new Queue.Task(25, o -> bubble.setNoGravity(false)));
                        }
                        bubble.shoot(source.getViewVector((float)1.0f).x, source.getViewVector((float)1.0f).y, source.getViewVector((float)1.0f).z, velocity, 1.0f);
                        if (source instanceof ServerPlayer) {
                            ServerPlayer p = (ServerPlayer)source;
                            PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new SwingArm(true, source.getUUID().toString()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        }
                    }));
                }
            }));
            if (passenger instanceof TuskAct3 || passenger instanceof TuskAct4) {
                skills.add(new Skill("Enter worm hole", 1, true, source -> {
                    source.level().players().forEach(player -> PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new SetPlayerAnimation(source.getStringUUID(), "wormhole"), (CustomPacketPayload[])new CustomPacketPayload[0]));
                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(7, t -> {
                        source.level().playSound(null, source.blockPosition(), ModSounds.TUSK_NAIL.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                        source.level().players().forEach(player -> ((ServerLevel)source.level()).sendParticles((ServerPlayer)player, (ParticleOptions)ModParticleTypes.BLOOD_PARTICLE.get(), true, source.getX(), source.getEyeY(), source.getZ(), 200, 0.1, 0.1, 0.1, 0.2));
                    }));
                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(20, t -> {
                        if (source.getVehicle() == null) {
                            return;
                        }
                        source.level().players().forEach(player -> {
                            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new SetPlayerAnimation(source.getStringUUID(), "wormhole_idle"), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            try {
                                passenger.discard();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        });
                    }));
                    WormHole wormHole = new WormHole(ModEntities.WORMHOLE.get(), source.level());
                    wormHole.teleportTo(source.getX(), source.getY(), source.getZ());
                    source.stopRiding();
                    source.setInvulnerable(true);
                    wormHole.containsOwner = true;
                    StandHandler.applyCooldownAbility(source, 60);
                    source.startRiding((Entity)wormHole);
                    if (source instanceof ServerPlayer) {
                        ServerPlayer p = (ServerPlayer)source;
                        wormHole.tame((Player)p);
                    }
                    source.level().addFreshEntity((Entity)wormHole);
                }, ModSounds.TUSK_ENTER_WORMHOLE.get()));
            }
            if (passenger instanceof TuskAct4) {
                TuskAct4 act4 = (TuskAct4)passenger;
                skills.add(new Skill("Wormhole uppercut", 3, true, source -> {
                    StandHandler.applyCooldownAttack(source, 80);
                    TuskNail bubble = new TuskNail(ModEntities.TUSK_NAIL.get(), source.level());
                    bubble.teleportTo(source.getX(), source.getEyeY(), source.getZ());
                    source.setData(Attachments.STAND_SPECIAL_POTENCY.get(), (Object)((Double)source.getData(Attachments.STAND_SPECIAL_POTENCY) + 0.1));
                    bubble.setBaseDamage((Double)source.getData(Attachments.STAND_SPECIAL_POTENCY) / 10.0 + (Double)source.getData(Attachments.SPIN_AMOUNT) / 10.0);
                    StandHandler.applyCooldownAbility(source, 5);
                    source.level().addFreshEntity((Entity)bubble);
                    source.swing(InteractionHand.MAIN_HAND);
                    if (source instanceof ServerPlayer) {
                        ServerPlayer p = (ServerPlayer)source;
                        PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new SwingArm(true, source.getUUID().toString()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                    bubble.setOwner((Entity)source);
                    bubble.golden_rec = true;
                    float velocity = 3.0f;
                    bubble.setNoGravity(true);
                    bubble.containsTusk = true;
                    passenger.discard();
                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(25, o -> bubble.setNoGravity(false)));
                    bubble.shoot(source.getViewVector((float)1.0f).x, source.getViewVector((float)1.0f).y, source.getViewVector((float)1.0f).z, velocity, 1.0f);
                    if (source instanceof ServerPlayer) {
                        ServerPlayer p = (ServerPlayer)source;
                        PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new SwingArm(true, source.getUUID().toString()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }, ModSounds.TUSK_WORMHOLE_UPPERCUT.get()));
                skills.add(new Skill("Spin finisher", 3, false, source -> {
                    act4.finisher();
                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(8, t -> {
                        List<Entity> list = StandHandler.executeScalableMeleeAttack(source, 7, new Vec3(3.0, (double)0.4f, 3.0), Optional.of(true), Optional.of(2), true);
                        StandHandler.knockBackEntityList(source, list);
                        ArrayList pairs = new ArrayList();
                        ResourceKey dim = source.level().dimension();
                        ServerLevel serverLevel = (ServerLevel)source.level();
                        list.forEach(e -> {
                            pairs.add(new Pair((Object)e.getUUID(), (Object)e.blockPosition()));
                            for (int i = 0; i < 200; ++i) {
                                Mots.serverTaskExecutioner2.tasks.add(new Queue.Task(i, task -> {
                                    e.setYHeadRot(e.getYHeadRot() + 20.0f);
                                    pairs.forEach(pair -> serverLevel.getServer().getAllLevels().forEach(level -> {
                                        if (level.getEntities().get((UUID)pair.getFirst()) != null) {
                                            Entity target;
                                            if (serverLevel.getEntities().get((UUID)pair.getFirst()) == null) {
                                                target = level.getEntity((UUID)pair.getFirst());
                                                ((Entity)level.getEntities().get((UUID)pair.getFirst())).teleportTo(serverLevel, (double)((BlockPos)pair.getSecond()).getX(), (double)((BlockPos)pair.getSecond()).getY(), (double)((BlockPos)pair.getSecond()).getZ(), null, target.getYRot(), target.getXRot());
                                            }
                                            if ((target = level.getEntity((UUID)pair.getFirst())).distanceToSqr((double)((BlockPos)pair.getSecond()).getX(), (double)((BlockPos)pair.getSecond()).getY(), (double)((BlockPos)pair.getSecond()).getZ()) > 7.0 && target instanceof LivingEntity) {
                                                LivingEntity player = (LivingEntity)target;
                                                double speed = 0.5;
                                                Vec3 mov = new Vec3(0.0, 0.0, 0.0);
                                                mov = (double)((BlockPos)pair.getSecond()).getX() < player.position().x ? new Vec3(-speed, mov.y, mov.z) : new Vec3(speed, mov.y, mov.z);
                                                mov = (double)((BlockPos)pair.getSecond()).getY() < player.getEyeY() ? new Vec3(mov.x, -speed, mov.z) : new Vec3(mov.x, speed, mov.z);
                                                mov = (double)((BlockPos)pair.getSecond()).getZ() < player.position().z ? new Vec3(mov.x, mov.y, -speed) : new Vec3(mov.x, mov.y, speed);
                                                player.setDeltaMovement(mov);
                                                player.hurtMarked = true;
                                            }
                                        }
                                    }));
                                }));
                            }
                        });
                    }));
                }, ModSounds.TUSK_SLASH.get()));
                skills.add(new Skill("Uppercut", 2, false, source -> {
                    act4.uppercut();
                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(5, t -> {
                        List<Entity> list = StandHandler.executeScalableMeleeAttack(source, 4, new Vec3(3.0, (double)0.4f, 3.0), Optional.of(false), Optional.empty(), true);
                        list.forEach(e -> {
                            e.addDeltaMovement(new Vec3(0.0, 1.0, 0.0));
                            e.hurtMarked = true;
                        });
                        ArrayList pairs = new ArrayList();
                        ResourceKey dim = source.level().dimension();
                        ServerLevel serverLevel = (ServerLevel)source.level();
                        list.forEach(e -> {
                            pairs.add(new Pair((Object)e.getUUID(), (Object)e.blockPosition()));
                            for (int i = 0; i < 200; ++i) {
                                Mots.serverTaskExecutioner2.tasks.add(new Queue.Task(i, task -> {
                                    e.setYHeadRot(e.getYHeadRot() + 20.0f);
                                    pairs.forEach(pair -> serverLevel.getServer().getAllLevels().forEach(level -> {
                                        if (level.getEntities().get((UUID)pair.getFirst()) != null) {
                                            Entity target;
                                            if (serverLevel.getEntities().get((UUID)pair.getFirst()) == null) {
                                                target = level.getEntity((UUID)pair.getFirst());
                                                ((Entity)level.getEntities().get((UUID)pair.getFirst())).teleportTo(serverLevel, (double)((BlockPos)pair.getSecond()).getX(), (double)((BlockPos)pair.getSecond()).getY(), (double)((BlockPos)pair.getSecond()).getZ(), null, target.getYRot(), target.getXRot());
                                            }
                                            if ((target = level.getEntity((UUID)pair.getFirst())).distanceToSqr((double)((BlockPos)pair.getSecond()).getX(), (double)((BlockPos)pair.getSecond()).getY(), (double)((BlockPos)pair.getSecond()).getZ()) > 7.0 && target instanceof LivingEntity) {
                                                LivingEntity player = (LivingEntity)target;
                                                double speed = 0.5;
                                                Vec3 mov = new Vec3(0.0, 0.0, 0.0);
                                                mov = (double)((BlockPos)pair.getSecond()).getX() < player.position().x ? new Vec3(-speed, mov.y, mov.z) : new Vec3(speed, mov.y, mov.z);
                                                mov = (double)((BlockPos)pair.getSecond()).getY() < player.getEyeY() ? new Vec3(mov.x, -speed, mov.z) : new Vec3(mov.x, speed, mov.z);
                                                mov = (double)((BlockPos)pair.getSecond()).getZ() < player.position().z ? new Vec3(mov.x, mov.y, -speed) : new Vec3(mov.x, mov.y, speed);
                                                player.setDeltaMovement(mov);
                                                player.hurtMarked = true;
                                            }
                                        }
                                    }));
                                }));
                            }
                        });
                    }));
                }, ModSounds.TUSK_UPPERCUT.get()));
            } else {
                skills.add(new Skill("Nail slash", 1, false, source -> {
                    Mots.serverTaskExecutioner2.tasks.add(new Queue.Task(5, t -> StandHandler.executeScalableMeleeAttack(source, 4, new Vec3(2.0, (double)0.4f, 1.0), Optional.of(true), Optional.of(4), true)));
                    StandHandler.applyCooldownAttack(source, 100);
                    if (source instanceof ServerPlayer) {
                        ServerPlayer p = (ServerPlayer)source;
                        PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new SwingArm(true, source.getUUID().toString()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }, ModSounds.TUSK_SLASH.get()));
            }
        }
    }
}

