/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.MotsApi.Skills.WeatherReport;

import net.hrodebert.mots.ModEntities.custom.StandEntity;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.Skills.WeatherReport.WeatherReportAttachments;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

public class WeatherReportEvent {
    public static void onTick(EntityTickEvent.Post event) {
        Player p;
        if (event.getEntity().level().isClientSide) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Player && (p = (Player)entity).hasData(Attachments.HAS_STAND) && ((Boolean)p.getData(Attachments.HAS_STAND)).booleanValue() && (Integer)p.getData(Attachments.STAND_ID) == 13 && p.hasData(WeatherReportAttachments.OXYGEN_LEVEL) && StandHandler.getStand((LivingEntity)p).isPresent()) {
            Integer level = (Integer)p.getData(WeatherReportAttachments.OXYGEN_LEVEL);
            if (level == 2) {
                return;
            }
            StandEntity stand = StandHandler.getStand((LivingEntity)p).get();
            AABB bb = stand.getBoundingBox();
            if (bb.getSize() < p.getBoundingBox().getSize()) {
                bb = p.getBoundingBox();
            }
            boolean isFrozen = stand.getServer().tickRateManager().isFrozen();
            stand.level().getEntities(null, bb.inflate(14.0)).forEach(e -> {
                if (e instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)e;
                    if (level == 0) {
                        if (isFrozen) {
                            if (living.hasData(Attachments.TIME_STOP_TICKS_LEFT.get()) && (Integer)living.getData(Attachments.TIME_STOP_TICKS_LEFT.get()) > 1) {
                                living.setAirSupply(living.getAirSupply() - 7);
                            }
                        } else {
                            living.setAirSupply(living.getAirSupply() - 7);
                        }
                    } else if (level == 1) {
                        living.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 120, 0));
                        living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 10, 0));
                    } else if (level == 3) {
                        living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 10, 0));
                    } else if (level == 4 && !living.hasEffect(MobEffects.POISON)) {
                        living.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 0));
                    }
                }
            });
        }
    }
}

