/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.MotsApi.Skills.WeatherReport;

import java.util.ArrayList;
import java.util.Optional;
import net.hrodebert.mots.ModEntities.ModEntities;
import net.hrodebert.mots.ModEntities.custom.StandEntity;
import net.hrodebert.mots.ModEntities.custom.WeatherReport;
import net.hrodebert.mots.ModParticles.ModParticleTypes;
import net.hrodebert.mots.ModSounds.ModSounds;
import net.hrodebert.mots.Mots;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.Skill;
import net.hrodebert.mots.MotsApi.Skills.WeatherReport.WeatherReportAttachments;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.hrodebert.mots.PayLoads.SyncStandData;
import net.hrodebert.mots.ServerQueue.Queue;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class WeatherReportSkill {
    public static void getSkills(LivingEntity entity) {
        StandEntity standEntity;
        ArrayList skills = (ArrayList)entity.getData(Attachments.SKILLS);
        skills.add(new Skill("Manifest / Vanish", 0, false, source -> {
            Optional<StandEntity> stand = StandHandler.getStand(source);
            if (stand.isPresent()) {
                stand.get().discard();
                ((ServerPlayer)source).connection.send((Packet)new ClientboundSetPassengersPacket((Entity)((ServerPlayer)source)));
                StandHandler.syncData(source);
                source.level().playSound(null, source.blockPosition(), ModSounds.WEATHER_OFF.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                return;
            }
            WeatherReport newStand = new WeatherReport(ModEntities.WEATHER_REPORT.get(), source.level());
            newStand.startRiding((Entity)source);
            newStand.moveTo(source.position());
            source.level().addFreshEntity((Entity)newStand);
            source.level().playSound(null, source.blockPosition(), ModSounds.WEATHER_SUMMON.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            if (source instanceof ServerPlayer) {
                ServerPlayer p = (ServerPlayer)source;
                p.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)p));
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(1, task -> PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new SyncStandData((Integer)source.getData(Attachments.STAND_ID), (Integer)source.getData(Attachments.COOLDOWN_TIME_ATTACK), (Integer)source.getData(Attachments.COOLDOWN_TIME_ABILITY), (Integer)source.getData(Attachments.STAMINA), (Integer)source.getData(Attachments.SKILL), (Integer)source.getData(Attachments.MAX_STAMINA)), (CustomPacketPayload[])new CustomPacketPayload[0])));
            }
        }).setIcon(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/ui/summon.png"))));
        Optional<StandEntity> s = StandHandler.getStand(entity);
        if (s.isPresent() && (standEntity = s.get()) instanceof WeatherReport) {
            WeatherReport passenger = (WeatherReport)standEntity;
            skills.add(new Skill("Chop", 2, false, source -> {
                source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> WEATHER!"))));
                passenger.chop();
                StandHandler.applyCooldownAttack(source, 40);
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(10, task -> StandHandler.executeScalableMeleeAttack(source, 2, new Vec3(3.0, 0.25, 3.0), Optional.of(true), Optional.of(4), true).forEach(livingTarget -> source.level().players().forEach(player -> ((ServerLevel)source.level()).sendParticles((ServerPlayer)player, (ParticleOptions)ModParticleTypes.BLOOD_PARTICLE.get(), true, livingTarget.getX(), livingTarget.getEyeY() - 1.0, livingTarget.getZ(), 200, 0.3, 0.3, 0.3, 0.2)))));
            }, ModSounds.WEATHER_CHOP.get()));
            skills.add(new Skill("Finisher", 3, false, source -> {
                source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> Take this!"))));
                passenger.impale();
                StandHandler.applyCooldownAttack(source, 100);
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(15, task -> StandHandler.knockBackEntityList(source, StandHandler.executeScalableMeleeAttack(source, 2, new Vec3(3.0, 0.25, 3.0), Optional.of(false), Optional.empty(), true))));
            }, ModSounds.WEATHER_FINISHER.get()));
            skills.add(new Skill("Wind gust", 5, true, source -> {
                double max = StandHandler.getStandSpecial(source) * 10.0;
                StandHandler.applyCooldownAbility(source, (int)(120.0 + max));
                int i = 0;
                while ((double)i < max) {
                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(i, task -> {
                        if (!source.isCrouching()) {
                            AABB bb = passenger.getBoundingBox();
                            if (bb.getSize() < source.getBoundingBox().getSize()) {
                                bb = source.getBoundingBox();
                            }
                            passenger.level().getEntities((Entity)passenger, bb.inflate(5.0)).forEach(e -> {
                                if (!e.is((Entity)source)) {
                                    double speedX = 0.0;
                                    double speedY = 0.0;
                                    double speedZ = 0.0;
                                    double speed = 0.05;
                                    speedX = e.position().x > passenger.position().x ? speed : -speed;
                                    speedY = e.position().y > passenger.position().y ? speed : -speed;
                                    speedZ = e.position().z > passenger.position().z ? speed : -speed;
                                    e.addDeltaMovement(new Vec3(speedX, speedY, speedZ));
                                    e.hurtMarked = true;
                                }
                            });
                        } else {
                            source.addEffect(new MobEffectInstance(MobEffects.JUMP, 10, 0));
                            source.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 10, 0));
                        }
                    }));
                    source.setData(Attachments.STAND_SPECIAL_POTENCY, (Object)((Double)source.getData(Attachments.STAND_SPECIAL_POTENCY) + 1.0));
                    ++i;
                }
            }, ModSounds.WEATHER_WIND_GUST.get()));
            skills.add(new Skill("Heavy rain", 5, true, source -> {
                int finalI;
                int i;
                double max = StandHandler.getStandSpecial(source) * 10.0;
                StandHandler.applyCooldownAbility(source, (int)(100.0 + max));
                for (i = 0; i < 10; ++i) {
                    finalI = i;
                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(i, task -> entity.level().setRainLevel((float)finalI / 10.0f)));
                }
                i = 0;
                while ((double)i < max) {
                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(i + 10, task -> {
                        entity.level().setRainLevel(1.0f);
                        AABB bb = passenger.getBoundingBox();
                        if (bb.getSize() < source.getBoundingBox().getSize()) {
                            bb = source.getBoundingBox();
                        }
                        passenger.level().getEntities((Entity)passenger, bb.inflate(16.0)).forEach(e -> {
                            if (e.is((Entity)source)) {
                                return;
                            }
                            if (e.isInWaterOrRain() && !(e instanceof ItemEntity) && !(e instanceof ExperienceOrb)) {
                                e.hurt(new DamageSource(e.level().damageSources().mobAttack(source).typeHolder(), e, (Entity)source), 0.01f + StandHandler.getStandPowerModifier(source) / 15.0f);
                            }
                        });
                    }));
                    ++i;
                }
                for (i = 10; i > 0; --i) {
                    finalI = i;
                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(i, task -> entity.level().setRainLevel((float)finalI / 10.0f)));
                }
                source.setData(Attachments.STAND_SPECIAL_POTENCY, (Object)((Double)source.getData(Attachments.STAND_SPECIAL_POTENCY) + 1.0));
            }, ModSounds.WEATHER_HEAVY_RAIN.get()));
            skills.add(new Skill("Oxygen level increase", 0, true, source -> {
                Integer level;
                StandHandler.applyCooldownAbility(source, 40);
                Integer n = level = (Integer)source.getData(WeatherReportAttachments.OXYGEN_LEVEL);
                level = level + 1;
                if (level > 4) {
                    level = 0;
                }
                source.setData(WeatherReportAttachments.OXYGEN_LEVEL, (Object)level);
                if (level == 0) {
                    source.sendSystemMessage((Component)Component.literal((String)"No oxygen in the area, everyone will suffocate!"));
                } else if (level == 1) {
                    source.sendSystemMessage((Component)Component.literal((String)"Small amount of oxygen, everyone is slowed down and gets nausea"));
                } else if (level == 2) {
                    source.sendSystemMessage((Component)Component.literal((String)"Normal amount of oxygen"));
                } else if (level == 3) {
                    source.sendSystemMessage((Component)Component.literal((String)"Beneficial amount of oxygen, everyone will get speed boost!"));
                } else if (level == 4) {
                    source.sendSystemMessage((Component)Component.literal((String)"Huge amount of oxygen, its basically poison!"));
                }
            }));
            skills.add(new Skill("Oxygen level decrease", 0, true, source -> {
                Integer level;
                StandHandler.applyCooldownAbility(source, 40);
                Integer n = level = (Integer)source.getData(WeatherReportAttachments.OXYGEN_LEVEL);
                level = level - 1;
                if (level < 0) {
                    level = 4;
                }
                source.setData(WeatherReportAttachments.OXYGEN_LEVEL, (Object)level);
                if (level == 0) {
                    source.sendSystemMessage((Component)Component.literal((String)"No oxygen in the area, everyone will suffocate!"));
                } else if (level == 1) {
                    source.sendSystemMessage((Component)Component.literal((String)"Small amount of oxygen, everyone is slowed down and gets nausea"));
                } else if (level == 2) {
                    source.sendSystemMessage((Component)Component.literal((String)"Normal amount of oxygen"));
                } else if (level == 3) {
                    source.sendSystemMessage((Component)Component.literal((String)"Beneficial amount of oxygen, everyone will get speed boost!"));
                } else if (level == 4) {
                    source.sendSystemMessage((Component)Component.literal((String)"Huge amount of oxygen, its basically poison!"));
                }
            }));
            return;
        }
    }
}

