/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.MotsApi.Skills;

import java.util.ArrayList;
import java.util.Optional;
import net.hrodebert.mots.ModEntities.ModEntities;
import net.hrodebert.mots.ModEntities.custom.CustomAreaEffectCloud;
import net.hrodebert.mots.ModEntities.custom.StandEntity;
import net.hrodebert.mots.ModEntities.custom.WhiteSnake;
import net.hrodebert.mots.ModItems.DataComponents.Components;
import net.hrodebert.mots.ModItems.DataComponents.StandDiskRecord;
import net.hrodebert.mots.ModItems.ModItems;
import net.hrodebert.mots.ModSounds.ModSounds;
import net.hrodebert.mots.Mots;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.Skill;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.hrodebert.mots.PayLoads.SyncStandData;
import net.hrodebert.mots.ServerQueue.Queue;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class WhiteSnakeSkill {
    public static void getSkills(LivingEntity entity) {
        ArrayList skills = (ArrayList)entity.getData(Attachments.SKILLS);
        skills.add(new Skill("Manifest / Vanish", 0, false, source -> {
            Optional<StandEntity> stand = StandHandler.getStand(source);
            if (stand.isPresent()) {
                stand.get().discard();
                ((ServerPlayer)source).connection.send((Packet)new ClientboundSetPassengersPacket((Entity)source));
                StandHandler.syncData(source);
                source.level().playSound(null, source.blockPosition(), ModSounds.WS_OFF.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                return;
            }
            WhiteSnake newStand = new WhiteSnake(ModEntities.WHITE_SNAKE.get(), source.level());
            newStand.startRiding((Entity)source);
            newStand.moveTo(source.position());
            source.level().addFreshEntity((Entity)newStand);
            source.level().playSound(null, source.blockPosition(), ModSounds.WS_SUMMON.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            if (source instanceof ServerPlayer) {
                ServerPlayer p = (ServerPlayer)source;
                p.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)source));
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(1, task -> PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new SyncStandData((Integer)source.getData(Attachments.STAND_ID), (Integer)source.getData(Attachments.COOLDOWN_TIME_ATTACK), (Integer)source.getData(Attachments.COOLDOWN_TIME_ABILITY), (Integer)source.getData(Attachments.STAMINA), (Integer)source.getData(Attachments.SKILL), (Integer)source.getData(Attachments.MAX_STAMINA)), (CustomPacketPayload[])new CustomPacketPayload[0])));
            }
        }).setIcon(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/ui/summon.png"))));
        Optional<StandEntity> s = StandHandler.getStand(entity);
        if (s.isPresent()) {
            StandEntity standEntity = s.get();
            if (standEntity instanceof WhiteSnake) {
                WhiteSnake passenger = (WhiteSnake)standEntity;
                skills.add(new Skill("Finisher", 3, false, source -> {
                    try {
                        passenger.triggerAnim("controller", "Power punch");
                        StandHandler.applyCooldownAttack(source, 20);
                        StandHandler.knockBackEntityList(source, StandHandler.executeScalableMeleeAttack(source, 3, new Vec3(4.0, 2.0, 4.0), Optional.of(false), Optional.of(0), true));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }, ModSounds.WS_CHOP.get()));
                skills.add(new Skill("Barrage", 3, false, source -> {
                    try {
                        passenger.triggerAnim("controller", "barrage");
                        Double damage = 7.0;
                        damage = damage + (double)StandHandler.getStandPowerModifier(source);
                        Double finalDamage = damage / 30.0;
                        StandHandler.applyCooldownAttack(source, 20);
                        source.setData(Attachments.STAND_ATTACK_POTENCY, (Object)((Double)source.getData(Attachments.STAND_ATTACK_POTENCY) + 0.1));
                        for (int i = 0; i < 98; ++i) {
                            if (i % 2 == 0) {
                                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(i + 5, task -> {
                                    StandHandler.applyCooldownAbility(source, 1);
                                    StandHandler.applyCooldownAttack(source, 20);
                                    StandHandler.executeMeleAttack(source, Float.valueOf(finalDamage.floatValue()), new Vec3(2.0, 0.25, 2.0), Optional.of(true), Optional.of(3), true);
                                }));
                                continue;
                            }
                            Mots.serverTaskExecutioner.tasks.add(new Queue.Task(i + 5, task -> {
                                StandHandler.applyCooldownAbility(source, 1);
                                StandHandler.applyCooldownAttack(source, 20);
                                StandHandler.executeMeleAttack(source, null, new Vec3(2.0, 0.25, 2.0), Optional.of(true), Optional.of(3), true);
                            }));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }));
                skills.add(new Skill("Spit", 2, true, source -> {
                    passenger.triggerAnim("controller", "spit");
                    StandHandler.applyCooldownAbility(source, 5);
                    StandHandler.executeMeleAttack(source, Float.valueOf(2.0f), new Vec3(5.0, 2.0, 5.0), Optional.of(true), Optional.of(6), false).forEach(entity1 -> {
                        if (entity.equals(source) || entity1.equals((Object)passenger)) {
                            return;
                        }
                        if (entity1 instanceof LivingEntity) {
                            LivingEntity living = (LivingEntity)entity1;
                            living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 120, 2));
                            living.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 120, 2));
                            living.addEffect(new MobEffectInstance(MobEffects.POISON, 120, 2));
                        }
                    });
                }));
                skills.add(new Skill("Toxine release", 3, true, source -> {
                    StandHandler.applyCooldownAbility(source, 5);
                    passenger.triggerAnim("controller", "illusion_mist");
                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(10, task -> {
                        CustomAreaEffectCloud areaeffectcloud = new CustomAreaEffectCloud(source.level(), passenger.getX(), passenger.getY(), passenger.getZ());
                        areaeffectcloud.setOwner((LivingEntity)source);
                        areaeffectcloud.setParticle((ParticleOptions)ParticleTypes.WHITE_SMOKE);
                        areaeffectcloud.setRadius(4.0f);
                        areaeffectcloud.setDuration(300);
                        areaeffectcloud.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 5));
                        areaeffectcloud.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 60, 1));
                        areaeffectcloud.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 60, 1));
                        areaeffectcloud.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 60, 1));
                        source.level().addFreshEntity((Entity)areaeffectcloud);
                    }));
                }));
                skills.add(new Skill("Remove memory disk", 4, true, source -> {
                    StandHandler.applyCooldownAbility(source, 10);
                    passenger.triggerAnim("controller", "disk removal");
                    source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> Your memory is mine!"))));
                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(15, t -> StandHandler.executeMeleAttack(source, Float.valueOf(2.0f), new Vec3(2.5, 2.0, 2.5), Optional.empty(), Optional.empty(), false).forEach(entity1 -> {
                        if (entity1 instanceof LivingEntity) {
                            LivingEntity living = (LivingEntity)entity1;
                            Brain brain = living.getBrain();
                            brain.clearMemories();
                        }
                        if (entity1 instanceof Mob) {
                            Mob mob = (Mob)entity1;
                            mob.goalSelector.removeAllGoals(filter -> true);
                        }
                    })));
                }, ModSounds.WS_DISK_REMOVAL.get()));
                skills.add(new Skill("Remove stand disk", 6, true, source -> {
                    StandHandler.applyCooldownAbility(source, 10);
                    passenger.triggerAnim("controller", "disk removal");
                    source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> Your stand is mine!"))));
                    Mots.serverTaskExecutioner2.tasks.add(new Queue.Task(15, t -> StandHandler.executeMeleAttack(source, Float.valueOf(4.0f), new Vec3(2.5, 2.0, 2.5), Optional.empty(), Optional.empty(), false).forEach(entity1 -> {
                        if (!entity1.isAlive() && entity1.hasData(Attachments.HAS_STAND) && ((Boolean)entity1.getData(Attachments.HAS_STAND)).booleanValue()) {
                            ItemStack stack = new ItemStack((ItemLike)ModItems.STAND_DISK.get());
                            Entity target = entity1;
                            stack.set(Components.STAND_DISK, (Object)new StandDiskRecord((Integer)target.getData(Attachments.STAND_ID), ((Integer)target.getData(Attachments.MAX_STAMINA)).intValue(), (Double)target.getData(Attachments.STAND_ATTACK_POTENCY), (Double)target.getData(Attachments.STAND_SPECIAL_POTENCY), (Double)target.getData(Attachments.DAMAGE_RESISTANCE), (Integer)target.getData(Attachments.STAND_REBIRTH)));
                            entity1.setData(Attachments.STAND_ID, (Object)0);
                            entity1.setData(Attachments.STAND_REBIRTH, (Object)0);
                            entity1.setData(Attachments.DAMAGE_RESISTANCE.get(), (Object)0.0);
                            entity1.getPassengers().forEach(p -> p.stopRiding());
                            entity1.setData(Attachments.HAS_STAND, (Object)false);
                            if (entity1 instanceof ServerPlayer) {
                                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)entity1), (CustomPacketPayload)new SyncStandData(0, 0, 0, 0, 0, (Integer)entity1.getData(Attachments.MAX_STAMINA)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            }
                            ((Player)source).getInventory().add(stack);
                        }
                    })));
                }, ModSounds.WS_DISK_REMOVAL.get()));
            }
            return;
        }
    }
}

