/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.MotsApi.Skills.WonderOfYou;

import java.util.Optional;
import java.util.UUID;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.Events.OnStandTimedAbilityEvent;
import net.hrodebert.mots.MotsApi.Skills.WonderOfYou.WouAttachments;
import net.hrodebert.mots.MotsApi.Skills.WonderOfYou.WouSkills;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

public class WouEvents {
    public static void onTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            if (p.hasData(Attachments.HAS_STAND) && ((Boolean)p.getData(Attachments.HAS_STAND)).booleanValue() && (Integer)p.getData(Attachments.STAND_ID) == 10 && p.level().getServer() != null) {
                try {
                    p.level().getServer().getAllLevels().forEach(level -> level.getEntities().getAll().forEach(entry -> {
                        Targeting m;
                        Optional uuid_attacker = (Optional)p.getData(WouAttachments.UUID_ATTACKER);
                        boolean shouldExecute = false;
                        if (entry instanceof Targeting && (m = (Targeting)entry).getTarget() != null) {
                            if (m.getTarget().is((Entity)p)) {
                                shouldExecute = true;
                            }
                            if (StandHandler.getStand((LivingEntity)p).isPresent() && m.getTarget().is((Entity)StandHandler.getStand((LivingEntity)p).get())) {
                                shouldExecute = true;
                            }
                        }
                        if (uuid_attacker.isPresent() && ((UUID)uuid_attacker.get()).equals(entry.getUUID())) {
                            shouldExecute = true;
                        }
                        if (shouldExecute && entry.isInWaterOrRain() && entry != null) {
                            entry.hurt(new DamageSource(entry.level().damageSources().mobAttack((LivingEntity)p).typeHolder(), entry, (Entity)p), 0.01f + StandHandler.getStandPowerModifier((LivingEntity)p) / 15.0f);
                        }
                    }));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (p.hasData(WouAttachments.COUNTER_TIME) && (Double)p.getData(WouAttachments.COUNTER_TIME) > 0.0) {
                p.setData(WouAttachments.COUNTER_TIME, (Object)((Double)p.getData(WouAttachments.COUNTER_TIME) - 1.0));
                p.setData(Attachments.COOLDOWN_TIME_ABILITY, (Object)((Integer)p.getData(Attachments.COOLDOWN_TIME_ABILITY) + 1));
                if ((Double)p.getData(WouAttachments.COUNTER_TIME) <= 0.0 && event.getEntity() instanceof LivingEntity) {
                    OnStandTimedAbilityEvent.Post eventPost = new OnStandTimedAbilityEvent.Post(20, new WouSkills.WouCounter());
                    eventPost.source = (LivingEntity)event.getEntity();
                    NeoForge.EVENT_BUS.post((Event)eventPost);
                }
            }
        }
    }

    public static void livingHurtEvent(LivingDamageEvent.Pre dmg) {
        Player p;
        LivingEntity livingEntity = dmg.getEntity();
        if (livingEntity instanceof Player && (p = (Player)livingEntity).hasData(WouAttachments.COUNTER_TIME) && (Double)p.getData(WouAttachments.COUNTER_TIME) > 0.0 && dmg.getSource().getEntity() != null) {
            if ((Integer)p.getData(Attachments.STAMINA) < (Integer)p.getData(Attachments.MAX_STAMINA)) {
                p.setData(Attachments.STAMINA, (Object)Math.min((Integer)p.getData(Attachments.STAMINA) + (int)(dmg.getOriginalDamage() / 4.0f) + 1, 5));
            }
            dmg.setNewDamage(0.0f);
            p.setData(WouAttachments.UUID_ATTACKER, Optional.of(dmg.getSource().getEntity().getUUID()));
            p.setData(WouAttachments.COUNTER_TIME, (Object)((Double)p.getData(WouAttachments.COUNTER_TIME) - 1.0));
            OnStandTimedAbilityEvent.Post eventPost = new OnStandTimedAbilityEvent.Post(20, new WouSkills.WouCounter());
            eventPost.source = p;
            NeoForge.EVENT_BUS.post((Event)eventPost);
        }
    }
}

