/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.MotsApi.Skills.WonderOfYou;

import java.util.ArrayList;
import java.util.Optional;
import net.hrodebert.mots.ModEntities.ModEntities;
import net.hrodebert.mots.ModEntities.custom.StandEntity;
import net.hrodebert.mots.ModEntities.custom.WonderOfYou;
import net.hrodebert.mots.ModSounds.ModSounds;
import net.hrodebert.mots.Mots;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.Events.OnStandTimedAbilityEvent;
import net.hrodebert.mots.MotsApi.Skill;
import net.hrodebert.mots.MotsApi.Skills.WonderOfYou.WouAttachments;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.hrodebert.mots.PayLoads.SyncStandData;
import net.hrodebert.mots.ServerQueue.Queue;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class WouSkills {
    public static void getSkills(LivingEntity entity) {
        StandEntity passenger;
        ArrayList skills = (ArrayList)entity.getData(Attachments.SKILLS);
        skills.add(new Skill("Manifest / Vanish", 0, false, source -> {
            Optional<StandEntity> stand = StandHandler.getStand(source);
            if (stand.isPresent()) {
                stand.get().discard();
                ((ServerPlayer)source).connection.send((Packet)new ClientboundSetPassengersPacket((Entity)((ServerPlayer)source)));
                StandHandler.syncData(source);
                return;
            }
            WonderOfYou standNew = new WonderOfYou(ModEntities.WONDER_OF_YOU.get(), source.level());
            standNew.startRiding((Entity)source);
            source.level().playSound(null, source.blockPosition(), ModSounds.WOU_SUMMON.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            standNew.moveTo(source.position());
            source.level().addFreshEntity((Entity)standNew);
            if (source instanceof ServerPlayer) {
                ServerPlayer p = (ServerPlayer)source;
                p.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)p));
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(1, task -> PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new SyncStandData((Integer)source.getData(Attachments.STAND_ID), (Integer)source.getData(Attachments.COOLDOWN_TIME_ATTACK), (Integer)source.getData(Attachments.COOLDOWN_TIME_ABILITY), (Integer)source.getData(Attachments.STAMINA), (Integer)source.getData(Attachments.SKILL), (Integer)source.getData(Attachments.MAX_STAMINA)), (CustomPacketPayload[])new CustomPacketPayload[0])));
            }
        }).setIcon(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/ui/summon.png"))));
        Optional<StandEntity> s = StandHandler.getStand(entity);
        if (s.isPresent() && (passenger = s.get()) instanceof WonderOfYou) {
            skills.add(new Skill("Calamity: Counter", 0, true, source -> {
                source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> You're here to pursue me, aren't you?"))));
                source.setData(WouAttachments.COUNTER_TIME, (Object)20.0);
                StandHandler.applyCooldownAbility(source, 200);
            }, ModSounds.WOU_COUNTER.get()));
            skills.add(new Skill("Calamity: Projectile", 1, false, source -> {
                Optional uuid_attacker = (Optional)source.getData(WouAttachments.UUID_ATTACKER);
                source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> Something's coming in!"))));
                source.setInvulnerable(true);
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(40, task -> source.setInvulnerable(false)));
                source.level().getServer().getAllLevels().forEach(level -> level.getEntities().getAll().forEach(entry -> {
                    Targeting m;
                    boolean shouldExecute = false;
                    if (entry instanceof Targeting && (m = (Targeting)entry).getTarget() != null) {
                        if (m.getTarget().is((Entity)source)) {
                            shouldExecute = true;
                        }
                        if (StandHandler.getStand(source).isPresent() && m.getTarget().is((Entity)StandHandler.getStand(source).get())) {
                            shouldExecute = true;
                        }
                    }
                    if (uuid_attacker.isPresent() && entry.getUUID().equals(uuid_attacker.get())) {
                        shouldExecute = true;
                    }
                    if (shouldExecute) {
                        entity.level().getEntities((Entity)entity, entity.getBoundingBox().inflate(20.0)).forEach(arrow -> {
                            int i;
                            if (arrow instanceof AbstractArrow) {
                                AbstractArrow a = (AbstractArrow)arrow;
                                a.setNoPhysics(true);
                                for (i = 0; i < 60; ++i) {
                                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(i, task -> {
                                        if (task == 1) {
                                            a.setNoPhysics(false);
                                        }
                                        a.lookAt(EntityAnchorArgument.Anchor.EYES, entry.getEyePosition());
                                        a.hurtMarked = true;
                                        a.setDeltaMovement(a.getLookAngle());
                                        a.hurtMarked = true;
                                    }));
                                }
                            }
                            if (arrow instanceof PrimedTnt) {
                                PrimedTnt tnt = (PrimedTnt)arrow;
                                for (i = 0; i < 60; ++i) {
                                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(i, task -> {
                                        tnt.lookAt(EntityAnchorArgument.Anchor.EYES, entry.getEyePosition());
                                        tnt.hurtMarked = true;
                                        tnt.setDeltaMovement(tnt.getLookAngle());
                                        tnt.hurtMarked = true;
                                    }));
                                }
                            }
                        });
                    }
                }));
                StandHandler.applyCooldownAttack(source, 100);
            }, ModSounds.WOU_ARROW.get()));
            skills.add(new Skill("Calamity: Creeper", 2, false, source -> {
                source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> Ob-La-Di, Ob-La-Da."))));
                source.setInvulnerable(true);
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(40, task -> source.setInvulnerable(false)));
                Optional uuid_attacker = (Optional)source.getData(WouAttachments.UUID_ATTACKER);
                source.level().getServer().getAllLevels().forEach(level -> level.getEntities().getAll().forEach(entry -> {
                    Targeting m;
                    boolean shouldExecute = false;
                    if (entry instanceof Targeting && (m = (Targeting)entry).getTarget() != null) {
                        if (m.getTarget().is((Entity)source)) {
                            shouldExecute = true;
                        }
                        if (StandHandler.getStand(source).isPresent() && m.getTarget().is((Entity)StandHandler.getStand(source).get())) {
                            shouldExecute = true;
                        }
                    }
                    if (uuid_attacker.isPresent() && entry.getUUID().equals(uuid_attacker.get())) {
                        shouldExecute = true;
                    }
                    if (shouldExecute) {
                        Creeper creeper = new Creeper(EntityType.CREEPER, (Level)level);
                        creeper.teleportTo(entry.position().x, entry.position().y, entry.position().z);
                        creeper.setTarget(entity);
                        creeper.ignite();
                        level.addFreshEntity((Entity)creeper);
                    }
                }));
                StandHandler.applyCooldownAttack(source, 100);
            }, ModSounds.WOU_CREEPER.get()));
            skills.add(new Skill("Calamity: Rain", 3, false, source -> {
                source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> It's best to prioritize safety"))));
                Optional uuid_attacker = (Optional)source.getData(WouAttachments.UUID_ATTACKER);
                source.level().getServer().getAllLevels().forEach(level -> level.getEntities().getAll().forEach(entry -> {
                    Targeting m;
                    boolean shouldExecute = false;
                    if (entry instanceof Targeting && (m = (Targeting)entry).getTarget() != null) {
                        if (m.getTarget().is((Entity)source)) {
                            shouldExecute = true;
                        }
                        if (StandHandler.getStand(source).isPresent() && m.getTarget().is((Entity)StandHandler.getStand(source).get())) {
                            shouldExecute = true;
                        }
                    }
                    if (uuid_attacker.isPresent() && entry.getUUID().equals(uuid_attacker.get())) {
                        shouldExecute = true;
                    }
                    if (shouldExecute) {
                        int finalI;
                        int i;
                        for (i = 0; i < 10; ++i) {
                            finalI = i;
                            Mots.serverTaskExecutioner.tasks.add(new Queue.Task(i, task -> entity.level().setRainLevel((float)finalI / 10.0f)));
                        }
                        i = 0;
                        while ((double)i < StandHandler.getStandSpecial(source) + 20.0) {
                            Mots.serverTaskExecutioner.tasks.add(new Queue.Task(i + 10, task -> entity.level().setRainLevel(1.0f)));
                            ++i;
                        }
                        for (i = 10; i > 0; --i) {
                            finalI = i;
                            Mots.serverTaskExecutioner.tasks.add(new Queue.Task(i, task -> entity.level().setRainLevel((float)finalI / 10.0f)));
                        }
                        source.setData(Attachments.STAND_SPECIAL_POTENCY, (Object)((Double)source.getData(Attachments.STAND_SPECIAL_POTENCY) + 1.0));
                        source.setData(Attachments.STAND_ATTACK_POTENCY, (Object)((Double)source.getData(Attachments.STAND_ATTACK_POTENCY) + 1.0));
                    }
                }));
                StandHandler.applyCooldownAttack(source, 100);
            }, ModSounds.WOU_RAIN.get()));
            skills.add(new Skill("Calamity: Hearth failure", 5, false, source -> {
                Optional uuid_attacker = (Optional)source.getData(WouAttachments.UUID_ATTACKER);
                source.getServer().getPlayerList().getPlayers().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("<" + source.getDisplayName().getString() + "> The flow of calamity is coming for you."))));
                source.level().getServer().getAllLevels().forEach(level -> level.getEntities().getAll().forEach(entry -> {
                    Targeting m;
                    boolean shouldExecute = false;
                    if (entry instanceof Targeting && (m = (Targeting)entry).getTarget() != null) {
                        if (m.getTarget().is((Entity)source)) {
                            shouldExecute = true;
                        }
                        if (StandHandler.getStand(source).isPresent() && m.getTarget().is((Entity)StandHandler.getStand(source).get())) {
                            shouldExecute = true;
                        }
                    }
                    if (uuid_attacker.isPresent() && entry.getUUID().equals(uuid_attacker.get())) {
                        shouldExecute = true;
                    }
                    if (shouldExecute && entry instanceof LivingEntity) {
                        LivingEntity l = (LivingEntity)entry;
                        l.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60));
                        entry.hurt(new DamageSource(entry.level().damageSources().mobAttack(source).typeHolder(), entry, (Entity)source), ((LivingEntity)entry).getMaxHealth() / 3.0f);
                    }
                }));
                StandHandler.applyCooldownAttack(source, 140);
            }, ModSounds.WOU_HEARTH_FAILURE.get()));
        }
    }

    public static class WouCounter
    extends OnStandTimedAbilityEvent.AbilityType {
        @Override
        public ResourceLocation getAbilityType() {
            return ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"wou_counter");
        }
    }
}

