/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.MotsApi;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.hrodebert.mots.GameRules.ModGameRules;
import net.hrodebert.mots.ModEntities.custom.StandEntity;
import net.hrodebert.mots.ModSounds.ModSounds;
import net.hrodebert.mots.Mots;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.Events.OnAbilityUsage;
import net.hrodebert.mots.MotsApi.Events.OnCoolDownApplyAbility;
import net.hrodebert.mots.MotsApi.Events.OnCoolDownApplyAttack;
import net.hrodebert.mots.MotsApi.Events.RegisterSkills;
import net.hrodebert.mots.MotsApi.Skill;
import net.hrodebert.mots.MotsApi.Skills.Cmoon.CmoonSkills;
import net.hrodebert.mots.MotsApi.Skills.CrazyDiamond.CrazyDiamondSkills;
import net.hrodebert.mots.MotsApi.Skills.CrazyDiamond.CrazyDiamondsAttachments;
import net.hrodebert.mots.MotsApi.Skills.D4cSkills;
import net.hrodebert.mots.MotsApi.Skills.DiverDownSkills.DiverDownSkill;
import net.hrodebert.mots.MotsApi.Skills.GoldenExperience.GoldenExperienceSkills;
import net.hrodebert.mots.MotsApi.Skills.KillerQueenSkill;
import net.hrodebert.mots.MotsApi.Skills.KingCrimson.KingCrimsonAttachments;
import net.hrodebert.mots.MotsApi.Skills.KingCrimson.KingCrimsonSkills;
import net.hrodebert.mots.MotsApi.Skills.MadeInHeavenSkills.MadeInHeavenSkills;
import net.hrodebert.mots.MotsApi.Skills.SoftAndWet.SoftAndWetAttachments;
import net.hrodebert.mots.MotsApi.Skills.SoftAndWet.SoftAndWetSkills;
import net.hrodebert.mots.MotsApi.Skills.SpinSkills;
import net.hrodebert.mots.MotsApi.Skills.TheWorld.TwSkills;
import net.hrodebert.mots.MotsApi.Skills.TuskSkills.TuskSkills;
import net.hrodebert.mots.MotsApi.Skills.Vampirism.VampirismAttachments;
import net.hrodebert.mots.MotsApi.Skills.Vampirism.VampirismSkills;
import net.hrodebert.mots.MotsApi.Skills.WeatherReport.WeatherReportSkill;
import net.hrodebert.mots.MotsApi.Skills.WhiteSnakeSkill;
import net.hrodebert.mots.MotsApi.Skills.WonderOfYou.WouSkills;
import net.hrodebert.mots.MotsApi.Trait;
import net.hrodebert.mots.PayLoads.ChangeFriction;
import net.hrodebert.mots.PayLoads.SyncRebirths;
import net.hrodebert.mots.PayLoads.SyncStandData;
import net.hrodebert.mots.PayLoads.SyncVampireData;
import net.hrodebert.mots.ServerQueue.Queue;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.bossevents.CustomBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;

public class StandHandler {
    private static final ResourceLocation ABILITY_ICON_SPIN = ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/ui/spin.png");
    public Vec3 pos1 = new Vec3(0.0, 0.0, 0.0);
    String pilot_dim = null;

    public static Entity getEntityUserIsLookingAt(LivingEntity user, int range) {
        Vec3 view = user.getViewVector(1.0f);
        for (int i = 0; i < range * 5; ++i) {
            if (i != 0) {
                view = view.add(view.multiply((double)0.2f, (double)0.2f, (double)0.2f));
            }
            List list = user.level().getEntities((Entity)user, AABB.ofSize((Vec3)user.getEyePosition().add(view), (double)0.2, (double)0.2, (double)0.2));
            for (int j = 0; j < list.size(); ++j) {
                Optional<StandEntity> stand;
                Entity entity = (Entity)list.get(j);
                if (entity instanceof StandEntity && (stand = StandHandler.getStand(user)).isPresent() && stand.get().equals(entity)) continue;
                return entity;
            }
        }
        return null;
    }

    public static Vec3 getBlockPlayerIslookingAt(LivingEntity user, int range) {
        Vec3 view = user.getViewVector(1.0f);
        for (int i = 0; i < range * 5; ++i) {
            if (i != 0) {
                view = view.add(view.multiply((double)0.2f, (double)0.2f, (double)0.2f));
            }
            Vec3 pos = user.getEyePosition().add(view);
            if (user.level().getBlockState(BlockPos.containing((Position)pos)).getBlock().defaultBlockState().isAir()) continue;
            return pos;
        }
        return null;
    }

    public static boolean applyCooldownAttack(LivingEntity target, Integer amount) {
        OnCoolDownApplyAttack.Pre eventPre = new OnCoolDownApplyAttack.Pre(target, amount);
        OnCoolDownApplyAttack.Pre result = (OnCoolDownApplyAttack.Pre)NeoForge.EVENT_BUS.post((Event)eventPre);
        if (result.isCanceled()) {
            return false;
        }
        target.setData(Attachments.COOLDOWN_TIME_ATTACK.get(), (Object)result.amount);
        OnCoolDownApplyAttack.Post eventPost = new OnCoolDownApplyAttack.Post(result.source, result.amount);
        NeoForge.EVENT_BUS.post((Event)eventPost);
        StandHandler.syncData(target);
        return true;
    }

    public static boolean applyCooldownAbility(LivingEntity target, Integer amount) {
        OnCoolDownApplyAbility.Pre eventPre = new OnCoolDownApplyAbility.Pre(target, amount);
        OnCoolDownApplyAbility.Pre result = (OnCoolDownApplyAbility.Pre)NeoForge.EVENT_BUS.post((Event)eventPre);
        if (result.isCanceled()) {
            return false;
        }
        target.setData(Attachments.COOLDOWN_TIME_ABILITY.get(), (Object)result.amount);
        OnCoolDownApplyAbility.Post eventPost = new OnCoolDownApplyAbility.Post(result.source, result.amount);
        NeoForge.EVENT_BUS.post((Event)eventPost);
        StandHandler.syncData(target);
        return true;
    }

    public static boolean canSeeStands(LivingEntity p) {
        return p.hasData(Attachments.HAS_STAND) && (Boolean)p.getData(Attachments.HAS_STAND) != false;
    }

    public static void knockBackEntityList(LivingEntity entity, List<Entity> targets) {
        Vec3 vec = entity.getViewVector(1.0f);
        targets.forEach(target -> {
            StandEntity s;
            if (target instanceof StandEntity && (s = (StandEntity)((Object)target)).getUser() != null && s.getUser().equals((Object)entity)) {
                return;
            }
            target.setDeltaMovement(new Vec3(vec.x * 2.0, 1.0, vec.z * 2.0));
        });
    }

    public static void registerSkills(LivingEntity player) {
        RegisterSkills.Pre eventPre = new RegisterSkills.Pre(player);
        RegisterSkills.Pre result = (RegisterSkills.Pre)NeoForge.EVENT_BUS.post((Event)eventPre);
        if (result.isCanceled()) {
            return;
        }
        if (!player.hasData(Attachments.STAND_MODE)) {
            player.setData(Attachments.STAND_MODE, (Object)true);
        }
        if (((Boolean)player.getData(Attachments.STAND_MODE)).booleanValue()) {
            player.setData(Attachments.SPIN_SKILLS, new ArrayList());
            if (player.hasData(Attachments.STAND_ID) && player.hasData(Attachments.HAS_STAND) && ((Boolean)player.getData(Attachments.HAS_STAND)).booleanValue()) {
                player.setData(Attachments.SKILLS, new ArrayList());
                int id = (Integer)player.getData(Attachments.STAND_ID);
                if (id == 1) {
                    D4cSkills.getSkills(player);
                } else if (id == 2 || id == 7) {
                    WhiteSnakeSkill.getSkills(player);
                    if (id == 7) {
                        ((ArrayList)player.getData(Attachments.SKILLS)).add(new Skill("Evolve", 0, false, source -> {
                            if (source.level().dimension().equals(Level.END)) {
                                source.setData(Attachments.STAND_ID, (Object)8);
                                source.getPassengers().forEach(Entity::stopRiding);
                                StandHandler.syncData(source);
                                if (source instanceof ServerPlayer) {
                                    ServerPlayer serverPlayer = (ServerPlayer)source;
                                    StandHandler.givePlayerStandAdvancement(serverPlayer);
                                }
                            }
                        }));
                    }
                } else if (id == 3) {
                    KillerQueenSkill.getSkills(player);
                } else if (id == 4) {
                    TwSkills.getSkills(player);
                } else if (id == 5) {
                    new KingCrimsonSkills().getSkills(player);
                } else if (id == 8) {
                    CmoonSkills.getSkills(player);
                    int phase = player.level().getMoonPhase();
                    if (player.level().getBiome(player.blockPosition()).getKey().equals(Biomes.FOREST) && phase == 4) {
                        ((ArrayList)player.getData(Attachments.SKILLS)).add(new Skill("Evolve", 0, false, source -> {
                            source.setData(Attachments.STAND_ID, (Object)9);
                            source.setData(Attachments.MAX_STAMINA, (Object)20);
                            source.getPassengers().forEach(Entity::stopRiding);
                            StandHandler.syncData(source);
                            if (source instanceof ServerPlayer) {
                                ServerPlayer serverPlayer = (ServerPlayer)source;
                                StandHandler.givePlayerStandAdvancement(serverPlayer);
                            }
                        }));
                    }
                } else if (id == 6) {
                    ((ArrayList)player.getData(Attachments.SKILLS)).add(new Skill("", 0, false, c -> {}));
                } else if (id == 9) {
                    MadeInHeavenSkills.getSkills(player);
                } else if (id == 10) {
                    WouSkills.getSkills(player);
                } else if (id == 11) {
                    CrazyDiamondSkills.getSkills(player);
                } else if (id == 12) {
                    DiverDownSkill.getSkills(player);
                } else if (id == 13) {
                    WeatherReportSkill.getSkills(player);
                } else if (id == 14) {
                    SoftAndWetSkills.getSkills(player);
                } else if (id == 15) {
                    TuskSkills.getSkills(player);
                } else if (id == 16) {
                    GoldenExperienceSkills.getSkills(player);
                }
            }
        } else {
            player.setData(Attachments.SPIN_SKILLS.get(), new ArrayList());
            player.setData(Attachments.SKILLS, new ArrayList());
            if (((Boolean)player.getData(VampirismAttachments.IS_VAMPIRE)).booleanValue()) {
                VampirismSkills.getSkills(player);
            } else if (player.hasData(Attachments.SPIN_AMOUNT.get()) && (Double)player.getData(Attachments.SPIN_AMOUNT) > 0.5) {
                SpinSkills.getSkills(player);
            }
            if (player instanceof ServerPlayer) {
                StandHandler.syncVampireData((ServerPlayer)player);
            }
        }
        RegisterSkills.Post eventPost = new RegisterSkills.Post(player);
        NeoForge.EVENT_BUS.post((Event)eventPost);
    }

    public static void syncVampireData(ServerPlayer player) {
        if (!player.hasData(VampirismAttachments.IS_VAMPIRE)) {
            player.setData(VampirismAttachments.IS_VAMPIRE, (Object)false);
        }
        if (!player.hasData(VampirismAttachments.BLOOD_COUNT)) {
            player.setData(VampirismAttachments.BLOOD_COUNT, (Object)0.0);
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncVampireData((Boolean)player.getData(VampirismAttachments.IS_VAMPIRE), (Double)player.getData(Attachments.SPIN_AMOUNT)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void syncData(LivingEntity source) {
        if (source instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)source;
            if ((Integer)source.getData(Attachments.SKILL) == -1) {
                PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new SyncStandData((Integer)source.getData(Attachments.STAND_ID), (Integer)source.getData(Attachments.COOLDOWN_TIME_ATTACK), (Integer)source.getData(Attachments.COOLDOWN_TIME_ABILITY), (Integer)source.getData(Attachments.STAMINA), -1, (Integer)source.getData(Attachments.MAX_STAMINA)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return;
            }
            PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new SyncStandData((Integer)source.getData(Attachments.STAND_ID), (Integer)source.getData(Attachments.COOLDOWN_TIME_ATTACK), (Integer)source.getData(Attachments.COOLDOWN_TIME_ABILITY), (Integer)source.getData(Attachments.STAMINA), 0, (Integer)source.getData(Attachments.MAX_STAMINA)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new ChangeFriction((Boolean)source.getData(SoftAndWetAttachments.NO_FRICTION)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new SyncRebirths((Integer)source.getData(Attachments.STAND_REBIRTH)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void executeSkill(LivingEntity e) {
        try {
            if (e.hasData(Attachments.SKILLS)) {
                ArrayList skills = new ArrayList((Collection)e.getData(Attachments.SKILLS));
                if (e.hasData(Attachments.SPIN_SKILLS)) {
                    ((ArrayList)e.getData(Attachments.SPIN_SKILLS)).forEach(skill -> skills.add(skill));
                }
                if (skills.size() > (Integer)e.getData(Attachments.SKILL)) {
                    StandHandler.registerSkills(e);
                    if (e.hasData(KingCrimsonAttachments.TIME_ERASE) && !((Skill)skills.get((int)((Integer)e.getData(Attachments.SKILL)).intValue())).isSpecial.booleanValue() && ((Boolean)e.getData(KingCrimsonAttachments.TIME_ERASE)).booleanValue()) {
                        return;
                    }
                    if (!((Boolean)e.getData(Attachments.STAND_MODE)).booleanValue() || ((Skill)skills.get((int)((Integer)e.getData(Attachments.SKILL)).intValue())).cost <= (Integer)e.getData(Attachments.STAMINA)) {
                        Skill skill2 = (Skill)skills.get((Integer)e.getData(Attachments.SKILL));
                        if (skill2.isSpecial != false ? (Integer)e.getData(Attachments.COOLDOWN_TIME_ABILITY) > 0 : (Integer)e.getData(Attachments.COOLDOWN_TIME_ATTACK) > 0) {
                            return;
                        }
                        OnAbilityUsage.Pre eventPre = new OnAbilityUsage.Pre(e, skill2);
                        OnAbilityUsage.Pre result = (OnAbilityUsage.Pre)NeoForge.EVENT_BUS.post((Event)eventPre);
                        if (result.isCanceled()) {
                            return;
                        }
                        if (!skill2.holdable) {
                            e.setData(Attachments.COOLDOWN_TIME_ABILITY, (Object)((Integer)e.getData(Attachments.COOLDOWN_TIME_ABILITY) + 7));
                            e.setData(Attachments.COOLDOWN_TIME_ATTACK, (Object)((Integer)e.getData(Attachments.COOLDOWN_TIME_ATTACK) + 7));
                        }
                        result.getSkill().executeSkill.accept(e);
                        if (((Boolean)e.getData(Attachments.STAND_MODE)).booleanValue()) {
                            e.setData(Attachments.STAMINA, (Object)((Integer)e.getData(Attachments.STAMINA) - skill2.cost));
                        }
                        OnAbilityUsage.Post eventPost = new OnAbilityUsage.Post(e, result.getSkill());
                        NeoForge.EVENT_BUS.post((Event)eventPost);
                    } else {
                        e.sendSystemMessage((Component)Component.literal((String)"You dont have enough stamina to execute this action").withStyle(ChatFormatting.RED));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        StandHandler.syncData(e);
    }

    public static void scalingBar(CustomBossEvent bar, ServerPlayer source, int time, int timeBeforeSTart, Optional<Boolean> showTimeLeft) {
        bar.setProgress(0.0f);
        bar.setMax(100);
        Component name = bar.getName();
        Mots.serverTaskExecutioner.tasks.add(new Queue.Task(timeBeforeSTart, task -> bar.addPlayer(source)));
        boolean counter = false;
        Mots.serverTaskExecutioner.tasks.add(new Queue.Task(timeBeforeSTart, task -> {
            for (int i = 0; i < time; ++i) {
                int finalI = i;
                Mots.serverTaskExecutioner2.tasks.add(new Queue.Task(i, t -> {
                    bar.setProgress((float)t.intValue() / (float)time);
                    if (((Boolean)showTimeLeft.get()).booleanValue()) {
                        bar.setName((Component)Component.literal((String)(name.getString() + " [" + (time - t) / 20 + "'s ]")));
                    }
                }));
            }
        }));
        Mots.serverTaskExecutioner2.tasks.add(new Queue.Task(time + timeBeforeSTart, task -> bar.removePlayer(source)));
    }

    public static List<Entity> executeScalableMeleeAttack(LivingEntity player, Integer damage, Vec3 range, Optional<Boolean> stun, Optional<Integer> stunDuration, boolean shouldDestroyBlocks) {
        damage = damage != null ? Integer.valueOf(damage + Integer.valueOf((int)StandHandler.getStandPowerModifier(player))) : Integer.valueOf(0);
        if (!player.hasData(Attachments.STAND_ATTACK_POTENCY)) {
            player.setData(Attachments.STAND_ATTACK_POTENCY, (Object)1.0);
        }
        player.setData(Attachments.STAND_ATTACK_POTENCY, (Object)((Double)player.getData(Attachments.STAND_ATTACK_POTENCY) + 0.1));
        return StandHandler.executeMeleAttack(player, Float.valueOf(damage.floatValue()), range, stun, stunDuration, shouldDestroyBlocks);
    }

    public static Trait getEntityTrait(LivingEntity entity) {
        String traitString = (String)entity.getData(Attachments.STAND_TRAIT);
        if (traitString.isEmpty()) {
            return null;
        }
        try {
            UUID traitUUID = UUID.fromString(traitString);
            return Mots.traits.stream().filter(t -> t.getUUID().equals(traitUUID)).findFirst().orElseThrow();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<Entity> executeMeleAttack(LivingEntity player, Float damage, Vec3 range, Optional<Boolean> stun, Optional<Integer> stunDuration, boolean shouldDestroyBlocks) {
        Trait trait = StandHandler.getEntityTrait(player);
        Level world = player.level();
        Vec3 eyePosition = player.getEyePosition();
        Vec3 lookDirection = player.getLookAngle().normalize();
        Optional<StandEntity> stand = StandHandler.getStand(player);
        if (stand.isPresent() && stand.get().getVehicle() == null) {
            eyePosition = stand.get().getEyePosition();
            lookDirection = stand.get().getLookAngle().normalize();
        }
        if (!player.level().getGameRules().getBoolean(ModGameRules.MOTS_STAND_BLOCK_BREAKING)) {
            shouldDestroyBlocks = false;
        }
        Vec3 hitboxCenter = eyePosition.add(lookDirection.scale(1.0));
        AABB hitbox = new AABB(hitboxCenter.x - range.x / 2.0, hitboxCenter.y - range.y / 2.0, hitboxCenter.z - range.z / 2.0, hitboxCenter.x + range.x / 2.0, hitboxCenter.y + range.y / 2.0, hitboxCenter.z + range.z / 2.0);
        List entityList = world.getEntities((Entity)player, hitbox).stream().filter(entity -> entity != player).collect(Collectors.toList());
        if (shouldDestroyBlocks && !((Boolean)player.getData(Attachments.BREAK_BLOCKS)).booleanValue()) {
            shouldDestroyBlocks = false;
        }
        if (shouldDestroyBlocks) {
            boolean healMode;
            boolean finalHealMode = healMode = player.hasData(CrazyDiamondsAttachments.HEAL_MODE) && (Boolean)player.getData(CrazyDiamondsAttachments.HEAL_MODE) != false;
            BlockPos.betweenClosedStream((AABB)hitbox).forEach(blockPos -> {
                BlockState blockState = player.level().getBlockState(blockPos);
                Block block = blockState.getBlock();
                if (!blockState.isAir() && block.defaultDestroyTime() != -1.0f) {
                    if (finalHealMode) {
                        if (player.level().getBlockEntity(blockPos) != null) {
                            return;
                        }
                        BlockPos immutablePos = blockPos.immutable();
                        player.level().destroyBlock(immutablePos, false);
                        if (!player.hasData(CrazyDiamondsAttachments.BLOCKS)) {
                            player.setData(CrazyDiamondsAttachments.BLOCKS, new ArrayList());
                        }
                        ((ArrayList)player.getData(CrazyDiamondsAttachments.BLOCKS)).add(com.llamalad7.mixinextras.lib.apache.commons.tuple.Pair.of((Object)immutablePos, (Object)blockState));
                    } else if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        serverPlayer.gameMode.destroyBlock(blockPos);
                        ServerLevel level = (ServerLevel)player.level();
                        level.playSound(null, blockPos, blockState.getSoundType().getBreakSound(), SoundSource.BLOCKS, 2.0f, 1.0f);
                        serverPlayer.level().players().forEach(p -> {
                            level.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), 5, 0.0, 0.0, 0.0, 0.2);
                            level.sendParticles((ParticleOptions)ParticleTypes.GUST, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), 5, 0.0, 0.0, 0.0, 0.2);
                        });
                    }
                }
            });
        }
        MobEffectInstance effectInstance = new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 20, 2, false, false);
        for (int i = 0; i < entityList.size(); ++i) {
            StandEntity stand1;
            Object t2;
            if (stand.isPresent() && ((Entity)entityList.get(i)).is((Entity)stand.get())) continue;
            try {
                if (((Entity)entityList.get(i)).getTeam().isAlliedTo((Team)player.getTeam()) && !player.getTeam().isAllowFriendlyFire()) {
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((t2 = entityList.get(i)) instanceof StandEntity && (stand1 = (StandEntity)((Object)t2)).getVehicle() == null) {
                stand1.getUUIDOwner().ifPresent(uuid -> entityList.add(player.getServer().getPlayerList().getPlayer(uuid)));
            }
            if (damage.floatValue() != 0.0f) {
                ((Entity)entityList.get(i)).hurt(new DamageSource(player.level().damageSources().mobAttack(player).typeHolder(), (Entity)entityList.get(i), (Entity)player), damage.floatValue());
                if (trait != null && (t2 = entityList.get(i)) instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)t2;
                    trait.onHitEnemy.accept((Pair<Pair<LivingEntity, LivingEntity>, Float>)Pair.of((Object)Pair.of((Object)livingEntity, (Object)player), (Object)damage));
                }
                ServerLevel level = (ServerLevel)player.level();
                int finalI1 = i;
                player.level().players().forEach(p -> level.sendParticles((ParticleOptions)ParticleTypes.CRIT, ((Entity)entityList.get(finalI1)).getX(), ((Entity)entityList.get((int)finalI1)).getBoundingBox().getCenter().y, ((Entity)entityList.get(finalI1)).getZ(), 60, 0.5, 0.5, 0.5, 2.0));
            }
            if (stun.isPresent() && stun.get().booleanValue() && stunDuration.isPresent()) {
                int finalI = i;
                effectInstance = new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 20 * stunDuration.get(), 5, false, false);
                for (int j = 0; j < stunDuration.get() * 20; ++j) {
                    Mots.serverTaskExecutioner2.tasks.add(new Queue.Task(j, t -> ((Entity)entityList.get(finalI)).setDeltaMovement(0.0, 0.0, 0.0)));
                }
                Entity e2 = (Entity)entityList.get(i);
                if (e2 instanceof Mob) {
                    Mob living = (Mob)e2;
                    if (living.isAlive()) {
                        living.setNoAi(true);
                        Mots.serverTaskExecutioner2.tasks.add(new Queue.Task(stunDuration.get() * 20, task -> living.setNoAi(false)));
                    } else {
                        living.setNoAi(false);
                    }
                }
                if (e2.hasData(Attachments.COOLDOWN_TIME_ATTACK) && e2 instanceof ServerPlayer) {
                    ServerPlayer p2 = (ServerPlayer)e2;
                    if ((Integer)p2.getData(Attachments.COOLDOWN_TIME_ATTACK) < 0) {
                        p2.setData(Attachments.COOLDOWN_TIME_ATTACK, (Object)((Integer)p2.getData(Attachments.COOLDOWN_TIME_ATTACK) + 20 * stunDuration.get()));
                    }
                    if ((Integer)p2.getData(Attachments.COOLDOWN_TIME_ABILITY) < 0) {
                        p2.setData(Attachments.COOLDOWN_TIME_ABILITY, (Object)((Integer)p2.getData(Attachments.COOLDOWN_TIME_ABILITY) + 20 * stunDuration.get()));
                    }
                    PacketDistributor.sendToPlayer((ServerPlayer)p2, (CustomPacketPayload)new SyncStandData((Integer)p2.getData(Attachments.STAND_ID), (Integer)p2.getData(Attachments.COOLDOWN_TIME_ATTACK), (Integer)p2.getData(Attachments.COOLDOWN_TIME_ABILITY), (Integer)p2.getData(Attachments.STAMINA), (Integer)p2.getData(Attachments.SKILL), (Integer)p2.getData(Attachments.MAX_STAMINA)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            try {
                LivingEntity instance = (LivingEntity)entityList.get(i);
                instance.addEffect(effectInstance);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ArrayList entityListCopy = new ArrayList(List.copyOf(entityList));
        entityListCopy.remove(player);
        StandHandler.getStand(player).ifPresent(entityListCopy::remove);
        if (!entityListCopy.isEmpty()) {
            ((Entity)entityList.getFirst()).level().playSound(null, ((Entity)entityList.getFirst()).blockPosition(), ModSounds.STAND_HIT.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        }
        return entityList.stream().filter(e -> !(e instanceof StandEntity)).toList();
    }

    public static boolean canMoveInTimeStop(LivingEntity p) {
        return p.hasData(Attachments.TIME_STOP_TICKS_LEFT) && (Integer)p.getData(Attachments.TIME_STOP_TICKS_LEFT) > 0;
    }

    public static void givePlayerStandAdvancement(ServerPlayer player) {
        String standName = "d4c";
        switch ((Integer)player.getData(Attachments.STAND_ID)) {
            case 1: {
                standName = "d4c";
                AdvancementProgress progress = player.getAdvancements().getOrStartProgress(player.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)("stand_advancement." + standName))));
                if (progress.isDone()) break;
                for (String s : progress.getRemainingCriteria()) {
                    player.getAdvancements().award(player.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)("stand_advancement." + standName))), s);
                }
                break;
            }
            case 2: {
                standName = "white_snake";
                AdvancementProgress progress = player.getAdvancements().getOrStartProgress(player.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)("stand_advancement." + standName))));
                if (progress.isDone()) break;
                for (String s : progress.getRemainingCriteria()) {
                    player.getAdvancements().award(player.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)("stand_advancement." + standName))), s);
                }
                break;
            }
            case 7: {
                standName = "white_snake";
                AdvancementProgress progress = player.getAdvancements().getOrStartProgress(player.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)("stand_advancement." + standName))));
                if (progress.isDone()) break;
                for (String s : progress.getRemainingCriteria()) {
                    player.getAdvancements().award(player.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)("stand_advancement." + standName))), s);
                }
                break;
            }
            case 3: {
                standName = "killer_queen";
                AdvancementProgress progress = player.getAdvancements().getOrStartProgress(player.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)("stand_advancement." + standName))));
                if (progress.isDone()) break;
                for (String s : progress.getRemainingCriteria()) {
                    player.getAdvancements().award(player.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)("stand_advancement." + standName))), s);
                }
                break;
            }
            case 4: {
                standName = "the_world";
                AdvancementProgress progress = player.getAdvancements().getOrStartProgress(player.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)("stand_advancement." + standName))));
                if (progress.isDone()) break;
                for (String s : progress.getRemainingCriteria()) {
                    player.getAdvancements().award(player.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)("stand_advancement." + standName))), s);
                }
                break;
            }
            case 5: {
                standName = "king_crimson";
                AdvancementProgress progress = player.getAdvancements().getOrStartProgress(player.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)("stand_advancement." + standName))));
                if (progress.isDone()) break;
                for (String s : progress.getRemainingCriteria()) {
                    player.getAdvancements().award(player.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)("stand_advancement." + standName))), s);
                }
                break;
            }
            case 8: {
                standName = "cmoon";
                AdvancementProgress progress = player.getAdvancements().getOrStartProgress(player.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)("stand_advancement." + standName))));
                if (progress.isDone()) break;
                for (String s : progress.getRemainingCriteria()) {
                    player.getAdvancements().award(player.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)("stand_advancement." + standName))), s);
                }
                break;
            }
            case 9: {
                standName = "made_in_heaven";
                AdvancementProgress progress = player.getAdvancements().getOrStartProgress(player.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)("stand_advancement." + standName))));
                if (progress.isDone()) break;
                for (String s : progress.getRemainingCriteria()) {
                    player.getAdvancements().award(player.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)("stand_advancement." + standName))), s);
                }
                break;
            }
            case 10: {
                standName = "wonder_of_you";
                AdvancementProgress progress = player.getAdvancements().getOrStartProgress(player.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)("stand_advancement." + standName))));
                if (progress.isDone()) break;
                for (String s : progress.getRemainingCriteria()) {
                    player.getAdvancements().award(player.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)("stand_advancement." + standName))), s);
                }
                break;
            }
            case 11: {
                standName = "crazy_diamond";
                AdvancementProgress progress = player.getAdvancements().getOrStartProgress(player.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)("stand_advancement." + standName))));
                if (progress.isDone()) break;
                for (String s : progress.getRemainingCriteria()) {
                    player.getAdvancements().award(player.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)("stand_advancement." + standName))), s);
                }
                break;
            }
            case 12: {
                standName = "diver_down";
                AdvancementProgress progress = player.getAdvancements().getOrStartProgress(player.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)("stand_advancement." + standName))));
                if (progress.isDone()) break;
                for (String s : progress.getRemainingCriteria()) {
                    player.getAdvancements().award(player.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)("stand_advancement." + standName))), s);
                }
                break;
            }
            case 13: {
                standName = "weather_report";
                AdvancementProgress progress = player.getAdvancements().getOrStartProgress(player.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)("stand_advancement." + standName))));
                if (progress.isDone()) break;
                for (String s : progress.getRemainingCriteria()) {
                    player.getAdvancements().award(player.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)("stand_advancement." + standName))), s);
                }
                break;
            }
            case 14: {
                standName = "soft_and_wet";
                AdvancementProgress progress = player.getAdvancements().getOrStartProgress(player.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)("stand_advancement." + standName))));
                if (progress.isDone()) break;
                for (String s : progress.getRemainingCriteria()) {
                    player.getAdvancements().award(player.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)("stand_advancement." + standName))), s);
                }
                break;
            }
        }
    }

    public static double getStandSpecial(LivingEntity p) {
        double val = 1.0;
        if ((Double)p.getData(Attachments.STAND_SPECIAL_POTENCY) > StandHandler.getStandMaxPower(p)) {
            p.setData(Attachments.STAND_SPECIAL_POTENCY, (Object)StandHandler.getStandMaxPower(p));
        }
        val *= ((Double)p.getData(Attachments.STAND_SPECIAL_POTENCY)).doubleValue();
        val = 20.0;
        int amount = p.level().getGameRules().getInt(ModGameRules.MOTS_STAND_ABILITY_MODIFIER);
        if (amount != 0) {
            val = amount > 0 ? (val *= (double)amount) : (val /= (double)Math.abs(amount));
        }
        return val;
    }

    public static double getStandMaxPower(LivingEntity player) {
        Integer rebirth = (Integer)player.getData(Attachments.STAND_REBIRTH);
        if (rebirth == 0) {
            return 7.5;
        }
        if (rebirth == 1) {
            return 11.25;
        }
        if (rebirth == 2) {
            return 15.0;
        }
        if (rebirth >= 3) {
            return 20.0;
        }
        return 0.0;
    }

    public static float getStandPowerModifier(LivingEntity player) {
        Trait trait;
        float val = 1.0f;
        if (player.getAttributes().hasAttribute(Attributes.ATTACK_DAMAGE)) {
            val = (float)player.getAttributeValue(Attributes.ATTACK_DAMAGE) / 3.0f;
        }
        if (player instanceof Player) {
            Player p = (Player)player;
            val += p.getAttackStrengthScale(20.0f);
        }
        if ((Double)player.getData(Attachments.STAND_ATTACK_POTENCY) > StandHandler.getStandMaxPower(player)) {
            player.setData(Attachments.STAND_ATTACK_POTENCY, (Object)StandHandler.getStandMaxPower(player));
        }
        val = (float)((double)val + (Double)player.getData(Attachments.STAND_ATTACK_POTENCY));
        int amount = player.level().getGameRules().getInt(ModGameRules.MOTS_STAND_POWER_MODIFIER);
        if (amount != 0) {
            val = amount > 0 ? (val *= (float)amount) : (val /= (float)Math.abs(amount));
        }
        if ((trait = StandHandler.getEntityTrait(player)) != null && trait.getUUID().equals(UUID.fromString("b10e275e-dba7-4e26-b1dd-6e79d0852aba"))) {
            float hpPercent = player.getHealth() / player.getMaxHealth();
            int level = (int)((0.4f - hpPercent) / 0.3f * 4.0f);
            val += (float)(level * 3);
        }
        return val;
    }

    public static Optional<StandEntity> getStand(LivingEntity entity) {
        AtomicReference returnValue = new AtomicReference(Optional.empty());
        try {
            entity.getPassengers().forEach(p -> {
                if (p instanceof StandEntity) {
                    StandEntity e = (StandEntity)((Object)p);
                    returnValue.set(Optional.of(e));
                    return;
                }
            });
            if (returnValue.get().isEmpty()) {
                if (entity.level().isClientSide()) {
                    Entity entity2 = Minecraft.getInstance().getCameraEntity();
                    if (entity2 instanceof StandEntity) {
                        StandEntity e = (StandEntity)entity2;
                        returnValue.set(Optional.of(e));
                    }
                } else {
                    ServerLevel level = (ServerLevel)entity.level();
                    level.getEntities().getAll().forEach(entry -> {
                        StandEntity s;
                        if (entry instanceof StandEntity && (s = (StandEntity)((Object)entry)).getUUIDOwner().isPresent() && s.getUUIDOwner().get().equals(entity.getUUID())) {
                            returnValue.set(Optional.of(s));
                        }
                    });
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return returnValue.get();
    }
}

