/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.PayLoads;

import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.UUID;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.Skills.KingCrimson.KingCrimsonAttachments;
import net.hrodebert.mots.MotsApi.Skills.SoftAndWet.SoftAndWetAttachments;
import net.hrodebert.mots.MotsApi.Skills.TheWorld.TheWorldProgressionAttachments;
import net.hrodebert.mots.MotsApi.Skills.Vampirism.VampirismAttachments;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.hrodebert.mots.PayLoads.ChangeFriction;
import net.hrodebert.mots.PayLoads.ChangeSpaceRipperEyes;
import net.hrodebert.mots.PayLoads.ChangeStandTimeStopTicks;
import net.hrodebert.mots.PayLoads.ChangeTimeErasureState;
import net.hrodebert.mots.PayLoads.EnableTimesStop;
import net.hrodebert.mots.PayLoads.ExecuteSkill;
import net.hrodebert.mots.PayLoads.SetPlayerAnimation;
import net.hrodebert.mots.PayLoads.SwingArm;
import net.hrodebert.mots.PayLoads.SyncRebirths;
import net.hrodebert.mots.PayLoads.SyncStandData;
import net.hrodebert.mots.PayLoads.SyncVampireData;
import net.hrodebert.mots.PayLoads.UpdatePlayerPos;
import net.hrodebert.mots.PayLoads.UpdatePlayerSpin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClientPayloadHandler {
    public static void handleDataOnMain(SyncStandData data, IPayloadContext context) {
        Player player = context.player();
        player.setData(Attachments.STAND_ID, (Object)data.standId());
        player.setData(Attachments.COOLDOWN_TIME_ABILITY, (Object)data.cd_ability());
        player.setData(Attachments.COOLDOWN_TIME_ATTACK, (Object)data.cd_attack());
        player.setData(Attachments.STAMINA, (Object)data.stamina());
        player.setData(Attachments.MAX_STAMINA, (Object)data.maxStamina());
        if (data.standId() == 0) {
            player.setData(Attachments.HAS_STAND, (Object)false);
        } else {
            player.setData(Attachments.HAS_STAND, (Object)true);
        }
        if (data.skill() != -1) {
            player.setData(Attachments.SKILL, (Object)data.skill());
        } else {
            PacketDistributor.sendToServer((CustomPacketPayload)new SyncStandData(data.standId(), data.cd_attack(), data.cd_ability(), data.stamina(), (Integer)player.getData(Attachments.SKILL), data.maxStamina()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        StandHandler.registerSkills((LivingEntity)player);
    }

    public static void handleDataOnMain(ExecuteSkill data, IPayloadContext context) {
        Player player = context.player();
        if (data.execute()) {
            StandHandler.executeSkill((LivingEntity)player);
        }
    }

    public static void handleDataOnMain(SyncRebirths data, IPayloadContext context) {
        Player player = context.player();
        player.setData(Attachments.STAND_REBIRTH, (Object)data.rebirths());
    }

    public static void handleDataOnMain(UpdatePlayerSpin data, IPayloadContext context) {
        Player player = context.player();
        try {
            UUID player_uuid = UUID.fromString(data.playerUUID());
            player.level().getPlayerByUUID(player_uuid).setData(Attachments.SPIN_AMOUNT, (Object)data.value());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void handleDataOnMain(ChangeSpaceRipperEyes data, IPayloadContext context) {
        Player player = context.player();
        try {
            UUID player_uuid = UUID.fromString(data.playerUUID());
            player.level().getPlayerByUUID(player_uuid).setData(VampirismAttachments.IS_DOING_SPACE_RIPPER, (Object)data.value());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void handleDataOnMain(SyncVampireData data, IPayloadContext context) {
        Player player = context.player();
        player.setData(VampirismAttachments.IS_VAMPIRE, (Object)data.is_vampire());
        player.setData(Attachments.SPIN_AMOUNT, (Object)data.blood());
    }

    public static void handleDataOnMain(SetPlayerAnimation data, IPayloadContext context) {
        Player player = context.player();
        try {
            UUID player_uuid = UUID.fromString(data.playerUUID());
            player = player.level().getPlayerByUUID(player_uuid);
            ModifierLayer animation = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)player)).get(ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"player_animation"));
            if (data.animation().equals("none")) {
                animation.setAnimation(null);
                return;
            }
            KeyframeAnimation anim = (KeyframeAnimation)PlayerAnimationRegistry.getAnimation((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)data.animation()));
            animation.setAnimation((IAnimation)new KeyframeAnimationPlayer(anim).setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void handleDataOnMain(SwingArm data, IPayloadContext context) {
        Player player = context.player().level().getPlayerByUUID(UUID.fromString(data.playeruuid()));
        if (data.arm()) {
            player.swing(InteractionHand.MAIN_HAND);
        } else {
            player.swing(InteractionHand.OFF_HAND);
        }
    }

    public static void handleDataOnMain(ChangeFriction data, IPayloadContext context) {
        Player player = context.player();
        player.setData(SoftAndWetAttachments.NO_FRICTION, (Object)data.value());
    }

    public static void handleDataOnMain(ChangeStandTimeStopTicks data, IPayloadContext context) {
        Player player = context.player();
        player.setData(Attachments.TIME_STOP_TICKS_LEFT, (Object)data.ticks());
    }

    public static void handleDataOnMain(EnableTimesStop data, IPayloadContext context) {
        Player player = context.player();
        player.setData(TheWorldProgressionAttachments.HAS_TIME_STOP, (Object)data.execute());
    }

    public static void handleDataOnMain(ChangeTimeErasureState data, IPayloadContext context) {
        Player player = context.player();
        if (player instanceof LocalPlayer) {
            LocalPlayer player1 = (LocalPlayer)player;
            ((LocalPlayer)player).clientLevel.setDayTime(18000L);
            Minecraft.getInstance().levelRenderer.allChanged();
        }
        player.setData(KingCrimsonAttachments.TIME_ERASE, (Object)data.execute());
    }

    public static void handleDataOnMain(UpdatePlayerPos data, IPayloadContext context) {
        Player player = context.player();
        player.setOnGround(true);
        player.teleportTo((double)data.pos().x, (double)data.pos().y, (double)data.pos().z);
    }
}

