/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.PayLoads;

import net.hrodebert.mots.ModEntities.custom.StandEntity;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.Skills.TheWorld.TheWorldProgressionAttachments;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.hrodebert.mots.MotsApi.Trait;
import net.hrodebert.mots.PayLoads.ChangeBlockBreak;
import net.hrodebert.mots.PayLoads.ChangeStandVelocity;
import net.hrodebert.mots.PayLoads.EnableTimesStop;
import net.hrodebert.mots.PayLoads.ExecuteSkill;
import net.hrodebert.mots.PayLoads.GetStandPower;
import net.hrodebert.mots.PayLoads.MoveStand;
import net.hrodebert.mots.PayLoads.SetStandMode;
import net.hrodebert.mots.PayLoads.SyncStandData;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerPayloadHandler {
    public static void handleDataOnMain(GetStandPower data, IPayloadContext context) {
        Player player = context.player();
        player.sendSystemMessage((Component)Component.literal((String)"Stats:"));
        if (!player.hasData(Attachments.STAND_SPECIAL_POTENCY)) {
            player.setData(Attachments.STAND_SPECIAL_POTENCY, (Object)0.0);
        }
        Double ability = (Double)player.getData(Attachments.STAND_SPECIAL_POTENCY);
        char abilityChar = 'D';
        if (ability >= 7.5) {
            abilityChar = 'C';
        }
        if (ability >= 11.25) {
            abilityChar = 'B';
        }
        if (ability >= 15.0) {
            abilityChar = 'A';
        }
        player.sendSystemMessage((Component)Component.literal((String)("Special: " + abilityChar + " : " + ability)));
        if (!player.hasData(Attachments.STAND_SPECIAL_POTENCY)) {
            player.setData(Attachments.STAND_SPECIAL_POTENCY, (Object)0.0);
        }
        Double power = (Double)player.getData(Attachments.STAND_ATTACK_POTENCY);
        char powerChar = 'D';
        if (power >= 10.0) {
            powerChar = 'C';
        }
        if (power >= 15.0) {
            powerChar = 'B';
        }
        if (power >= 20.0) {
            powerChar = 'A';
        }
        player.sendSystemMessage((Component)Component.literal((String)("Power: " + powerChar + " : " + power)));
        Double resistance = (Double)player.getData(Attachments.DAMAGE_RESISTANCE);
        char resistanceChar = 'D';
        if (resistance >= 20.0) {
            resistanceChar = 'C';
        }
        if (resistance >= 30.0) {
            resistanceChar = 'B';
        }
        if (resistance >= 40.0) {
            resistanceChar = 'A';
        }
        player.sendSystemMessage((Component)Component.literal((String)("Damage resistance: " + resistanceChar + " : " + resistance)));
        player.sendSystemMessage((Component)Component.literal((String)("Rebirths + " + String.valueOf(player.getData(Attachments.STAND_REBIRTH)))));
        Trait trait = StandHandler.getEntityTrait((LivingEntity)player);
        if (trait != null) {
            player.sendSystemMessage((Component)Component.literal((String)("Trait: " + trait.name)));
            player.sendSystemMessage((Component)Component.literal((String)("---- Description: " + trait.description)));
        }
    }

    public static void handleDataOnMain(EnableTimesStop data, IPayloadContext context) {
        Player player = context.player();
        player.setData(TheWorldProgressionAttachments.HAS_TIME_STOP, (Object)data.execute());
    }

    public static void handleDataOnMain(SetStandMode data, IPayloadContext context) {
        Player player = context.player();
        Integer oldCd = (Integer)player.getData(Attachments.COOLDOWN_TIME_ATTACK);
        Integer newCd = (Integer)player.getData(Attachments.COOLDOWN_TIME_ATTACK_2);
        player.setData(Attachments.COOLDOWN_TIME_ATTACK, (Object)newCd);
        player.setData(Attachments.COOLDOWN_TIME_ATTACK_2, (Object)oldCd);
        player.setData(Attachments.STAND_MODE, (Object)data.value());
    }

    public static void handleDataOnMain(SyncStandData data, IPayloadContext context) {
        Player player = context.player();
        player.setData(Attachments.STAND_ID, (Object)data.standId());
        player.setData(Attachments.COOLDOWN_TIME_ABILITY, (Object)data.cd_ability());
        player.setData(Attachments.COOLDOWN_TIME_ATTACK, (Object)data.cd_attack());
        player.setData(Attachments.STAMINA, (Object)data.stamina());
        player.setData(Attachments.SKILL, (Object)data.skill());
        player.setData(Attachments.MAX_STAMINA, (Object)data.maxStamina());
        if (data.standId() == 0) {
            player.setData(Attachments.HAS_STAND, (Object)false);
        } else {
            player.setData(Attachments.HAS_STAND, (Object)true);
        }
        StandHandler.registerSkills((LivingEntity)player);
    }

    public static void handleDataOnMain(ExecuteSkill data, IPayloadContext context) {
        Player player = context.player();
        if (data.execute()) {
            StandHandler.executeSkill((LivingEntity)player);
        } else {
            try {
                StandHandler.getStand((LivingEntity)player).ifPresent(stand -> stand.switchPilot());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void handleDataOnMain(ChangeStandVelocity data, IPayloadContext context) {
        Player player = context.player();
        try {
            if (StandHandler.getStand((LivingEntity)player).isPresent() && !player.getPassengers().contains((Object)StandHandler.getStand((LivingEntity)player).get())) {
                StandEntity stand = StandHandler.getStand((LivingEntity)player).get();
                stand.goalSelector.removeAllGoals(s -> true);
                stand.setDeltaMovement(new Vec3(data.xSpeed(), data.ySpeed(), data.zSpeed()));
                stand.hurtMarked = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void handleDataOnMain(MoveStand data, IPayloadContext context) {
        Player player = context.player();
        try {
            StandEntity stand = StandHandler.getStand((LivingEntity)player).get();
            stand.setXRot((float)data.xRot());
            stand.setYRot((float)data.yRot());
            float newRotation = (float)data.yRot();
            stand.setYRot(newRotation);
            stand.yRotO = newRotation;
            stand.setYHeadRot(newRotation);
            stand.setYBodyRot(newRotation);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void handleDataOnMain(ChangeBlockBreak data, IPayloadContext context) {
        Player player = context.player();
        player.setData(Attachments.BREAK_BLOCKS, (Object)data.value());
    }
}

