/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.ServerQueue;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;

public class Queue {
    public ArrayList<Task> tasks = new ArrayList();

    public void onTick() {
        Iterator<Task> iterator = this.tasks.iterator();
        while (iterator.hasNext()) {
            Task task = iterator.next();
            task.onTickExecute();
            if (!task.markForRemoval) continue;
            iterator.remove();
        }
    }

    public static class Task {
        private int initialTick = 0;
        private int tickStart = 0;
        private int currentTick = 0;
        private Consumer<Integer> consumer;
        private boolean markForRemoval = false;

        public Task(int ticksToWait, Consumer<Integer> task) {
            this.tickStart = ticksToWait;
            this.consumer = task;
            this.initialTick = ticksToWait;
        }

        public void markForRemoval() {
            this.markForRemoval = true;
        }

        public void onTickExecute() {
            ++this.currentTick;
            if (this.currentTick > this.tickStart) {
                this.markForRemoval();
                try {
                    this.consumer.accept(this.initialTick);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

