/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus;

import dk.magnusjensen.customchestmenus.menu.CustomChestMenu;
import dk.magnusjensen.customchestmenus.models.MenuDefinition;
import dk.magnusjensen.customchestmenus.models.MenuItem;
import dk.magnusjensen.customchestmenus.models.MenuPage;
import dk.magnusjensen.customchestmenus.models.MenuSize;
import dk.magnusjensen.customchestmenus.models.actions.CommandAction;
import dk.magnusjensen.customchestmenus.models.actions.CraftItem;
import dk.magnusjensen.customchestmenus.models.actions.CraftItemsAction;
import dk.magnusjensen.customchestmenus.models.actions.PageAction;
import dk.magnusjensen.customchestmenus.models.actions.TeleportAction;
import dk.magnusjensen.customchestmenus.network.UpdateMenuTitleS2C;
import dk.magnusjensen.customchestmenus.platform.Services;
import dk.magnusjensen.customchestmenus.registry.CustomChestMenuRegistry;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.joml.Math;

public final class ActionExecutor {
    public static void onClick(class_3222 player, String menuId, int pageIndex, int slot) {
        MenuDefinition menu = CustomChestMenuRegistry.get(menuId);
        if (menu == null) {
            return;
        }
        if (!ActionExecutor.inBounds(menu.size(), slot)) {
            return;
        }
        MenuPage page = menu.pages().get(java.lang.Math.max(0, java.lang.Math.min(pageIndex, menu.pages().size() - 1)));
        MenuItem item = page.items().stream().filter(it -> it.slot() == slot).findFirst().orElse(null);
        if (item == null) {
            return;
        }
        switch (item.action().type()) {
            case CLOSE: {
                player.method_7346();
                break;
            }
            case NEXT_PAGE: {
                ActionExecutor.openPage(player, menu, pageIndex, java.lang.Math.min(pageIndex + 1, menu.pages().size() - 1));
                break;
            }
            case PREVIOUS_PAGE: {
                ActionExecutor.openPage(player, menu, pageIndex, java.lang.Math.max(pageIndex - 1, 0));
                break;
            }
            case JUMP_TO_PAGE: {
                PageAction pageAction = (PageAction)item.action();
                ActionExecutor.openPage(player, menu, pageIndex, Math.clamp((int)pageAction.targetPage().orElse(0), (int)0, (int)(menu.pages().size() - 1)));
                break;
            }
            case TELEPORT: {
                TeleportAction tp = (TeleportAction)item.action();
                ActionExecutor.doTeleport(player, tp);
                player.method_7346();
                break;
            }
            case COMMAND: {
                CommandAction command = (CommandAction)item.action();
                ActionExecutor.runCommand(player, command);
                break;
            }
            case CRAFT_ITEMS: {
                CraftItemsAction action = (CraftItemsAction)item.action();
                ActionExecutor.craftItems(player, action);
            }
        }
    }

    private static void openPage(class_3222 player, MenuDefinition menu, int currentPage, int newPage) {
        CustomChestMenu ccm;
        class_1703 class_17032 = player.field_7512;
        if (!(class_17032 instanceof CustomChestMenu) || !(ccm = (CustomChestMenu)class_17032).menuId().equals(menu.id())) {
            return;
        }
        if (newPage == currentPage) {
            return;
        }
        ccm.populateFromDefinition(menu, newPage);
        int clampedPage = Math.clamp((int)0, (int)(menu.pages().size() - 1), (int)newPage);
        UpdateMenuTitleS2C packet = new UpdateMenuTitleS2C(ccm.menuId(), menu.pages().get(clampedPage).titleAsComponent());
        Services.NETWORK.sendToPlayer(player, packet);
    }

    private static void doTeleport(class_3222 player, TeleportAction tp) {
        class_3218 target = player.method_51469().method_8503().method_3847(tp.dimension().map(class_2960::method_12829).map(rl -> class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)rl)).orElse(player.method_51469().method_27983()));
        if (target == null) {
            return;
        }
        player.method_48105(target, tp.x() + 0.5, tp.y(), tp.z() + 0.5, Set.of(), player.method_36454(), player.method_36455(), false);
    }

    private static boolean inBounds(MenuSize size, int slot) {
        int max = size == MenuSize.SINGLE ? 27 : 54;
        return slot >= 0 && slot < max;
    }

    private static void runCommand(class_3222 player, CommandAction action) {
        MinecraftServer server = player.method_51469().method_8503();
        class_2168 stack = server.method_3739();
        if (action.shouldRunAsPlayer()) {
            stack = player.method_64396();
        }
        for (String cmd : action.commands()) {
            String finalCmd = cmd.replace("%player%", player.method_5820()).replace("%uuid%", player.method_5845());
            server.method_3734().method_44252(stack, finalCmd);
        }
    }

    private static void craftItems(class_3222 player, CraftItemsAction action) {
        if (!action.canCraft(player)) {
            player.method_64398((class_2561)class_2561.method_43470((String)"Can't craft, missing input items"));
            return;
        }
        Map<Integer, Integer> slotToQuantity = action.getInputSlots(player);
        for (Map.Entry<Integer, Integer> entry : slotToQuantity.entrySet()) {
            player.method_31548().method_5434(entry.getKey().intValue(), entry.getValue().intValue());
        }
        for (CraftItem item : action.outputs()) {
            class_1799 toGive = new class_1799((class_1935)class_7923.field_41178.method_63535(item.item()), item.quantity());
            if (player.method_31548().method_7394(toGive)) continue;
            player.method_7328(toGive, false);
        }
    }
}

