/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus;

import dk.magnusjensen.customchestmenus.events.EventHandler;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="customchestmenus")
public class NeoforgeEventHandler {
    @SubscribeEvent
    public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        boolean shouldCancel = EventHandler.onBlockRightClick(event.getEntity(), event.getPos(), event.getHand());
        event.setCanceled(shouldCancel);
    }

    @SubscribeEvent
    public static void onEntityRightClock(PlayerInteractEvent.EntityInteract event) {
        boolean shouldCancel = EventHandler.onEntityRightClick(event.getEntity(), event.getTarget(), event.getHand());
        event.setCanceled(shouldCancel);
    }

    @SubscribeEvent
    public static void onEntityUnload(EntityLeaveLevelEvent event) {
        EventHandler.onEntityUnload(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerStopTrackingEntity(PlayerEvent.StopTracking event) {
        EventHandler.onPlayerStopTracking(event.getEntity(), event.getTarget());
    }

    @SubscribeEvent
    public static void onPlayerStartTrackingEntity(PlayerEvent.StartTracking event) {
        EventHandler.onPlayerStartTracking(event.getEntity(), event.getTarget());
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ServerLevel destination = serverPlayer.level().getServer().getLevel(event.getTo());
        EventHandler.onPlayerChangeDimension(serverPlayer, destination);
    }

    @SubscribeEvent
    public static void onPlayerLeaverServer(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        EventHandler.onPlayerLeaveServer(serverPlayer);
    }
}

