/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus;

import dk.magnusjensen.customchestmenus.data.ChestMenuSavedData;
import dk.magnusjensen.customchestmenus.data.PlayerDataAttachment;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.saveddata.SavedData;

public class Utils {
    public static ResourceLocation modLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"customchestmenus", (String)path);
    }

    public static void populatePlayerDataForSync(ServerLevel level, PlayerDataAttachment playerData, ServerPlayer player) {
        playerData.resetServerSideVersionData();
        ChestMenuSavedData savedData = (ChestMenuSavedData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(ChestMenuSavedData::new, ChestMenuSavedData::load, null), "chest_menu_saved_data");
        playerData.setBoundBlocks(savedData.getMenuBlocks().keySet().stream().toList());
        ArrayList<Integer> boundEntities = new ArrayList<Integer>();
        savedData.getMenuEntities().keySet().stream().forEach(uuid -> {
            Entity entity = level.getEntity(uuid);
            if (entity != null) {
                boundEntities.add(entity.getId());
            }
        });
        playerData.setBoundEntities(boundEntities);
    }
}

