/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus.commands.arguments;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dk.magnusjensen.customchestmenus.models.MenuDefinition;
import dk.magnusjensen.customchestmenus.registry.CustomChestMenuRegistry;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

public class MenuArgument {
    private static final DynamicCommandExceptionType UNKNOWN_MENU = new DynamicCommandExceptionType(id -> Component.literal((String)("Unknown menu id: " + String.valueOf(id))));
    public static final SuggestionProvider<CommandSourceStack> MENU_IDS = (context, builder) -> {
        List<String> ids = CustomChestMenuRegistry.all().stream().map(MenuDefinition::id).toList();
        return SharedSuggestionProvider.suggest(ids, (SuggestionsBuilder)builder);
    };

    private MenuArgument() {
    }

    public static String getId(CommandContext<CommandSourceStack> ctx, String name) {
        return StringArgumentType.getString(ctx, (String)name);
    }

    public static MenuDefinition requireMenu(CommandContext<CommandSourceStack> ctx, String name) throws CommandSyntaxException {
        String id = MenuArgument.getId(ctx, name);
        MenuDefinition def = CustomChestMenuRegistry.get(id);
        if (def == null) {
            throw UNKNOWN_MENU.create((Object)id);
        }
        return def;
    }
}

