/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dk.magnusjensen.customchestmenus.Constants;
import dk.magnusjensen.customchestmenus.models.interactivity.InteractiveBlock;
import dk.magnusjensen.customchestmenus.models.interactivity.InteractiveEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.saveddata.SavedData;

public class ChestMenuSavedData
extends SavedData {
    public static final String CHEST_MENU_KEY = "chest_menu_saved_data";
    public static final Codec<Map<BlockPos, InteractiveBlock>> MENU_BLOCKS_CODEC = Codec.unboundedMap((Codec)Codec.STRING.xmap(s -> {
        try {
            String[] parts = s.split(",");
            return new BlockPos(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
        }
        catch (Exception e) {
            return BlockPos.ZERO;
        }
    }, pos -> pos.getX() + "," + pos.getY() + "," + pos.getZ()), InteractiveBlock.CODEC);
    public static final Codec<Map<UUID, InteractiveEntity>> MENU_ENTITIES_CODEC = Codec.unboundedMap((Codec)Codec.STRING.xmap(s -> {
        try {
            return UUID.fromString(s);
        }
        catch (Exception e) {
            Constants.LOGGER.warn("Failed to parse UUID in saved data", (Throwable)e);
            return UUID.fromString("00000000-0000-0000-0000-00000000000");
        }
    }, UUID::toString), InteractiveEntity.CODEC);
    public static final Codec<ChestMenuSavedData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MENU_BLOCKS_CODEC.fieldOf("menuBlocks").forGetter(ChestMenuSavedData::getMenuBlocks), (App)MENU_ENTITIES_CODEC.fieldOf("menuEntities").forGetter(ChestMenuSavedData::getMenuEntities)).apply((Applicative)instance, ChestMenuSavedData::new));
    private final Map<BlockPos, InteractiveBlock> menuBlocks = new HashMap<BlockPos, InteractiveBlock>();
    private final Map<UUID, InteractiveEntity> menuEntities = new HashMap<UUID, InteractiveEntity>();

    public ChestMenuSavedData(Map<BlockPos, InteractiveBlock> menuBlocks, Map<UUID, InteractiveEntity> menuEntities) {
        this.menuBlocks.putAll(menuBlocks);
        this.menuEntities.putAll(menuEntities);
    }

    public ChestMenuSavedData() {
    }

    public static ChestMenuSavedData load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)lookupProvider);
        return CODEC.parse((DynamicOps)ops, (Object)tag).resultOrPartial(error -> Constants.LOGGER.error("Failed to load chest menu saved data: {}", error)).orElseGet(ChestMenuSavedData::new);
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)provider);
        CODEC.encodeStart((DynamicOps)ops, (Object)this).resultOrPartial(error -> Constants.LOGGER.error("Failed to save chest menu saved data: {}", error)).ifPresent(tag -> {
            if (tag instanceof CompoundTag) {
                CompoundTag encoded = (CompoundTag)tag;
                compoundTag.merge(encoded);
            }
        });
        return compoundTag;
    }

    public Map<BlockPos, InteractiveBlock> getMenuBlocks() {
        return Map.copyOf(this.menuBlocks);
    }

    public void addMenuBlock(InteractiveBlock block) {
        this.menuBlocks.put(block.pos(), block);
        this.setDirty();
    }

    public void removeMenuBlock(BlockPos pos) {
        this.menuBlocks.remove(pos);
        this.setDirty();
    }

    public Map<UUID, InteractiveEntity> getMenuEntities() {
        return Map.copyOf(this.menuEntities);
    }

    public void addMenuEntity(InteractiveEntity entity) {
        this.menuEntities.put(entity.entityUUID(), entity);
        this.setDirty();
    }

    public void removeMenuEntity(UUID entityUUID) {
        this.menuEntities.remove(entityUUID);
        this.setDirty();
    }
}

