/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus.platform;

import dk.magnusjensen.customchestmenus.Constants;
import dk.magnusjensen.customchestmenus.data.PlayerDataAttachment;
import dk.magnusjensen.customchestmenus.network.SyncAttachmentDataS2C;
import dk.magnusjensen.customchestmenus.platform.services.IAttachmentHelper;
import dk.magnusjensen.customchestmenus.registry.NeoforgeAttachmentRegistry;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.network.PacketDistributor;

public class NeoforgeAttachmentHelper
implements IAttachmentHelper {
    @Override
    public <T> T getPlayerAttachment(Player player, ResourceLocation id) {
        AttachmentType attachmentType = NeoforgeAttachmentRegistry.findById(id);
        return (T)player.getData(attachmentType);
    }

    @Override
    public <T> void setPlayerAttachment(ServerPlayer player, T attachment, ResourceLocation id) {
        AttachmentType attachmentType = NeoforgeAttachmentRegistry.findById(id);
        if (attachmentType == null) {
            Constants.LOGGER.error("No attachment found for {}", attachment.getClass());
            return;
        }
        player.setData(attachmentType, attachment);
    }

    @Override
    public <T> void setPlayerAttachmentSync(ServerPlayer player, T attachment, ResourceLocation id) {
        this.setPlayerAttachment(player, attachment, id);
        if (attachment instanceof PlayerDataAttachment) {
            PlayerDataAttachment playerDataAttachment = (PlayerDataAttachment)attachment;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncAttachmentDataS2C(playerDataAttachment), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

