/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dk.magnusjensen.customchestmenus.data.PlayerDataAttachment;
import dk.magnusjensen.customchestmenus.platform.Services;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MenuHighlightRenderer {
    private static final double MAX_DIST_SQR = 4096.0;

    public static void renderLevelOverlay(PoseStack pose) {
        if (pose == null) {
            return;
        }
        PlayerDataAttachment playerData = (PlayerDataAttachment)Services.ATTACHMENT.getPlayerAttachment((Player)Minecraft.getInstance().player, PlayerDataAttachment.ID);
        if (!playerData.hasOverlay()) {
            return;
        }
        List<BlockPos> boundBlocks = playerData.boundBlocks();
        List<Integer> boundEntities = playerData.boundEntities();
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        MultiBufferSource.BufferSource buffers = Minecraft.getInstance().renderBuffers().bufferSource();
        Vec3 cam = camera.getPosition();
        VertexConsumer lineConsumer = buffers.getBuffer(RenderType.lines());
        for (BlockPos pos : boundBlocks) {
            double dz;
            double dy;
            double dx = (double)pos.getX() + 0.5 - cam.x;
            if (dx * dx + (dy = (double)pos.getY() + 0.5 - cam.y) * dy + (dz = (double)pos.getZ() + 0.5 - cam.z) * dz > 4096.0) continue;
            AABB box = new AABB(pos).inflate(0.002).move(-cam.x, -cam.y, -cam.z);
            ShapeRenderer.renderLineBox((PoseStack.Pose)pose.last(), (VertexConsumer)lineConsumer, (AABB)box, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        for (Integer entityID : boundEntities) {
            double distSq;
            Entity entity = Minecraft.getInstance().level.getEntity(entityID.intValue());
            if (entity == null || (distSq = entity.distanceToSqr(cam.x, cam.y, cam.z)) > 4096.0) continue;
            AABB entityBox = entity.getBoundingBox().inflate(0.1);
            AABB relativeBox = entityBox.move(-cam.x, -cam.y, -cam.z);
            VertexConsumer outlineConsumer = buffers.getBuffer(RenderType.lines());
            ShapeRenderer.renderLineBox((PoseStack.Pose)pose.last(), (VertexConsumer)outlineConsumer, (AABB)relativeBox, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

