/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dk.magnusjensen.customchestmenus.Memory;
import dk.magnusjensen.customchestmenus.Utils;
import dk.magnusjensen.customchestmenus.commands.arguments.MenuArgument;
import dk.magnusjensen.customchestmenus.data.ChestMenuSavedData;
import dk.magnusjensen.customchestmenus.data.PlayerDataAttachment;
import dk.magnusjensen.customchestmenus.models.MenuDefinition;
import dk.magnusjensen.customchestmenus.models.interactivity.InteractiveBlock;
import dk.magnusjensen.customchestmenus.models.interactivity.InteractiveEntity;
import dk.magnusjensen.customchestmenus.platform.Services;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class BindingCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ccm").then(((LiteralArgumentBuilder)Commands.literal((String)"bind").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"menu", (ArgumentType)StringArgumentType.word()).suggests(MenuArgument.MENU_IDS).executes(ctx -> {
            MenuDefinition menuDef = MenuArgument.requireMenu((CommandContext<CommandSourceStack>)ctx, "menu");
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            PlayerDataAttachment playerData = (PlayerDataAttachment)Services.ATTACHMENT.getPlayerAttachment((Player)player, PlayerDataAttachment.ID);
            if (playerData != null && !playerData.isBindingMode()) {
                playerData.activateBindingMode(menuDef.id());
                player.sendSystemMessage((Component)Component.literal((String)("Binding mode activated for menu: " + menuDef.id() + ". Right-click a block/entity to bind it.")), true);
            } else if (playerData != null && playerData.isBindingMode()) {
                playerData.disableBindingMode();
                player.sendSystemMessage((Component)Component.literal((String)"Binding mode disabled."), true);
            }
            PlayerDataAttachment newPlayerData = new PlayerDataAttachment();
            newPlayerData.copyFrom(playerData);
            Services.ATTACHMENT.setPlayerAttachment(player, newPlayerData, newPlayerData.getId());
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"unbind").requires(src -> src.hasPermission(2))).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            PlayerDataAttachment playerData = (PlayerDataAttachment)Services.ATTACHMENT.getPlayerAttachment((Player)player, PlayerDataAttachment.ID);
            if (playerData != null && !playerData.isUnbindingMode()) {
                playerData.activateUnbindingMode();
                player.sendSystemMessage((Component)Component.literal((String)"Unbinding mode activated. Right-click a block/entity to unbind it."), true);
            } else if (playerData != null && playerData.isUnbindingMode()) {
                playerData.disableBindingMode();
                player.sendSystemMessage((Component)Component.literal((String)"Unbinding mode disabled."), true);
            }
            PlayerDataAttachment newPlayerData = new PlayerDataAttachment();
            newPlayerData.copyFrom(playerData);
            Services.ATTACHMENT.setPlayerAttachment(player, newPlayerData, newPlayerData.getId());
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"stop-binding").requires(src -> src.hasPermission(2))).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            PlayerDataAttachment playerData = (PlayerDataAttachment)Services.ATTACHMENT.getPlayerAttachment((Player)player, PlayerDataAttachment.ID);
            if (playerData != null && (playerData.isBindingMode() || playerData.isUnbindingMode())) {
                playerData.disableBindingMode();
                PlayerDataAttachment newPlayerData = new PlayerDataAttachment();
                newPlayerData.copyFrom(playerData);
                Services.ATTACHMENT.setPlayerAttachment(player, newPlayerData, newPlayerData.getId());
                player.sendSystemMessage((Component)Component.literal((String)"Stopped binding/unbinding mode."), true);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"list-bindings").requires(src -> src.hasPermission(2))).executes(ctx -> {
            ChestMenuSavedData savedData = (ChestMenuSavedData)((CommandSourceStack)ctx.getSource()).getLevel().getDataStorage().computeIfAbsent(ChestMenuSavedData.ID);
            Collection<InteractiveBlock> interactiveBlocks = savedData.getMenuBlocks().values();
            if (interactiveBlocks.isEmpty()) {
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"No blocks are currently bound to menus.\n"), false);
            } else {
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Bound Blocks:"), false);
                for (InteractiveBlock block : interactiveBlocks) {
                    BlockPos pos = block.pos();
                    MutableComponent clickablePos = Component.literal((String)String.format("(%d, %d, %d)", pos.getX(), pos.getY(), pos.getZ())).withStyle(style -> style.withColor(65280).withUnderlined(Boolean.valueOf(true)).withClickEvent((ClickEvent)new ClickEvent.RunCommand(String.format("/tp %d %d %d", pos.getX(), pos.getY() + 1, pos.getZ()))).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)"Click to teleport to this block"))));
                    ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)String.format("- Menu ID: %s, Block Type: %s, Position: ", block.menuId(), block.blockType())).append((Component)clickablePos), false);
                }
            }
            Collection<InteractiveEntity> interactiveEntities = savedData.getMenuEntities().values();
            if (interactiveEntities.isEmpty()) {
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"No entities are currently bound to menus.\n"), false);
            } else {
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Bound Entities:"), false);
                for (InteractiveEntity entity : interactiveEntities) {
                    BlockPos pos = entity.lastSeen();
                    MutableComponent clickablePos = Component.literal((String)String.format("(%d, %d, %d)", pos.getX(), pos.getY(), pos.getZ())).withStyle(style -> style.withColor(65280).withUnderlined(Boolean.valueOf(true)).withClickEvent((ClickEvent)new ClickEvent.RunCommand(String.format("/tp %d %d %d", pos.getX(), pos.getY() + 1, pos.getZ()))).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)"Click to teleport to this entity"))));
                    ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)String.format("- Menu ID: %s, Entity Type: %s, Position: ", entity.menuId(), entity.entityType())).append((Component)clickablePos), false);
                }
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"bind-overlay").requires(src -> src.hasPermission(2))).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            PlayerDataAttachment playerData = (PlayerDataAttachment)Services.ATTACHMENT.getPlayerAttachment((Player)player, PlayerDataAttachment.ID);
            PlayerDataAttachment newPlayerData = new PlayerDataAttachment();
            playerData.setHasOverlay(!playerData.hasOverlay());
            newPlayerData.copyFrom(playerData);
            if (newPlayerData.hasOverlay()) {
                Utils.populatePlayerDataForSync(((CommandSourceStack)ctx.getSource()).getLevel(), newPlayerData, player);
                Memory.playersWithMenuHighlightEnabled.add(player.getUUID());
            } else {
                Memory.playersWithMenuHighlightEnabled.remove(player.getUUID());
            }
            Services.ATTACHMENT.setPlayerAttachment(player, newPlayerData, PlayerDataAttachment.ID);
            player.sendSystemMessage((Component)Component.literal((String)("Menu binding overlay " + (newPlayerData.hasOverlay() ? "enabled" : "disabled") + ".")), true);
            return 0;
        })));
    }
}

