/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dk.magnusjensen.customchestmenus.Utils;
import dk.magnusjensen.customchestmenus.models.interactivity.BindingMode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public class PlayerDataAttachment {
    public static final ResourceLocation ID = Utils.modLoc("player_data");
    public static final MapCodec<PlayerDataAttachment> MAP_CODEC = MapCodec.unit((Object)new PlayerDataAttachment());
    public static final Codec<PlayerDataAttachment> CODEC = MAP_CODEC.codec();
    public static final StreamCodec<RegistryFriendlyByteBuf, PlayerDataAttachment> SYNC_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, PlayerDataAttachment::hasOverlay, (StreamCodec)BlockPos.STREAM_CODEC.apply(ByteBufCodecs.list()), PlayerDataAttachment::boundBlocks, (StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs.list()), PlayerDataAttachment::boundEntities, PlayerDataAttachment::new);
    private BindingMode inBindingMode = BindingMode.NONE;
    private String menuToBind = null;
    private List<BlockPos> boundBlocks = new ArrayList<BlockPos>();
    private List<Integer> boundEntities = new ArrayList<Integer>();
    private boolean hasOverlay = false;

    public PlayerDataAttachment() {
    }

    public PlayerDataAttachment(boolean hasOverlay, List<BlockPos> boundBlocks, List<Integer> boundEntities) {
        this.hasOverlay = hasOverlay;
        this.boundBlocks = boundBlocks;
        this.boundEntities = boundEntities;
    }

    public ResourceLocation getId() {
        return ID;
    }

    public boolean isBindingMode() {
        return this.inBindingMode == BindingMode.BIND;
    }

    public boolean isUnbindingMode() {
        return this.inBindingMode == BindingMode.UNBIND;
    }

    public BindingMode getBindingMode() {
        return this.inBindingMode;
    }

    public String getMenuToBind() {
        return this.menuToBind;
    }

    public void activateBindingMode(String menuId) {
        this.inBindingMode = BindingMode.BIND;
        this.menuToBind = menuId;
    }

    public void activateUnbindingMode() {
        this.inBindingMode = BindingMode.UNBIND;
        this.menuToBind = null;
    }

    public void disableBindingMode() {
        this.inBindingMode = BindingMode.NONE;
        this.menuToBind = null;
    }

    public void setBoundBlocks(List<BlockPos> boundBlocks) {
        this.boundBlocks = boundBlocks;
    }

    public void setBoundEntities(List<Integer> boundEntities) {
        this.boundEntities = boundEntities;
    }

    public void resetServerSideVersionData() {
        this.boundBlocks = new ArrayList<BlockPos>();
        this.boundEntities = new ArrayList<Integer>();
    }

    public void copyFrom(PlayerDataAttachment existing) {
        this.inBindingMode = existing.getBindingMode();
        this.menuToBind = existing.getMenuToBind();
        this.hasOverlay = existing.hasOverlay();
        this.boundBlocks = existing.boundBlocks;
        this.boundEntities = existing.boundEntities;
    }

    public List<BlockPos> boundBlocks() {
        return new ArrayList<BlockPos>(this.boundBlocks);
    }

    public List<Integer> boundEntities() {
        return new ArrayList<Integer>(this.boundEntities);
    }

    public void setHasOverlay(boolean hasOverlay) {
        this.hasOverlay = hasOverlay;
    }

    public boolean hasOverlay() {
        return this.hasOverlay;
    }
}

