/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus.events;

import dk.magnusjensen.customchestmenus.Memory;
import dk.magnusjensen.customchestmenus.Utils;
import dk.magnusjensen.customchestmenus.data.ChestMenuSavedData;
import dk.magnusjensen.customchestmenus.data.PlayerDataAttachment;
import dk.magnusjensen.customchestmenus.models.interactivity.InteractiveBlock;
import dk.magnusjensen.customchestmenus.models.interactivity.InteractiveEntity;
import dk.magnusjensen.customchestmenus.platform.Services;
import dk.magnusjensen.customchestmenus.registry.CustomChestMenuRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class EventHandler {
    public static boolean onBlockRightClick(Player player, BlockPos pos, InteractionHand hand) {
        if (player.level().isClientSide()) {
            return false;
        }
        if (hand != InteractionHand.MAIN_HAND) {
            return false;
        }
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        Block block = serverPlayer.level().getBlockState(pos).getBlock();
        if (EventHandler.handleBlockBinding(pos, block, serverPlayer)) {
            return true;
        }
        return EventHandler.checkMenuBlock(pos, serverPlayer);
    }

    private static boolean handleBlockBinding(BlockPos pos, Block block, ServerPlayer serverPlayer) {
        PlayerDataAttachment playerData = (PlayerDataAttachment)Services.ATTACHMENT.getPlayerAttachment((Player)serverPlayer, PlayerDataAttachment.ID);
        if (playerData == null) {
            return false;
        }
        if (!playerData.isBindingMode() && !playerData.isUnbindingMode()) {
            return false;
        }
        ChestMenuSavedData savedData = (ChestMenuSavedData)serverPlayer.level().getDataStorage().computeIfAbsent(ChestMenuSavedData.ID);
        if (savedData.getMenuBlocks().containsKey(pos)) {
            if (playerData.isBindingMode()) {
                serverPlayer.sendSystemMessage((Component)Component.literal((String)"This block is already bound to a menu, to unbind it run /ccm unbind"), true);
                return true;
            }
            if (playerData.isUnbindingMode()) {
                savedData.removeMenuBlock(pos);
                serverPlayer.sendSystemMessage((Component)Component.literal((String)"Successfully unbound the menu from this block."), true);
                PlayerDataAttachment newPlayerData = new PlayerDataAttachment();
                newPlayerData.copyFrom(playerData);
                List<BlockPos> boundBlocks = playerData.boundBlocks();
                boundBlocks.remove(pos);
                newPlayerData.setBoundBlocks(boundBlocks);
                Services.ATTACHMENT.setPlayerAttachment(serverPlayer, newPlayerData, playerData.getId());
                return true;
            }
            return false;
        }
        if (playerData.isUnbindingMode()) {
            serverPlayer.sendSystemMessage((Component)Component.literal((String)"This block is not bound to any menu."), true);
            return true;
        }
        if (playerData.isBindingMode()) {
            ResourceLocation blockType = BuiltInRegistries.BLOCK.getKey((Object)block);
            savedData.addMenuBlock(new InteractiveBlock(playerData.getMenuToBind(), pos, blockType));
            serverPlayer.sendSystemMessage((Component)Component.literal((String)("Successfully bound menu '" + playerData.getMenuToBind() + "' to this block.")), true);
            PlayerDataAttachment newPlayerData = new PlayerDataAttachment();
            newPlayerData.copyFrom(playerData);
            newPlayerData.setBoundBlocks(savedData.getMenuBlocks().keySet().stream().toList());
            Services.ATTACHMENT.setPlayerAttachment(serverPlayer, newPlayerData, playerData.getId());
            return true;
        }
        return false;
    }

    private static boolean checkMenuBlock(BlockPos pos, ServerPlayer player) {
        ChestMenuSavedData savedData = (ChestMenuSavedData)player.level().getDataStorage().computeIfAbsent(ChestMenuSavedData.ID);
        if (!savedData.getMenuBlocks().containsKey(pos)) {
            return false;
        }
        InteractiveBlock interactiveBlock = savedData.getMenuBlocks().get(pos);
        Services.NETWORK.openChestMenuScreen(player, CustomChestMenuRegistry.get(interactiveBlock.menuId()), 0);
        return true;
    }

    public static boolean onEntityRightClick(Player player, Entity target, InteractionHand hand) {
        if (player.level().isClientSide()) {
            return false;
        }
        if (hand != InteractionHand.MAIN_HAND) {
            return false;
        }
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (EventHandler.handleEntityBinding(target, serverPlayer)) {
            return true;
        }
        return EventHandler.checkMenuEntity(target, serverPlayer);
    }

    private static boolean handleEntityBinding(Entity entity, ServerPlayer serverPlayer) {
        PlayerDataAttachment playerData = (PlayerDataAttachment)Services.ATTACHMENT.getPlayerAttachment((Player)serverPlayer, PlayerDataAttachment.ID);
        if (playerData == null) {
            return false;
        }
        if (!playerData.isBindingMode() && !playerData.isUnbindingMode()) {
            return false;
        }
        ChestMenuSavedData savedData = (ChestMenuSavedData)serverPlayer.level().getDataStorage().computeIfAbsent(ChestMenuSavedData.ID);
        if (savedData.getMenuEntities().containsKey(entity.getUUID())) {
            if (playerData.isBindingMode()) {
                serverPlayer.sendSystemMessage((Component)Component.literal((String)"This entity is already bound to a menu, to unbind it run /ccm unbind and right click"), true);
                return true;
            }
            if (playerData.isUnbindingMode()) {
                savedData.removeMenuEntity(entity.getUUID());
                serverPlayer.sendSystemMessage((Component)Component.literal((String)"Successfully unbound the menu from this entity."), true);
                List<Integer> boundEntities = playerData.boundEntities();
                boundEntities.remove((Object)entity.getId());
                PlayerDataAttachment newPlayerData = new PlayerDataAttachment();
                newPlayerData.copyFrom(playerData);
                newPlayerData.setBoundEntities(boundEntities);
                Services.ATTACHMENT.setPlayerAttachment(serverPlayer, newPlayerData, playerData.getId());
                return true;
            }
            return false;
        }
        if (playerData.isUnbindingMode()) {
            serverPlayer.sendSystemMessage((Component)Component.literal((String)"This entity is not bound to any menu."), true);
            return true;
        }
        if (playerData.isBindingMode()) {
            ResourceLocation entityType = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
            savedData.addMenuEntity(new InteractiveEntity(playerData.getMenuToBind(), entity.getUUID(), entity.blockPosition(), entityType));
            serverPlayer.sendSystemMessage((Component)Component.literal((String)("Successfully bound menu '" + playerData.getMenuToBind() + "' to this entity.")), true);
            List<Integer> boundEntities = playerData.boundEntities();
            boundEntities.add(entity.getId());
            PlayerDataAttachment newPlayerData = new PlayerDataAttachment();
            newPlayerData.copyFrom(playerData);
            newPlayerData.setBoundEntities(boundEntities);
            Services.ATTACHMENT.setPlayerAttachment(serverPlayer, newPlayerData, playerData.getId());
            return true;
        }
        return false;
    }

    private static boolean checkMenuEntity(Entity entity, ServerPlayer player) {
        ChestMenuSavedData savedData = (ChestMenuSavedData)player.level().getDataStorage().computeIfAbsent(ChestMenuSavedData.ID);
        InteractiveEntity interactiveEntity = savedData.getMenuEntities().get(entity.getUUID());
        if (interactiveEntity == null) {
            return false;
        }
        Services.NETWORK.openChestMenuScreen(player, CustomChestMenuRegistry.get(interactiveEntity.menuId()), 0);
        return true;
    }

    public static void onEntityUnload(Entity entity) {
        Level level;
        if (entity.level().isClientSide() || !((level = entity.level()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ChestMenuSavedData savedData = (ChestMenuSavedData)serverLevel.getDataStorage().computeIfAbsent(ChestMenuSavedData.ID);
        InteractiveEntity interactiveEntity = savedData.getMenuEntities().get(entity.getUUID());
        if (interactiveEntity == null) {
            return;
        }
        savedData.addMenuEntity(interactiveEntity.setLastSeen(entity.blockPosition()));
    }

    public static void onPlayerStopTracking(Player player, Entity entity) {
        Level level;
        if (player.level().isClientSide() || !((level = player.level()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (!Memory.playersWithMenuHighlightEnabled.contains(player.getUUID())) {
            return;
        }
        ChestMenuSavedData savedData = (ChestMenuSavedData)serverLevel.getDataStorage().computeIfAbsent(ChestMenuSavedData.ID);
        InteractiveEntity interactiveEntity = savedData.getMenuEntities().get(entity.getUUID());
        if (interactiveEntity == null) {
            return;
        }
        PlayerDataAttachment playerData = (PlayerDataAttachment)Services.ATTACHMENT.getPlayerAttachment(player, PlayerDataAttachment.ID);
        List<Integer> boundEntities = playerData.boundEntities();
        PlayerDataAttachment newPlayerData = new PlayerDataAttachment();
        newPlayerData.copyFrom(playerData);
        boundEntities.remove((Object)entity.getId());
        newPlayerData.setBoundEntities(boundEntities);
        Services.ATTACHMENT.setPlayerAttachment(serverPlayer, newPlayerData, PlayerDataAttachment.ID);
    }

    public static void onPlayerStartTracking(Player player, Entity entity) {
        Level level;
        if (player.level().isClientSide() || !((level = player.level()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (!Memory.playersWithMenuHighlightEnabled.contains(player.getUUID())) {
            return;
        }
        ChestMenuSavedData savedData = (ChestMenuSavedData)serverLevel.getDataStorage().computeIfAbsent(ChestMenuSavedData.ID);
        InteractiveEntity interactiveEntity = savedData.getMenuEntities().get(entity.getUUID());
        if (interactiveEntity == null) {
            return;
        }
        PlayerDataAttachment playerData = (PlayerDataAttachment)Services.ATTACHMENT.getPlayerAttachment(player, PlayerDataAttachment.ID);
        List<Integer> boundEntities = playerData.boundEntities();
        boundEntities.add(entity.getId());
        PlayerDataAttachment newPlayerData = new PlayerDataAttachment();
        newPlayerData.copyFrom(playerData);
        newPlayerData.setBoundEntities(boundEntities);
        Services.ATTACHMENT.setPlayerAttachment(serverPlayer, newPlayerData, PlayerDataAttachment.ID);
    }

    public static void onPlayerChangeDimension(ServerPlayer player, ServerLevel level) {
        if (!Memory.playersWithMenuHighlightEnabled.contains(player.getUUID())) {
            return;
        }
        PlayerDataAttachment playerData = (PlayerDataAttachment)Services.ATTACHMENT.getPlayerAttachment((Player)player, PlayerDataAttachment.ID);
        PlayerDataAttachment newPlayerData = new PlayerDataAttachment();
        newPlayerData.copyFrom(playerData);
        Utils.populatePlayerDataForSync(level, newPlayerData, player);
        Services.ATTACHMENT.setPlayerAttachment(player, newPlayerData, newPlayerData.getId());
    }

    public static void onPlayerLeaveServer(ServerPlayer player) {
        Memory.playersWithMenuHighlightEnabled.remove(player.getUUID());
    }
}

